/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.client.BaseClient;
import ca.uhn.fhir.rest.client.ClientInvocationHandlerFactory;
import ca.uhn.fhir.rest.client.GenericClient;
import ca.uhn.fhir.rest.client.IClientInterceptor;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.exceptions.FhirClientConnectionException;
import ca.uhn.fhir.rest.client.exceptions.FhirClientInappropriateForServerException;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.util.FhirTerser;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestfulClientFactory
implements IRestfulClientFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulClientFactory.class);
    private int myConnectionRequestTimeout = 10000;
    private int myConnectTimeout = 10000;
    private FhirContext myContext;
    private Map<Class<? extends IRestfulClient>, ClientInvocationHandlerFactory> myInvocationHandlers = new HashMap<Class<? extends IRestfulClient>, ClientInvocationHandlerFactory>();
    private ServerValidationModeEnum myServerValidationMode = DEFAULT_SERVER_VALIDATION_MODE;
    private int mySocketTimeout = 10000;
    private Set<String> myValidatedServerBaseUrls = Collections.synchronizedSet(new HashSet());
    private String myProxyUsername;
    private String myProxyPassword;
    private int myPoolMaxTotal = 20;
    private int myPoolMaxPerRoute = 20;

    public RestfulClientFactory() {
    }

    public RestfulClientFactory(FhirContext theFhirContext) {
        this.myContext = theFhirContext;
    }

    @Override
    public int getConnectionRequestTimeout() {
        return this.myConnectionRequestTimeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.myConnectTimeout;
    }

    protected String getProxyUsername() {
        return this.myProxyUsername;
    }

    protected String getProxyPassword() {
        return this.myProxyPassword;
    }

    @Override
    public void setProxyCredentials(String theUsername, String thePassword) {
        this.myProxyUsername = theUsername;
        this.myProxyPassword = thePassword;
    }

    @Override
    public ServerValidationModeEnum getServerValidationMode() {
        return this.myServerValidationMode;
    }

    @Override
    public int getSocketTimeout() {
        return this.mySocketTimeout;
    }

    @Override
    public int getPoolMaxTotal() {
        return this.myPoolMaxTotal;
    }

    @Override
    public int getPoolMaxPerRoute() {
        return this.myPoolMaxPerRoute;
    }

    private <T extends IRestfulClient> T instantiateProxy(Class<T> theClientType, InvocationHandler theInvocationHandler) {
        IRestfulClient proxy = (IRestfulClient)Proxy.newProxyInstance(theClientType.getClassLoader(), new Class[]{theClientType}, theInvocationHandler);
        return (T)proxy;
    }

    @Override
    public synchronized <T extends IRestfulClient> T newClient(Class<T> theClientType, String theServerBase) {
        this.validateConfigured();
        if (!theClientType.isInterface()) {
            throw new ConfigurationException(theClientType.getCanonicalName() + " is not an interface");
        }
        ClientInvocationHandlerFactory invocationHandler = this.myInvocationHandlers.get(theClientType);
        if (invocationHandler == null) {
            IHttpClient httpClient = this.getHttpClient(theServerBase);
            invocationHandler = new ClientInvocationHandlerFactory(httpClient, this.myContext, theServerBase, theClientType);
            for (Method nextMethod : theClientType.getMethods()) {
                BaseMethodBinding<?> binding = BaseMethodBinding.bindMethod(nextMethod, this.myContext, null);
                invocationHandler.addBinding(nextMethod, binding);
            }
            this.myInvocationHandlers.put(theClientType, invocationHandler);
        }
        T proxy = this.instantiateProxy(theClientType, invocationHandler.newInvocationHandler(this));
        return proxy;
    }

    protected void validateConfigured() {
        if (this.getFhirContext() == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have FhirContext defined. This must be set via " + this.getClass().getSimpleName() + "#setFhirContext(FhirContext)");
        }
    }

    @Override
    public synchronized IGenericClient newGenericClient(String theServerBase) {
        this.validateConfigured();
        IHttpClient httpClient = this.getHttpClient(theServerBase);
        return new GenericClient(this.myContext, httpClient, theServerBase, this);
    }

    @Override
    public void validateServerBaseIfConfiguredToDoSo(String theServerBase, IHttpClient theHttpClient, BaseClient theClient) {
        String serverBase = this.normalizeBaseUrlForMap(theServerBase);
        switch (this.getServerValidationMode()) {
            case NEVER: {
                break;
            }
            case ONCE: {
                if (this.myValidatedServerBaseUrls.contains(serverBase)) break;
                this.validateServerBase(serverBase, theHttpClient, theClient);
            }
        }
    }

    private String normalizeBaseUrlForMap(String theServerBase) {
        String serverBase = theServerBase;
        if (!serverBase.endsWith("/")) {
            serverBase = serverBase + "/";
        }
        return serverBase;
    }

    @Override
    public synchronized void setConnectionRequestTimeout(int theConnectionRequestTimeout) {
        this.myConnectionRequestTimeout = theConnectionRequestTimeout;
        this.resetHttpClient();
    }

    @Override
    public synchronized void setConnectTimeout(int theConnectTimeout) {
        this.myConnectTimeout = theConnectTimeout;
        this.resetHttpClient();
    }

    public void setFhirContext(FhirContext theContext) {
        if (this.myContext != null && this.myContext != theContext) {
            throw new IllegalStateException("RestfulClientFactory instance is already associated with one FhirContext. RestfulClientFactory instances can not be shared.");
        }
        this.myContext = theContext;
    }

    public FhirContext getFhirContext() {
        return this.myContext;
    }

    @Override
    public void setServerValidationMode(ServerValidationModeEnum theServerValidationMode) {
        Validate.notNull((Object)((Object)theServerValidationMode), (String)"theServerValidationMode may not be null", (Object[])new Object[0]);
        this.myServerValidationMode = theServerValidationMode;
    }

    @Override
    public synchronized void setSocketTimeout(int theSocketTimeout) {
        this.mySocketTimeout = theSocketTimeout;
        this.resetHttpClient();
    }

    @Override
    public synchronized void setPoolMaxTotal(int thePoolMaxTotal) {
        this.myPoolMaxTotal = thePoolMaxTotal;
        this.resetHttpClient();
    }

    @Override
    public synchronized void setPoolMaxPerRoute(int thePoolMaxPerRoute) {
        this.myPoolMaxPerRoute = thePoolMaxPerRoute;
        this.resetHttpClient();
    }

    @Override
    public void validateServerBase(String theServerBase, IHttpClient theHttpClient, BaseClient theClient) {
        FhirVersionEnum contextFhirVersion;
        IBaseResource conformance;
        block16: {
            GenericClient client = new GenericClient(this.myContext, theHttpClient, theServerBase, this);
            client.setEncoding(theClient.getEncoding());
            for (IClientInterceptor interceptor : theClient.getInterceptors()) {
                client.registerInterceptor(interceptor);
            }
            client.setDontValidateConformance(true);
            try {
                String capabilityStatementResourceName = "CapabilityStatement";
                if (this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                    capabilityStatementResourceName = "Conformance";
                }
                Class implementingClass = this.myContext.getResourceDefinition(capabilityStatementResourceName).getImplementingClass();
                try {
                    conformance = (IBaseResource)client.fetchConformance().ofType(implementingClass).execute();
                }
                catch (FhirClientConnectionException e) {
                    if (!this.myContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3) && e.getCause() instanceof DataFormatException) {
                        capabilityStatementResourceName = "Conformance";
                        implementingClass = this.myContext.getResourceDefinition(capabilityStatementResourceName).getImplementingClass();
                        conformance = (IBaseResource)client.fetchConformance().ofType(implementingClass).execute();
                        break block16;
                    }
                    throw e;
                }
            }
            catch (FhirClientConnectionException e) {
                String msg = this.myContext.getLocalizer().getMessage(RestfulClientFactory.class, "failedToRetrieveConformance", theServerBase + "metadata");
                throw new FhirClientConnectionException(msg, (Throwable)e);
            }
        }
        FhirTerser t = this.myContext.newTerser();
        String serverFhirVersionString = null;
        Object value = t.getSingleValueOrNull(conformance, "fhirVersion");
        if (value instanceof IPrimitiveType) {
            serverFhirVersionString = ((IPrimitiveType)value).getValueAsString();
        }
        FhirVersionEnum serverFhirVersionEnum = null;
        if (!StringUtils.isBlank((CharSequence)serverFhirVersionString)) {
            if (serverFhirVersionString.startsWith("0.80") || serverFhirVersionString.startsWith("0.0.8")) {
                serverFhirVersionEnum = FhirVersionEnum.DSTU1;
            } else if (serverFhirVersionString.startsWith("0.4")) {
                serverFhirVersionEnum = FhirVersionEnum.DSTU2;
            } else if (serverFhirVersionString.startsWith("0.5")) {
                serverFhirVersionEnum = FhirVersionEnum.DSTU2;
            } else {
                ourLog.debug("Server conformance statement indicates unknown FHIR version: {}", (Object)serverFhirVersionString);
            }
        }
        if (serverFhirVersionEnum != null && !(contextFhirVersion = this.myContext.getVersion().getVersion()).isEquivalentTo(serverFhirVersionEnum)) {
            throw new FhirClientInappropriateForServerException(this.myContext.getLocalizer().getMessage(RestfulClientFactory.class, "wrongVersionInConformance", new Object[]{theServerBase + "metadata", serverFhirVersionString, serverFhirVersionEnum, contextFhirVersion}));
        }
        this.myValidatedServerBaseUrls.add(this.normalizeBaseUrlForMap(theServerBase));
    }

    @Override
    public ServerValidationModeEnum getServerValidationModeEnum() {
        return this.getServerValidationMode();
    }

    @Override
    public void setServerValidationModeEnum(ServerValidationModeEnum theServerValidationMode) {
        this.setServerValidationMode(theServerValidationMode);
    }

    protected abstract IHttpClient getHttpClient(String var1);

    protected abstract void resetHttpClient();
}

