/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.BaseBundle;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IJsonLikeParser;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParseLocation;
import ca.uhn.fhir.parser.ParserState;
import ca.uhn.fhir.parser.json.GsonStructure;
import ca.uhn.fhir.parser.json.JsonLikeArray;
import ca.uhn.fhir.parser.json.JsonLikeObject;
import ca.uhn.fhir.parser.json.JsonLikeStructure;
import ca.uhn.fhir.parser.json.JsonLikeValue;
import ca.uhn.fhir.parser.json.JsonLikeWriter;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.util.ElementUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseDecimalDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseIntegerDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParser
extends BaseParser
implements IJsonLikeParser {
    private static final Set<String> BUNDLE_TEXTNODE_CHILDREN_DSTU1;
    private static final Set<String> BUNDLE_TEXTNODE_CHILDREN_DSTU2;
    private static final Logger ourLog;
    private FhirContext myContext;
    private boolean myPrettyPrint;

    public JsonParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        super(theContext, theParserErrorHandler);
        this.myContext = theContext;
    }

    private boolean addToHeldComments(int valueIdx, List<String> theCommentsToAdd, ArrayList<ArrayList<String>> theListToAddTo) {
        if (theCommentsToAdd.size() > 0) {
            theListToAddTo.ensureCapacity(valueIdx);
            while (theListToAddTo.size() <= valueIdx) {
                theListToAddTo.add(null);
            }
            if (theListToAddTo.get(valueIdx) == null) {
                theListToAddTo.set(valueIdx, new ArrayList());
            }
            theListToAddTo.get(valueIdx).addAll(theCommentsToAdd);
            return true;
        }
        return false;
    }

    private boolean addToHeldExtensions(int valueIdx, List<? extends IBaseExtension<?, ?>> ext, ArrayList<ArrayList<HeldExtension>> list, boolean theIsModifier, BaseParser.CompositeChildElement theChildElem) {
        if (ext.size() > 0) {
            list.ensureCapacity(valueIdx);
            while (list.size() <= valueIdx) {
                list.add(null);
            }
            if (list.get(valueIdx) == null) {
                list.set(valueIdx, new ArrayList());
            }
            for (IBaseExtension<?, ?> next : ext) {
                list.get(valueIdx).add(new HeldExtension(next, theIsModifier, theChildElem));
            }
            return true;
        }
        return false;
    }

    private void addToHeldIds(int theValueIdx, ArrayList<String> theListToAddTo, String theId) {
        theListToAddTo.ensureCapacity(theValueIdx);
        while (theListToAddTo.size() <= theValueIdx) {
            theListToAddTo.add(null);
        }
        if (theListToAddTo.get(theValueIdx) == null) {
            theListToAddTo.set(theValueIdx, theId);
        }
    }

    private void assertObjectOfType(JsonLikeValue theResourceTypeObj, Object theValueType, String thePosition) {
    }

    private void beginArray(JsonLikeWriter theEventWriter, String arrayName) throws IOException {
        theEventWriter.beginArray(arrayName);
    }

    private void beginObject(JsonLikeWriter theEventWriter, String arrayName) throws IOException {
        theEventWriter.beginObject(arrayName);
    }

    private JsonLikeWriter createJsonWriter(Writer theWriter) {
        GsonStructure jsonStructure = new GsonStructure();
        JsonLikeWriter retVal = jsonStructure.getJsonLikeWriter(theWriter);
        return retVal;
    }

    @Override
    public void doEncodeBundleToWriter(Bundle theBundle, Writer theWriter) throws IOException {
        JsonLikeWriter eventWriter = this.createJsonWriter(theWriter);
        this.doEncodeBundleToJsonLikeWriter(theBundle, eventWriter);
    }

    public void doEncodeBundleToJsonLikeWriter(Bundle theBundle, JsonLikeWriter theEventWriter) throws IOException {
        if (this.myPrettyPrint) {
            theEventWriter.setPrettyPrint(this.myPrettyPrint);
        }
        theEventWriter.init();
        if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            this.encodeBundleToWriterInDstu2Format(theBundle, theEventWriter);
        } else {
            this.encodeBundleToWriterInDstu1Format(theBundle, theEventWriter);
        }
        theEventWriter.flush();
    }

    @Override
    protected void doEncodeResourceToWriter(IBaseResource theResource, Writer theWriter) throws IOException {
        JsonLikeWriter eventWriter = this.createJsonWriter(theWriter);
        this.doEncodeResourceToJsonLikeWriter(theResource, eventWriter);
    }

    public void doEncodeResourceToJsonLikeWriter(IBaseResource theResource, JsonLikeWriter theEventWriter) throws IOException {
        if (this.myPrettyPrint) {
            theEventWriter.setPrettyPrint(this.myPrettyPrint);
        }
        theEventWriter.init();
        RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
        this.encodeResourceToJsonStreamWriter(resDef, theResource, theEventWriter, null, false, false);
        theEventWriter.flush();
    }

    @Override
    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, Reader theReader) {
        GsonStructure jsonStructure = new GsonStructure();
        jsonStructure.load(theReader);
        T retVal = this.doParseResource(theResourceType, jsonStructure);
        return retVal;
    }

    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, JsonLikeStructure theJsonStructure) {
        JsonLikeObject object = theJsonStructure.getRootObject();
        JsonLikeValue resourceTypeObj = object.get("resourceType");
        if (resourceTypeObj == null || !resourceTypeObj.isString() || StringUtils.isBlank((CharSequence)resourceTypeObj.getAsString())) {
            throw new DataFormatException("Invalid JSON content detected, missing required element: 'resourceType'");
        }
        String resourceType = resourceTypeObj.getAsString();
        ParserState<T> state = ParserState.getPreResourceInstance(this, theResourceType, this.myContext, true, this.getErrorHandler());
        state.enteringNewElement(null, resourceType);
        this.parseChildren(object, state);
        state.endingElement();
        state.endingElement();
        IBaseResource retVal = (IBaseResource)state.getObject();
        return (T)retVal;
    }

    @Override
    public void encodeBundleToJsonLikeWriter(Bundle theBundle, JsonLikeWriter theJsonLikeWriter) throws IOException, DataFormatException {
        Validate.notNull((Object)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theJsonLikeWriter, (String)"theJsonLikeWriter must not be null", (Object[])new Object[0]);
        this.doEncodeBundleToJsonLikeWriter(theBundle, theJsonLikeWriter);
    }

    private void encodeBundleToWriterInDstu1Format(Bundle theBundle, JsonLikeWriter theEventWriter) throws IOException {
        theEventWriter.beginObject();
        JsonParser.write(theEventWriter, "resourceType", "Bundle");
        this.writeTagWithTextNode(theEventWriter, "title", theBundle.getTitle());
        this.writeTagWithTextNode(theEventWriter, "id", theBundle.getBundleId());
        this.writeOptionalTagWithTextNode(theEventWriter, "updated", theBundle.getUpdated());
        boolean linkStarted = false;
        linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "self", theBundle.getLinkSelf(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "first", theBundle.getLinkFirst(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "previous", theBundle.getLinkPrevious(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "next", theBundle.getLinkNext(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "last", theBundle.getLinkLast(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "fhir-base", theBundle.getLinkBase(), linkStarted);
        if (linkStarted) {
            theEventWriter.endArray();
        }
        this.writeCategories(theEventWriter, theBundle.getCategories());
        this.writeOptionalTagWithTextNode(theEventWriter, "totalResults", theBundle.getTotalResults());
        this.writeAuthor(theBundle, theEventWriter);
        this.beginArray(theEventWriter, "entry");
        for (BundleEntry nextEntry : theBundle.getEntries()) {
            boolean deleted;
            theEventWriter.beginObject();
            boolean bl = deleted = nextEntry.getDeletedAt() != null && !nextEntry.getDeletedAt().isEmpty();
            if (deleted) {
                this.writeTagWithTextNode(theEventWriter, "deleted", nextEntry.getDeletedAt());
            }
            this.writeTagWithTextNode(theEventWriter, "title", nextEntry.getTitle());
            this.writeTagWithTextNode(theEventWriter, "id", nextEntry.getId());
            linkStarted = false;
            linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "self", nextEntry.getLinkSelf(), linkStarted);
            linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "alternate", nextEntry.getLinkAlternate(), linkStarted);
            linkStarted = this.writeAtomLinkInDstu1Format(theEventWriter, "search", nextEntry.getLinkSearch(), linkStarted);
            if (linkStarted) {
                theEventWriter.endArray();
            }
            this.writeOptionalTagWithTextNode(theEventWriter, "updated", nextEntry.getUpdated());
            this.writeOptionalTagWithTextNode(theEventWriter, "published", nextEntry.getPublished());
            this.writeCategories(theEventWriter, nextEntry.getCategories());
            this.writeAuthor(nextEntry, theEventWriter);
            IResource resource = nextEntry.getResource();
            if (resource != null && !resource.isEmpty() && !deleted) {
                RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(resource);
                this.encodeResourceToJsonStreamWriter(resDef, (IBaseResource)resource, theEventWriter, "content", false, true);
            }
            if (!nextEntry.getSummary().isEmpty()) {
                JsonParser.write(theEventWriter, "summary", nextEntry.getSummary().getValueAsString());
            }
            theEventWriter.endObject();
        }
        theEventWriter.endArray();
        theEventWriter.endObject();
    }

    private void encodeBundleToWriterInDstu2Format(Bundle theBundle, JsonLikeWriter theEventWriter) throws IOException {
        theEventWriter.beginObject();
        JsonParser.write(theEventWriter, "resourceType", "Bundle");
        this.writeOptionalTagWithTextNode(theEventWriter, "id", theBundle.getId().getIdPart());
        if (!ElementUtil.isEmpty(theBundle.getId().getVersionIdPart(), theBundle.getUpdated())) {
            this.beginObject(theEventWriter, "meta");
            this.writeOptionalTagWithTextNode(theEventWriter, "versionId", theBundle.getId().getVersionIdPart());
            this.writeOptionalTagWithTextNode(theEventWriter, "lastUpdated", theBundle.getUpdated());
            theEventWriter.endObject();
        }
        this.writeOptionalTagWithTextNode(theEventWriter, "type", theBundle.getType());
        this.writeOptionalTagWithNumberNode(theEventWriter, "total", theBundle.getTotalResults());
        boolean linkStarted = false;
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "next", theBundle.getLinkNext(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "self", theBundle.getLinkSelf(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "first", theBundle.getLinkFirst(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "previous", theBundle.getLinkPrevious(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "last", theBundle.getLinkLast(), linkStarted);
        if (linkStarted) {
            theEventWriter.endArray();
        }
        this.beginArray(theEventWriter, "entry");
        for (BundleEntry nextEntry : theBundle.getEntries()) {
            theEventWriter.beginObject();
            if (nextEntry.getResource() != null && nextEntry.getResource().getId().getBaseUrl() != null) {
                this.writeOptionalTagWithTextNode(theEventWriter, "fullUrl", nextEntry.getResource().getId().getValue());
            }
            boolean deleted = nextEntry.getDeletedAt() != null && !nextEntry.getDeletedAt().isEmpty();
            IResource resource = nextEntry.getResource();
            if (resource != null && !resource.isEmpty() && !deleted) {
                RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(resource);
                this.encodeResourceToJsonStreamWriter(resDef, (IBaseResource)resource, theEventWriter, "resource", false, true);
            }
            if (!nextEntry.getSearchMode().isEmpty() || !nextEntry.getScore().isEmpty()) {
                this.beginObject(theEventWriter, "search");
                this.writeOptionalTagWithTextNode(theEventWriter, "mode", nextEntry.getSearchMode().getValueAsString());
                this.writeOptionalTagWithDecimalNode(theEventWriter, "score", nextEntry.getScore());
                theEventWriter.endObject();
            }
            if (!nextEntry.getTransactionMethod().isEmpty() || !nextEntry.getLinkSearch().isEmpty()) {
                this.beginObject(theEventWriter, "request");
                this.writeOptionalTagWithTextNode(theEventWriter, "method", (String)nextEntry.getTransactionMethod().getValue());
                this.writeOptionalTagWithTextNode(theEventWriter, "url", (String)nextEntry.getLinkSearch().getValue());
                theEventWriter.endObject();
            }
            if (deleted) {
                this.beginObject(theEventWriter, "deleted");
                if (nextEntry.getResource() != null) {
                    JsonParser.write(theEventWriter, "type", this.myContext.getResourceDefinition(nextEntry.getResource()).getName());
                    this.writeOptionalTagWithTextNode(theEventWriter, "resourceId", nextEntry.getResource().getId().getIdPart());
                    this.writeOptionalTagWithTextNode(theEventWriter, "versionId", nextEntry.getResource().getId().getVersionIdPart());
                }
                this.writeTagWithTextNode(theEventWriter, "instant", nextEntry.getDeletedAt());
                theEventWriter.endObject();
            }
            if (!nextEntry.getSummary().isEmpty()) {
                JsonParser.write(theEventWriter, "summary", nextEntry.getSummary().getValueAsString());
            }
            theEventWriter.endObject();
        }
        theEventWriter.endArray();
        theEventWriter.endObject();
    }

    private void encodeChildElementToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, IBase theNextValue, BaseRuntimeElementDefinition<?> theChildDef, String theChildName, boolean theContainedResource, BaseParser.CompositeChildElement theChildElem, boolean theForceEmpty) throws IOException {
        switch (theChildDef.getChildType()) {
            case ID_DATATYPE: {
                String encodedValue;
                IIdType value = (IIdType)theNextValue;
                String string = encodedValue = "id".equals(theChildName) ? value.getIdPart() : value.getValue();
                if (StringUtils.isBlank((CharSequence)encodedValue)) break;
                if (theChildName != null) {
                    JsonParser.write(theEventWriter, theChildName, encodedValue);
                    break;
                }
                theEventWriter.write(encodedValue);
                break;
            }
            case PRIMITIVE_DATATYPE: {
                final IPrimitiveType value = (IPrimitiveType)theNextValue;
                if (StringUtils.isBlank((CharSequence)value.getValueAsString())) {
                    if (!theForceEmpty) break;
                    theEventWriter.writeNull();
                    break;
                }
                if (value instanceof IBaseIntegerDatatype) {
                    if (theChildName != null) {
                        this.write(theEventWriter, theChildName, (Integer)((IBaseIntegerDatatype)value).getValue());
                        break;
                    }
                    theEventWriter.write(((Integer)((IBaseIntegerDatatype)value).getValue()).intValue());
                    break;
                }
                if (value instanceof IBaseDecimalDatatype) {
                    BigDecimal decimalValue = (BigDecimal)((IBaseDecimalDatatype)value).getValue();
                    decimalValue = new BigDecimal(decimalValue.toString()){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String toString() {
                            return value.getValueAsString();
                        }
                    };
                    if (theChildName != null) {
                        this.write(theEventWriter, theChildName, decimalValue);
                        break;
                    }
                    theEventWriter.write(decimalValue);
                    break;
                }
                if (value instanceof IBaseBooleanDatatype) {
                    if (theChildName != null) {
                        this.write(theEventWriter, theChildName, (Boolean)((IBaseBooleanDatatype)value).getValue());
                        break;
                    }
                    Boolean booleanValue = (Boolean)((IBaseBooleanDatatype)value).getValue();
                    if (booleanValue == null) break;
                    theEventWriter.write((boolean)booleanValue);
                    break;
                }
                String valueStr = value.getValueAsString();
                if (theChildName != null) {
                    JsonParser.write(theEventWriter, theChildName, valueStr);
                    break;
                }
                theEventWriter.write(valueStr);
                break;
            }
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                if (theChildName != null) {
                    theEventWriter.beginObject(theChildName);
                } else {
                    theEventWriter.beginObject();
                }
                this.encodeCompositeElementToStreamWriter(theResDef, theResource, theNextValue, theEventWriter, theContainedResource, theChildElem);
                theEventWriter.endObject();
                break;
            }
            case CONTAINED_RESOURCE_LIST: 
            case CONTAINED_RESOURCES: {
                List<IBaseResource> containedResources = this.getContainedResources().getContainedResources();
                if (containedResources.size() <= 0) break;
                this.beginArray(theEventWriter, theChildName);
                for (IBaseResource next : containedResources) {
                    IIdType resourceId = this.getContainedResources().getResourceId(next);
                    this.encodeResourceToJsonStreamWriter(theResDef, next, theEventWriter, null, true, this.fixContainedResourceId(resourceId.getValue()));
                }
                theEventWriter.endArray();
                break;
            }
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: {
                if (!this.isSuppressNarratives()) {
                    IPrimitiveType dt = (IPrimitiveType)theNextValue;
                    if (theChildName != null) {
                        JsonParser.write(theEventWriter, theChildName, dt.getValueAsString());
                        break;
                    }
                    theEventWriter.write(dt.getValueAsString());
                    break;
                }
                if (theChildName != null) break;
                theEventWriter.writeNull();
                break;
            }
            case RESOURCE: {
                IBaseResource resource = (IBaseResource)theNextValue;
                RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resource);
                this.encodeResourceToJsonStreamWriter(def, resource, theEventWriter, theChildName, false, true);
                break;
            }
            default: {
                throw new IllegalStateException("Should not have this state here: " + theChildDef.getChildType().name());
            }
        }
    }

    private void encodeCompositeElementChildrenToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, IBase theElement, JsonLikeWriter theEventWriter, boolean theContainedResource, BaseParser.CompositeChildElement theParent) throws IOException {
        String elementId = this.getCompositeElementId(theElement);
        if (StringUtils.isNotBlank((CharSequence)elementId)) {
            JsonParser.write(theEventWriter, "id", elementId);
        }
        boolean haveWrittenExtensions = false;
        for (BaseParser.CompositeChildElement nextChildElem : super.compositeChildIterator(theElement, theContainedResource, theParent)) {
            BaseRuntimeChildDefinition nextChild = nextChildElem.getDef();
            if (nextChildElem.getDef().getElementName().equals("extension") || nextChildElem.getDef().getElementName().equals("modifierExtension") || nextChild instanceof RuntimeChildDeclaredExtensionDefinition) {
                if (haveWrittenExtensions) continue;
                this.extractAndWriteExtensionsAsDirectChild(theElement, theEventWriter, this.myContext.getElementDefinition(theElement.getClass()), theResDef, theResource, nextChildElem);
                haveWrittenExtensions = true;
                continue;
            }
            if (nextChild instanceof RuntimeChildNarrativeDefinition) {
                INarrative narr;
                INarrativeGenerator gen = this.myContext.getNarrativeGenerator();
                if (gen != null && (narr = theResource instanceof IResource ? ((IResource)theResource).getText() : (theResource instanceof IDomainResource ? ((IDomainResource)theResource).getText() : null)) != null && narr.isEmpty()) {
                    gen.generateNarrative(this.myContext, theResource, narr);
                    if (narr != null && !narr.isEmpty()) {
                        RuntimeChildNarrativeDefinition child = (RuntimeChildNarrativeDefinition)nextChild;
                        String childName = nextChild.getChildNameByDatatype(child.getDatatype());
                        BaseRuntimeElementDefinition<?> type = child.getChildByName(childName);
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, narr, type, childName, theContainedResource, nextChildElem, false);
                        continue;
                    }
                }
            } else if (nextChild instanceof RuntimeChildContainedResources) {
                String childName = nextChild.getValidChildNames().iterator().next();
                BaseRuntimeElementDefinition<?> child = nextChild.getChildByName(childName);
                this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, null, child, childName, theContainedResource, nextChildElem, false);
                continue;
            }
            List<IBase> values = nextChild.getAccessor().getValues(theElement);
            if ((values = super.preProcessValues(nextChild, theResource, values, nextChildElem)) == null || values.isEmpty()) continue;
            String currentChildName = null;
            boolean inArray = false;
            ArrayList<ArrayList<HeldExtension>> extensions = new ArrayList<ArrayList<HeldExtension>>(0);
            ArrayList<ArrayList<HeldExtension>> modifierExtensions = new ArrayList<ArrayList<HeldExtension>>(0);
            ArrayList<ArrayList<String>> comments = new ArrayList<ArrayList<String>>(0);
            ArrayList<String> ids = new ArrayList<String>(0);
            int valueIdx = 0;
            for (IBase nextValue : values) {
                boolean primitive;
                BaseParser.ChildNameAndDef childNameAndDef;
                if ((nextValue == null || nextValue.isEmpty()) && (!(nextValue instanceof BaseContainedDt) || theContainedResource || this.getContainedResources().isEmpty()) || (childNameAndDef = super.getChildNameAndDef(nextChild, nextValue)) == null) continue;
                String childName = childNameAndDef.getChildName();
                BaseRuntimeElementDefinition<?> childDef = childNameAndDef.getChildDef();
                boolean bl = primitive = childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE;
                if ((childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCES || childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) && theContainedResource) continue;
                boolean force = false;
                if (primitive) {
                    String elementId2;
                    if (nextValue instanceof ISupportsUndeclaredExtensions) {
                        List<ExtensionDt> ext = ((ISupportsUndeclaredExtensions)nextValue).getUndeclaredExtensions();
                        force |= this.addToHeldExtensions(valueIdx, ext, extensions, false, nextChildElem);
                        ext = ((ISupportsUndeclaredExtensions)nextValue).getUndeclaredModifierExtensions();
                        force |= this.addToHeldExtensions(valueIdx, ext, modifierExtensions, true, nextChildElem);
                    } else {
                        List<? extends IBaseExtension<?, ?>> ext;
                        Object element;
                        if (nextValue instanceof IBaseHasExtensions) {
                            element = (IBaseHasExtensions)((Object)nextValue);
                            ext = element.getExtension();
                            force |= this.addToHeldExtensions(valueIdx, ext, extensions, false, nextChildElem);
                        }
                        if (nextValue instanceof IBaseHasModifierExtensions) {
                            element = (IBaseHasModifierExtensions)((Object)nextValue);
                            ext = element.getModifierExtension();
                            force |= this.addToHeldExtensions(valueIdx, ext, extensions, true, nextChildElem);
                        }
                    }
                    if (nextValue.hasFormatComment()) {
                        force |= this.addToHeldComments(valueIdx, nextValue.getFormatCommentsPre(), comments);
                        force |= this.addToHeldComments(valueIdx, nextValue.getFormatCommentsPost(), comments);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(elementId2 = this.getCompositeElementId(nextValue)))) {
                        force = true;
                        this.addToHeldIds(valueIdx, ids, elementId2);
                    }
                }
                if (currentChildName == null || !currentChildName.equals(childName)) {
                    if (inArray) {
                        theEventWriter.endArray();
                    }
                    if (nextChild.getMax() > 1 || nextChild.getMax() == -1) {
                        this.beginArray(theEventWriter, childName);
                        inArray = true;
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, null, theContainedResource, nextChildElem, force);
                    } else if (!(nextChild instanceof RuntimeChildNarrativeDefinition) || !theContainedResource) {
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, childName, theContainedResource, nextChildElem, false);
                    }
                    currentChildName = childName;
                } else {
                    this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, null, theContainedResource, nextChildElem, force);
                }
                ++valueIdx;
            }
            if (inArray) {
                theEventWriter.endArray();
            }
            if (extensions.isEmpty() && modifierExtensions.isEmpty() && comments.isEmpty()) continue;
            if (inArray) {
                this.beginArray(theEventWriter, '_' + currentChildName);
            } else {
                this.beginObject(theEventWriter, '_' + currentChildName);
            }
            for (int i = 0; i < valueIdx; ++i) {
                ArrayList nextComments;
                boolean haveContent = false;
                List heldExts = Collections.emptyList();
                List heldModExts = Collections.emptyList();
                if (extensions.size() > i && extensions.get(i) != null && !((ArrayList)extensions.get(i)).isEmpty()) {
                    haveContent = true;
                    heldExts = (List)extensions.get(i);
                }
                if (modifierExtensions.size() > i && modifierExtensions.get(i) != null && !((ArrayList)modifierExtensions.get(i)).isEmpty()) {
                    haveContent = true;
                    heldModExts = (List)modifierExtensions.get(i);
                }
                if ((nextComments = comments.size() > i ? (ArrayList)comments.get(i) : null) != null && !nextComments.isEmpty()) {
                    haveContent = true;
                }
                String elementId3 = null;
                if (ids.size() > i) {
                    elementId3 = (String)ids.get(i);
                    haveContent |= StringUtils.isNotBlank((CharSequence)elementId3);
                }
                if (!haveContent) {
                    theEventWriter.writeNull();
                    continue;
                }
                if (inArray) {
                    theEventWriter.beginObject();
                }
                if (StringUtils.isNotBlank((CharSequence)elementId3)) {
                    JsonParser.write(theEventWriter, "id", elementId3);
                }
                if (nextComments != null && !nextComments.isEmpty()) {
                    this.beginArray(theEventWriter, "fhir_comments");
                    for (String next : nextComments) {
                        theEventWriter.write(next);
                    }
                    theEventWriter.endArray();
                }
                this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, heldExts, heldModExts);
                if (!inArray) continue;
                theEventWriter.endObject();
            }
            if (inArray) {
                theEventWriter.endArray();
                continue;
            }
            theEventWriter.endObject();
        }
    }

    private void encodeCompositeElementToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, IBase theNextValue, JsonLikeWriter theEventWriter, boolean theContainedResource, BaseParser.CompositeChildElement theParent) throws IOException, DataFormatException {
        this.writeCommentsPreAndPost(theNextValue, theEventWriter);
        this.encodeCompositeElementChildrenToStreamWriter(theResDef, theResource, theNextValue, theEventWriter, theContainedResource, theParent);
    }

    @Override
    public void encodeResourceToJsonLikeWriter(IBaseResource theResource, JsonLikeWriter theJsonLikeWriter) throws IOException, DataFormatException {
        Validate.notNull((Object)theResource, (String)"theResource can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theJsonLikeWriter, (String)"theJsonLikeWriter can not be null", (Object[])new Object[0]);
        if (theResource.getStructureFhirVersionEnum() != this.myContext.getVersion().getVersion()) {
            throw new IllegalArgumentException("This parser is for FHIR version " + (Object)((Object)this.myContext.getVersion().getVersion()) + " - Can not encode a structure for version " + (Object)((Object)theResource.getStructureFhirVersionEnum()));
        }
        this.doEncodeResourceToJsonLikeWriter(theResource, theJsonLikeWriter);
    }

    private void encodeResourceToJsonStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, String theObjectNameOrNull, boolean theContainedResource, boolean theSubResource) throws IOException {
        IIdType resourceId = null;
        if (StringUtils.isNotBlank((CharSequence)theResource.getIdElement().getIdPart())) {
            resourceId = theResource.getIdElement();
            if (theResource.getIdElement().getValue().startsWith("urn:")) {
                resourceId = null;
            }
            if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU1)) {
                resourceId = null;
            }
        }
        if (!theContainedResource) {
            if (!super.shouldEncodeResourceId(theResource)) {
                resourceId = null;
            } else if (!theSubResource && this.getEncodeForceResourceId() != null) {
                resourceId = this.getEncodeForceResourceId();
            }
        }
        this.encodeResourceToJsonStreamWriter(theResDef, theResource, theEventWriter, theObjectNameOrNull, theContainedResource, resourceId);
    }

    private void encodeResourceToJsonStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, String theObjectNameOrNull, boolean theContainedResource, IIdType theResourceId) throws IOException {
        if (!theContainedResource) {
            super.containResourcesForEncoding(theResource);
        }
        RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
        if (theObjectNameOrNull == null) {
            theEventWriter.beginObject();
        } else {
            this.beginObject(theEventWriter, theObjectNameOrNull);
        }
        JsonParser.write(theEventWriter, "resourceType", resDef.getName());
        if (theResourceId != null && theResourceId.hasIdPart()) {
            JsonParser.write(theEventWriter, "id", theResourceId.getIdPart());
            if (theResourceId.hasFormatComment()) {
                this.beginObject(theEventWriter, "_id");
                this.writeCommentsPreAndPost(theResourceId, theEventWriter);
                theEventWriter.endObject();
            }
        }
        if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1) && theResource instanceof IResource) {
            IResource resource = (IResource)theResource;
            List<BaseCodingDt> securityLabels = JsonParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.SECURITY_LABELS);
            List<IIdType> profiles = JsonParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.PROFILES);
            profiles = super.getProfileTagsForEncoding(resource, profiles);
            TagList tags = this.getMetaTagsForEncoding(resource);
            InstantDt updated = (InstantDt)resource.getResourceMetadata().get(ResourceMetadataKeyEnum.UPDATED);
            IdDt resourceId = resource.getId();
            String versionIdPart = resourceId.getVersionIdPart();
            if (StringUtils.isBlank((CharSequence)versionIdPart)) {
                versionIdPart = ResourceMetadataKeyEnum.VERSION.get(resource);
            }
            if (super.shouldEncodeResourceMeta(resource) && !ElementUtil.isEmpty(versionIdPart, updated, securityLabels, tags, profiles)) {
                this.beginObject(theEventWriter, "meta");
                this.writeOptionalTagWithTextNode(theEventWriter, "versionId", versionIdPart);
                this.writeOptionalTagWithTextNode(theEventWriter, "lastUpdated", updated);
                if (profiles != null && !profiles.isEmpty()) {
                    this.beginArray(theEventWriter, "profile");
                    for (IIdType profile : profiles) {
                        if (profile == null || !StringUtils.isNotBlank((CharSequence)profile.getValue())) continue;
                        theEventWriter.write(profile.getValue());
                    }
                    theEventWriter.endArray();
                }
                if (!securityLabels.isEmpty()) {
                    this.beginArray(theEventWriter, "security");
                    for (BaseCodingDt securityLabel : securityLabels) {
                        theEventWriter.beginObject();
                        this.encodeCompositeElementChildrenToStreamWriter(resDef, resource, securityLabel, theEventWriter, theContainedResource, null);
                        theEventWriter.endObject();
                    }
                    theEventWriter.endArray();
                }
                if (tags != null && !tags.isEmpty()) {
                    this.beginArray(theEventWriter, "tag");
                    for (Tag tag : tags) {
                        if (tag.isEmpty()) continue;
                        theEventWriter.beginObject();
                        this.writeOptionalTagWithTextNode(theEventWriter, "system", tag.getScheme());
                        this.writeOptionalTagWithTextNode(theEventWriter, "code", tag.getTerm());
                        this.writeOptionalTagWithTextNode(theEventWriter, "display", tag.getLabel());
                        theEventWriter.endObject();
                    }
                    theEventWriter.endArray();
                }
                theEventWriter.endObject();
            }
        }
        if (theResource instanceof IBaseBinary) {
            String contentAsBase64;
            IBaseBinary bin = (IBaseBinary)theResource;
            String contentType = bin.getContentType();
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                JsonParser.write(theEventWriter, "contentType", contentType);
            }
            if (StringUtils.isNotBlank((CharSequence)(contentAsBase64 = bin.getContentAsBase64()))) {
                JsonParser.write(theEventWriter, "content", contentAsBase64);
            }
        } else {
            this.encodeCompositeElementToStreamWriter(theResDef, theResource, theResource, theEventWriter, theContainedResource, new BaseParser.CompositeChildElement(this, resDef));
        }
        theEventWriter.endObject();
    }

    @Override
    public void encodeTagListToWriter(TagList theTagList, Writer theWriter) throws IOException {
        JsonLikeWriter theEventWriter = this.createJsonWriter(theWriter);
        this.encodeTagListToJsonLikeWriter(theTagList, theEventWriter);
    }

    @Override
    public void encodeTagListToJsonLikeWriter(TagList theTagList, JsonLikeWriter theEventWriter) throws IOException {
        if (this.myPrettyPrint) {
            theEventWriter.setPrettyPrint(this.myPrettyPrint);
        }
        theEventWriter.init();
        theEventWriter.beginObject();
        JsonParser.write(theEventWriter, "resourceType", "TagList");
        this.beginArray(theEventWriter, "category");
        for (Tag next : theTagList) {
            theEventWriter.beginObject();
            if (StringUtils.isNotBlank((CharSequence)next.getTerm())) {
                JsonParser.write(theEventWriter, "term", next.getTerm());
            }
            if (StringUtils.isNotBlank((CharSequence)next.getLabel())) {
                JsonParser.write(theEventWriter, "label", next.getLabel());
            }
            if (StringUtils.isNotBlank((CharSequence)next.getScheme())) {
                JsonParser.write(theEventWriter, "scheme", next.getScheme());
            }
            theEventWriter.endObject();
        }
        theEventWriter.endArray();
        theEventWriter.endObject();
        theEventWriter.flush();
    }

    private void extractAndWriteExtensionsAsDirectChild(IBase theElement, JsonLikeWriter theEventWriter, BaseRuntimeElementDefinition<?> theElementDef, RuntimeResourceDefinition theResDef, IBaseResource theResource, BaseParser.CompositeChildElement theChildElem) throws IOException {
        ArrayList<HeldExtension> extensions = new ArrayList<HeldExtension>(0);
        ArrayList<HeldExtension> modifierExtensions = new ArrayList<HeldExtension>(0);
        this.extractUndeclaredExtensions(theElement, extensions, modifierExtensions, theChildElem);
        if (theElementDef != null) {
            this.extractDeclaredExtensions(theElement, theElementDef, extensions, modifierExtensions, theChildElem);
        }
        this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, extensions, modifierExtensions);
    }

    private void extractDeclaredExtensions(IBase theResource, BaseRuntimeElementDefinition<?> resDef, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions, BaseParser.CompositeChildElement theChildElem) {
        for (RuntimeChildDeclaredExtensionDefinition nextDef : resDef.getExtensionsNonModifier()) {
            for (IBase nextValue : nextDef.getAccessor().getValues(theResource)) {
                if (nextValue == null || nextValue == null || nextValue.isEmpty()) continue;
                extensions.add(new HeldExtension(nextDef, nextValue, theChildElem));
            }
        }
        for (RuntimeChildDeclaredExtensionDefinition nextDef : resDef.getExtensionsModifier()) {
            for (IBase nextValue : nextDef.getAccessor().getValues(theResource)) {
                if (nextValue == null || nextValue == null || nextValue.isEmpty()) continue;
                modifierExtensions.add(new HeldExtension(nextDef, nextValue, theChildElem));
            }
        }
    }

    private void extractUndeclaredExtensions(IBase theElement, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions, BaseParser.CompositeChildElement theChildElem) {
        block6: {
            List<IBaseExtension<?, ?>> ext;
            Object element;
            block5: {
                if (!(theElement instanceof ISupportsUndeclaredExtensions)) break block5;
                ISupportsUndeclaredExtensions element2 = (ISupportsUndeclaredExtensions)theElement;
                List<ExtensionDt> ext2 = element2.getUndeclaredExtensions();
                for (ExtensionDt next : ext2) {
                    if (next == null || next.isEmpty()) continue;
                    extensions.add(new HeldExtension(next, false, theChildElem));
                }
                ext2 = element2.getUndeclaredModifierExtensions();
                for (ExtensionDt next : ext2) {
                    if (next == null || next.isEmpty()) continue;
                    modifierExtensions.add(new HeldExtension(next, true, theChildElem));
                }
                break block6;
            }
            if (theElement instanceof IBaseHasExtensions) {
                element = (IBaseHasExtensions)((Object)theElement);
                ext = element.getExtension();
                for (IBaseExtension<?, ?> next : ext) {
                    if (next == null || ElementUtil.isEmpty(next.getValue()) && next.getExtension().isEmpty()) continue;
                    extensions.add(new HeldExtension(next, false, theChildElem));
                }
            }
            if (!(theElement instanceof IBaseHasModifierExtensions)) break block6;
            element = (IBaseHasModifierExtensions)((Object)theElement);
            ext = element.getModifierExtension();
            for (IBaseExtension<?, ?> next : ext) {
                if (next == null || next.isEmpty()) continue;
                modifierExtensions.add(new HeldExtension(next, true, theChildElem));
            }
        }
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.JSON;
    }

    private JsonLikeArray grabJsonArray(JsonLikeObject theObject, String nextName, String thePosition) {
        JsonLikeValue object = theObject.get(nextName);
        if (object == null || object.isNull()) {
            return null;
        }
        if (!object.isArray()) {
            throw new DataFormatException("Syntax error parsing JSON FHIR structure: Expected ARRAY at element '" + thePosition + "', found '" + (Object)((Object)object.getJsonType()) + "'");
        }
        return object.getAsArray();
    }

    private void parseAlternates(JsonLikeValue theAlternateVal, ParserState<?> theState, String theElementName) {
        if (theAlternateVal == null || theAlternateVal.isNull()) {
            return;
        }
        if (theAlternateVal.isArray()) {
            JsonLikeArray array = theAlternateVal.getAsArray();
            if (array.size() > 1) {
                throw new DataFormatException("Unexpected array of length " + array.size() + " (expected 0 or 1) for element: " + theElementName);
            }
            if (array.size() == 0) {
                return;
            }
            this.parseAlternates(array.get(0), theState, theElementName);
            return;
        }
        JsonLikeObject alternate = theAlternateVal.getAsObject();
        for (String nextKey : alternate.keySet()) {
            JsonLikeArray array;
            boolean isModifier;
            JsonLikeValue nextVal = alternate.get(nextKey);
            if ("extension".equals(nextKey)) {
                isModifier = false;
                array = nextVal.getAsArray();
                this.parseExtension(theState, array, isModifier);
                continue;
            }
            if ("modifierExtension".equals(nextKey)) {
                isModifier = true;
                array = nextVal.getAsArray();
                this.parseExtension(theState, array, isModifier);
                continue;
            }
            if ("id".equals(nextKey)) {
                if (!nextVal.isString() && !nextVal.isNumber()) continue;
                theState.attributeValue("id", nextVal.getAsString());
                continue;
            }
            if (!"fhir_comments".equals(nextKey)) continue;
            this.parseFhirComments(nextVal, theState);
        }
    }

    @Override
    public <T extends IBaseResource> Bundle parseBundle(Class<T> theResourceType, Reader theReader) {
        GsonStructure jsonStructure = new GsonStructure();
        jsonStructure.load(theReader);
        Bundle retVal = this.parseBundle(theResourceType, jsonStructure);
        return retVal;
    }

    @Override
    public Bundle parseBundle(JsonLikeStructure theJsonLikeStructure) throws DataFormatException {
        return this.parseBundle(null, theJsonLikeStructure);
    }

    @Override
    public <T extends IBaseResource> Bundle parseBundle(Class<T> theResourceType, JsonLikeStructure theJsonStructure) {
        JsonLikeObject object = theJsonStructure.getRootObject();
        JsonLikeValue resourceTypeObj = object.get("resourceType");
        if (resourceTypeObj == null || !resourceTypeObj.isString()) {
            throw new DataFormatException("Invalid JSON content detected, missing required element: 'resourceType'");
        }
        String resourceType = resourceTypeObj.getAsString();
        if (!"Bundle".equals(resourceType)) {
            throw new DataFormatException("Trying to parse bundle but found resourceType other than 'Bundle'. Found: '" + resourceType + "'");
        }
        ParserState<Bundle> state = ParserState.getPreAtomInstance(this, this.myContext, theResourceType, true, this.getErrorHandler());
        if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            state.enteringNewElement(null, "Bundle");
        } else {
            state.enteringNewElement(null, "feed");
        }
        this.parseBundleChildren(object, state);
        state.endingElement();
        state.endingElement();
        Bundle retVal = state.getObject();
        return retVal;
    }

    private void parseBundleChildren(JsonLikeObject theObject, ParserState<?> theState) {
        for (String nextName : theObject.keySet()) {
            String href;
            String rel;
            JsonLikeObject linkObj;
            JsonLikeValue jsonValue;
            int i;
            JsonLikeArray entries;
            if ("resourceType".equals(nextName)) continue;
            if ("entry".equals(nextName)) {
                entries = this.grabJsonArray(theObject, nextName, "entry");
                for (i = 0; i < entries.size(); ++i) {
                    jsonValue = entries.get(i);
                    theState.enteringNewElement(null, "entry");
                    this.parseBundleChildren(jsonValue.getAsObject(), theState);
                    theState.endingElement();
                }
                continue;
            }
            if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
                if ("link".equals(nextName)) {
                    entries = this.grabJsonArray(theObject, nextName, "link");
                    for (i = 0; i < entries.size(); ++i) {
                        jsonValue = entries.get(i);
                        theState.enteringNewElement(null, "link");
                        linkObj = jsonValue.getAsObject();
                        rel = linkObj.getString("rel", null);
                        href = linkObj.getString("href", null);
                        theState.attributeValue("rel", rel);
                        theState.attributeValue("href", href);
                        theState.endingElement();
                    }
                    continue;
                }
                if (BUNDLE_TEXTNODE_CHILDREN_DSTU1.contains(nextName)) {
                    theState.enteringNewElement(null, nextName);
                    JsonLikeValue jsonElement = theObject.get(nextName);
                    if (jsonElement.isScalar()) {
                        theState.string(jsonElement.getAsString());
                    }
                    theState.endingElement();
                    continue;
                }
            } else {
                if ("link".equals(nextName)) {
                    entries = this.grabJsonArray(theObject, nextName, "link");
                    for (i = 0; i < entries.size(); ++i) {
                        jsonValue = entries.get(i);
                        theState.enteringNewElement(null, "link");
                        linkObj = jsonValue.getAsObject();
                        rel = linkObj.getString("relation", null);
                        href = linkObj.getString("url", null);
                        theState.enteringNewElement(null, "relation");
                        theState.attributeValue("value", rel);
                        theState.endingElement();
                        theState.enteringNewElement(null, "url");
                        theState.attributeValue("value", href);
                        theState.endingElement();
                        theState.endingElement();
                    }
                    continue;
                }
                if (BUNDLE_TEXTNODE_CHILDREN_DSTU2.contains(nextName)) {
                    theState.enteringNewElement(null, nextName);
                    JsonLikeValue obj = theObject.get(nextName);
                    if (obj == null || obj.isNull()) {
                        theState.attributeValue("value", null);
                    } else if (obj.isScalar()) {
                        theState.attributeValue("value", obj.getAsString());
                    } else {
                        throw new DataFormatException("Unexpected JSON object for entry '" + nextName + "'");
                    }
                    theState.endingElement();
                    continue;
                }
            }
            JsonLikeValue nextVal = theObject.get(nextName);
            this.parseChildren(theState, nextName, nextVal, null, null);
        }
    }

    private void parseChildren(JsonLikeObject theObject, ParserState<?> theState) {
        Set<String> keySet = theObject.keySet();
        int allUnderscoreNames = 0;
        int handledUnderscoreNames = 0;
        for (String nextName : keySet) {
            JsonLikeArray array;
            if ("resourceType".equals(nextName)) continue;
            if ("extension".equals(nextName)) {
                array = this.grabJsonArray(theObject, nextName, "extension");
                this.parseExtension(theState, array, false);
                continue;
            }
            if ("modifierExtension".equals(nextName)) {
                array = this.grabJsonArray(theObject, nextName, "modifierExtension");
                this.parseExtension(theState, array, true);
                continue;
            }
            if (nextName.equals("fhir_comments")) {
                this.parseFhirComments(theObject.get(nextName), theState);
                continue;
            }
            if (nextName.charAt(0) == '_') {
                ++allUnderscoreNames;
                continue;
            }
            JsonLikeValue nextVal = theObject.get(nextName);
            String alternateName = '_' + nextName;
            JsonLikeValue alternateVal = theObject.get(alternateName);
            if (alternateVal != null) {
                ++handledUnderscoreNames;
            }
            this.parseChildren(theState, nextName, nextVal, alternateVal, alternateName);
        }
        if (allUnderscoreNames > handledUnderscoreNames) {
            for (String alternateName : keySet) {
                String nextName;
                JsonLikeValue nextValue;
                if (!alternateName.startsWith("_") || alternateName.length() <= 1 || (nextValue = theObject.get(alternateName)) == null || !nextValue.isObject() || theObject.get(nextName = alternateName.substring(1)) != null) continue;
                theState.enteringNewElement(null, nextName);
                this.parseAlternates(nextValue, theState, alternateName);
                theState.endingElement();
            }
        }
    }

    private void parseChildren(ParserState<?> theState, String theName, JsonLikeValue theJsonVal, JsonLikeValue theAlternateVal, String theAlternateName) {
        if (theJsonVal.isArray()) {
            JsonLikeArray nextArray = theJsonVal.getAsArray();
            JsonLikeArray nextAlternateArray = JsonLikeValue.asArray(theAlternateVal);
            for (int i = 0; i < nextArray.size(); ++i) {
                JsonLikeValue nextObject = nextArray.get(i);
                JsonLikeValue nextAlternate = null;
                if (nextAlternateArray != null) {
                    nextAlternate = nextAlternateArray.get(i);
                }
                this.parseChildren(theState, theName, nextObject, nextAlternate, theAlternateName);
            }
        } else if (theJsonVal.isObject()) {
            theState.enteringNewElement(null, theName);
            this.parseAlternates(theAlternateVal, theState, theAlternateName);
            JsonLikeObject nextObject = theJsonVal.getAsObject();
            boolean preResource = false;
            if (theState.isPreResource()) {
                JsonLikeValue resType = nextObject.get("resourceType");
                if (resType == null || !resType.isString()) {
                    throw new DataFormatException("Missing required element 'resourceType' from JSON resource object, unable to parse");
                }
                theState.enteringNewElement(null, resType.getAsString());
                preResource = true;
            }
            this.parseChildren(nextObject, theState);
            if (preResource) {
                theState.endingElement();
            }
            theState.endingElement();
        } else if (theJsonVal.isNull()) {
            theState.enteringNewElement(null, theName);
            this.parseAlternates(theAlternateVal, theState, theAlternateName);
            theState.endingElement();
        } else {
            theState.enteringNewElement(null, theName);
            theState.attributeValue("value", theJsonVal.getAsString());
            this.parseAlternates(theAlternateVal, theState, theAlternateName);
            theState.endingElement();
        }
    }

    private void parseExtension(ParserState<?> theState, JsonLikeArray theValues, boolean theIsModifier) {
        for (int i = 0; i < theValues.size(); ++i) {
            String url;
            JsonLikeObject nextExtObj = JsonLikeValue.asObject(theValues.get(i));
            JsonLikeValue jsonElement = nextExtObj.get("url");
            if (null == jsonElement || !jsonElement.isScalar()) {
                String parentElementName = theIsModifier ? "modifierExtension" : "extension";
                this.getErrorHandler().missingRequiredElement(new ParseLocation(parentElementName), "url");
                url = null;
            } else {
                url = jsonElement.getAsString();
            }
            theState.enteringNewElementExtension(null, url, theIsModifier);
            for (String next : nextExtObj.keySet()) {
                JsonLikeValue jsonVal;
                if ("url".equals(next)) continue;
                if ("extension".equals(next)) {
                    jsonVal = JsonLikeValue.asArray(nextExtObj.get(next));
                    this.parseExtension(theState, (JsonLikeArray)jsonVal, false);
                    continue;
                }
                if ("modifierExtension".equals(next)) {
                    jsonVal = JsonLikeValue.asArray(nextExtObj.get(next));
                    this.parseExtension(theState, (JsonLikeArray)jsonVal, true);
                    continue;
                }
                jsonVal = nextExtObj.get(next);
                this.parseChildren(theState, next, jsonVal, null, null);
            }
            theState.endingElement();
        }
    }

    private void parseFhirComments(JsonLikeValue theObject, ParserState<?> theState) {
        if (theObject.isArray()) {
            JsonLikeArray comments = theObject.getAsArray();
            for (int i = 0; i < comments.size(); ++i) {
                String commentText;
                JsonLikeValue nextComment = comments.get(i);
                if (!nextComment.isString() || (commentText = nextComment.getAsString()) == null) continue;
                theState.commentPre(commentText);
            }
        }
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, JsonLikeStructure theJsonLikeStructure) throws DataFormatException {
        T retVal;
        RuntimeResourceDefinition def;
        if (theResourceType != null) {
            this.myContext.getResourceDefinition(theResourceType);
        }
        if ("Bundle".equals((def = this.myContext.getResourceDefinition((IBaseResource)(retVal = this.doParseResource(theResourceType, theJsonLikeStructure)))).getName())) {
            BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
            BaseRuntimeElementCompositeDefinition entryDef = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
            List<IBase> entries = entryChild.getAccessor().getValues(retVal);
            if (entries != null) {
                for (IBase nextEntry : entries) {
                    List<IBase> entryResources;
                    IPrimitiveType value;
                    List<IBase> fullUrl;
                    BaseRuntimeChildDefinition fullUrlChild = entryDef.getChildByName("fullUrl");
                    if (fullUrlChild == null || (fullUrl = fullUrlChild.getAccessor().getValues(nextEntry)) == null || fullUrl.isEmpty() || (value = (IPrimitiveType)fullUrl.get(0)).isEmpty() || (entryResources = entryDef.getChildByName("resource").getAccessor().getValues(nextEntry)) == null || entryResources.size() <= 0) continue;
                    IBaseResource res = (IBaseResource)entryResources.get(0);
                    String versionId = res.getIdElement().getVersionIdPart();
                    res.setId(value.getValueAsString());
                    if (!StringUtils.isNotBlank((CharSequence)versionId) || res.getIdElement().hasVersionIdPart()) continue;
                    res.setId(res.getIdElement().withVersion(versionId));
                }
            }
        }
        return retVal;
    }

    @Override
    public IBaseResource parseResource(JsonLikeStructure theJsonLikeStructure) throws DataFormatException {
        return this.parseResource(null, theJsonLikeStructure);
    }

    @Override
    public TagList parseTagList(Reader theReader) {
        GsonStructure jsonStructure = new GsonStructure();
        jsonStructure.load(theReader);
        TagList retVal = this.parseTagList(jsonStructure);
        return retVal;
    }

    @Override
    public TagList parseTagList(JsonLikeStructure theJsonStructure) {
        JsonLikeObject object = theJsonStructure.getRootObject();
        JsonLikeValue resourceTypeObj = object.get("resourceType");
        String resourceType = resourceTypeObj.getAsString();
        ParserState<TagList> state = ParserState.getPreTagListInstance(this, this.myContext, true, this.getErrorHandler());
        state.enteringNewElement(null, resourceType);
        this.parseChildren(object, state);
        state.endingElement();
        state.endingElement();
        return state.getObject();
    }

    @Override
    public IParser setPrettyPrint(boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
        return this;
    }

    private void write(JsonLikeWriter theEventWriter, String theChildName, Boolean theValue) throws IOException {
        if (theValue != null) {
            theEventWriter.write(theChildName, (boolean)theValue);
        }
    }

    private void write(JsonLikeWriter theEventWriter, String theChildName, BigDecimal theDecimalValue) throws IOException {
        theEventWriter.write(theChildName, theDecimalValue);
    }

    private void write(JsonLikeWriter theEventWriter, String theChildName, Integer theValue) throws IOException {
        theEventWriter.write(theChildName, theValue.intValue());
    }

    private boolean writeAtomLinkInDstu1Format(JsonLikeWriter theEventWriter, String theRel, StringDt theLink, boolean theStarted) throws IOException {
        boolean retVal = theStarted;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theLink.getValue()))) {
            if (!theStarted) {
                theEventWriter.beginArray("link");
                retVal = true;
            }
            theEventWriter.beginObject();
            JsonParser.write(theEventWriter, "rel", theRel);
            JsonParser.write(theEventWriter, "href", (String)theLink.getValue());
            theEventWriter.endObject();
        }
        return retVal;
    }

    private boolean writeAtomLinkInDstu2Format(JsonLikeWriter theEventWriter, String theRel, StringDt theLink, boolean theStarted) throws IOException {
        boolean retVal = theStarted;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theLink.getValue()))) {
            if (!theStarted) {
                theEventWriter.beginArray("link");
                retVal = true;
            }
            theEventWriter.beginObject();
            JsonParser.write(theEventWriter, "relation", theRel);
            JsonParser.write(theEventWriter, "url", (String)theLink.getValue());
            theEventWriter.endObject();
        }
        return retVal;
    }

    private void writeAuthor(BaseBundle theBundle, JsonLikeWriter theEventWriter) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theBundle.getAuthorName().getValue()))) {
            this.beginArray(theEventWriter, "author");
            theEventWriter.beginObject();
            this.writeTagWithTextNode(theEventWriter, "name", theBundle.getAuthorName());
            this.writeOptionalTagWithTextNode(theEventWriter, "uri", theBundle.getAuthorUri());
            theEventWriter.endObject();
            theEventWriter.endArray();
        }
    }

    private void writeCategories(JsonLikeWriter theEventWriter, TagList categories) throws IOException {
        if (categories != null && categories.size() > 0) {
            theEventWriter.beginArray("category");
            for (Tag next : categories) {
                theEventWriter.beginObject();
                JsonParser.write(theEventWriter, "term", StringUtils.defaultString((String)next.getTerm()));
                JsonParser.write(theEventWriter, "label", StringUtils.defaultString((String)next.getLabel()));
                JsonParser.write(theEventWriter, "scheme", StringUtils.defaultString((String)next.getScheme()));
                theEventWriter.endObject();
            }
            theEventWriter.endArray();
        }
    }

    private void writeCommentsPreAndPost(IBase theNextValue, JsonLikeWriter theEventWriter) throws IOException {
        if (theNextValue.hasFormatComment()) {
            List<String> post;
            this.beginArray(theEventWriter, "fhir_comments");
            List<String> pre = theNextValue.getFormatCommentsPre();
            if (!pre.isEmpty()) {
                for (String next : pre) {
                    theEventWriter.write(next);
                }
            }
            if (!(post = theNextValue.getFormatCommentsPost()).isEmpty()) {
                for (String next : post) {
                    theEventWriter.write(next);
                }
            }
            theEventWriter.endArray();
        }
    }

    private void writeExtensionsAsDirectChild(IBaseResource theResource, JsonLikeWriter theEventWriter, RuntimeResourceDefinition resDef, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions) throws IOException {
        if (!extensions.isEmpty()) {
            this.beginArray(theEventWriter, "extension");
            for (HeldExtension next : extensions) {
                next.write(resDef, theResource, theEventWriter);
            }
            theEventWriter.endArray();
        }
        if (!modifierExtensions.isEmpty()) {
            this.beginArray(theEventWriter, "modifierExtension");
            for (HeldExtension next : modifierExtensions) {
                next.write(resDef, theResource, theEventWriter);
            }
            theEventWriter.endArray();
        }
    }

    private void writeOptionalTagWithDecimalNode(JsonLikeWriter theEventWriter, String theElementName, DecimalDt theValue) throws IOException {
        if (theValue != null && !theValue.isEmpty()) {
            this.write(theEventWriter, theElementName, (BigDecimal)theValue.getValue());
        }
    }

    private void writeOptionalTagWithNumberNode(JsonLikeWriter theEventWriter, String theElementName, IntegerDt theValue) throws IOException {
        if (theValue != null && !theValue.isEmpty()) {
            this.write(theEventWriter, theElementName, (int)((Integer)theValue.getValue()));
        }
    }

    private void writeOptionalTagWithTextNode(JsonLikeWriter theEventWriter, String theElementName, IPrimitiveDatatype<?> thePrimitive) throws IOException {
        if (thePrimitive == null) {
            return;
        }
        String str = thePrimitive.getValueAsString();
        this.writeOptionalTagWithTextNode(theEventWriter, theElementName, str);
    }

    private void writeOptionalTagWithTextNode(JsonLikeWriter theEventWriter, String theElementName, String theValue) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)theValue)) {
            JsonParser.write(theEventWriter, theElementName, theValue);
        }
    }

    private void writeTagWithTextNode(JsonLikeWriter theEventWriter, String theElementName, IPrimitiveDatatype<?> theIdDt) throws IOException {
        if (theIdDt != null && !theIdDt.isEmpty()) {
            JsonParser.write(theEventWriter, theElementName, theIdDt.getValueAsString());
        } else {
            theEventWriter.writeNull(theElementName);
        }
    }

    private void writeTagWithTextNode(JsonLikeWriter theEventWriter, String theElementName, StringDt theStringDt) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theStringDt.getValue()))) {
            JsonParser.write(theEventWriter, theElementName, (String)theStringDt.getValue());
        }
    }

    public static Gson newGson() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson;
    }

    private static void write(JsonLikeWriter theWriter, String theName, String theValue) throws IOException {
        theWriter.write(theName, theValue);
    }

    static {
        ourLog = LoggerFactory.getLogger(HeldExtension.class);
        HashSet<String> hashSetDstu1 = new HashSet<String>();
        hashSetDstu1.add("title");
        hashSetDstu1.add("id");
        hashSetDstu1.add("updated");
        hashSetDstu1.add("published");
        hashSetDstu1.add("totalResults");
        BUNDLE_TEXTNODE_CHILDREN_DSTU1 = Collections.unmodifiableSet(hashSetDstu1);
        HashSet<String> hashSetDstu2 = new HashSet<String>();
        hashSetDstu2.add("type");
        hashSetDstu2.add("base");
        hashSetDstu2.add("total");
        BUNDLE_TEXTNODE_CHILDREN_DSTU2 = Collections.unmodifiableSet(hashSetDstu2);
    }

    private class HeldExtension
    implements Comparable<HeldExtension> {
        private BaseParser.CompositeChildElement myChildElem;
        private RuntimeChildDeclaredExtensionDefinition myDef;
        private boolean myModifier;
        private IBaseExtension<?, ?> myUndeclaredExtension;
        private IBase myValue;

        public HeldExtension(IBaseExtension<?, ?> theUndeclaredExtension, boolean theModifier, BaseParser.CompositeChildElement theChildElem) {
            assert (theUndeclaredExtension != null);
            this.myUndeclaredExtension = theUndeclaredExtension;
            this.myModifier = theModifier;
            this.myChildElem = theChildElem;
        }

        public HeldExtension(RuntimeChildDeclaredExtensionDefinition theDef, IBase theValue, BaseParser.CompositeChildElement theChildElem) {
            assert (theDef != null);
            assert (theValue != null);
            this.myDef = theDef;
            this.myValue = theValue;
            this.myChildElem = theChildElem;
        }

        @Override
        public int compareTo(HeldExtension theArg0) {
            String url1 = this.myDef != null ? this.myDef.getExtensionUrl() : this.myUndeclaredExtension.getUrl();
            String url2 = theArg0.myDef != null ? theArg0.myDef.getExtensionUrl() : theArg0.myUndeclaredExtension.getUrl();
            url1 = StringUtils.defaultString((String)url1);
            url2 = StringUtils.defaultString((String)url2);
            return url1.compareTo(url2);
        }

        public void write(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter) throws IOException {
            if (this.myUndeclaredExtension != null) {
                this.writeUndeclaredExtension(theResDef, theResource, theEventWriter, this.myUndeclaredExtension);
            } else {
                theEventWriter.beginObject();
                JsonParser.this.writeCommentsPreAndPost(this.myValue, theEventWriter);
                JsonParser.write(theEventWriter, "url", this.myDef.getExtensionUrl());
                List<? extends IBase> preProcessedValue = JsonParser.this.preProcessValues(this.myDef, theResource, Collections.singletonList(this.myValue), this.myChildElem);
                this.myValue = preProcessedValue.get(0);
                BaseRuntimeElementDefinition<?> def = this.myDef.getChildElementDefinitionByDatatype(this.myValue.getClass());
                if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.RESOURCE_BLOCK) {
                    JsonParser.this.extractAndWriteExtensionsAsDirectChild(this.myValue, theEventWriter, def, theResDef, theResource, this.myChildElem);
                } else {
                    String childName = this.myDef.getChildNameByDatatype(this.myValue.getClass());
                    JsonParser.this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, this.myValue, def, childName, false, null, false);
                }
                theEventWriter.endObject();
            }
        }

        private void writeUndeclaredExtension(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonLikeWriter theEventWriter, IBaseExtension<?, ?> ext) throws IOException {
            boolean noValue;
            IBase value = ext.getValue();
            String extensionUrl = ext.getUrl();
            theEventWriter.beginObject();
            JsonParser.this.writeCommentsPreAndPost(this.myUndeclaredExtension, theEventWriter);
            String elementId = JsonParser.this.getCompositeElementId(ext);
            if (StringUtils.isNotBlank((CharSequence)elementId)) {
                JsonParser.write(theEventWriter, "id", JsonParser.this.getCompositeElementId(ext));
            }
            JsonParser.write(theEventWriter, "url", extensionUrl);
            boolean bl = noValue = value == null || value.isEmpty();
            if (noValue && ext.getExtension().isEmpty()) {
                ourLog.debug("Extension with URL[{}] has no value", (Object)extensionUrl);
            } else if (noValue) {
                if (this.myModifier) {
                    JsonParser.this.beginArray(theEventWriter, "modifierExtension");
                } else {
                    JsonParser.this.beginArray(theEventWriter, "extension");
                }
                for (Object next : ext.getExtension()) {
                    this.writeUndeclaredExtension(theResDef, theResource, theEventWriter, (IBaseExtension)next);
                }
                theEventWriter.endArray();
            } else {
                BaseRuntimeElementDefinition<?> childDef;
                value = (IBase)JsonParser.super.preProcessValues(this.myDef, theResource, Collections.singletonList(value), this.myChildElem).get(0);
                RuntimeChildUndeclaredExtensionDefinition extDef = JsonParser.this.myContext.getRuntimeChildUndeclaredExtensionDefinition();
                String childName = extDef.getChildNameByDatatype(value.getClass());
                if (childName == null) {
                    childName = "value" + WordUtils.capitalize((String)JsonParser.this.myContext.getElementDefinition(value.getClass()).getName());
                }
                if ((childDef = extDef.getChildElementDefinitionByDatatype(value.getClass())) == null) {
                    throw new ConfigurationException("Unable to encode extension, unregognized child element type: " + value.getClass().getCanonicalName());
                }
                JsonParser.this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, value, childDef, childName, true, null, false);
            }
            theEventWriter.endObject();
        }
    }
}

