/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.primitive.BaseDateTimeDt;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

@DatatypeDef(name="date")
public class DateDt
extends BaseDateTimeDt {
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.DAY;

    public DateDt() {
    }

    public DateDt(Calendar theCalendar) {
        super(theCalendar.getTime(), DEFAULT_PRECISION);
        this.setTimeZone(theCalendar.getTimeZone());
    }

    @SimpleSetter(suffix="WithDayPrecision")
    public DateDt(@SimpleSetter.Parameter(name="theDate") Date theDate) {
        super(theDate, DEFAULT_PRECISION);
    }

    @SimpleSetter
    public DateDt(@SimpleSetter.Parameter(name="theDate") Date theDate, @SimpleSetter.Parameter(name="thePrecision") TemporalPrecisionEnum thePrecision) {
        super(theDate, thePrecision);
    }

    public DateDt(int theYear, int theMonth, int theDay) {
        this(DateDt.toCalendarZulu(theYear, theMonth, theDay));
    }

    public DateDt(String theDate) {
        super(theDate);
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }

    @Override
    boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return true;
            }
        }
        return false;
    }

    private static GregorianCalendar toCalendarZulu(int theYear, int theMonth, int theDay) {
        GregorianCalendar retVal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        retVal.set(1, theYear);
        retVal.set(2, theMonth);
        retVal.set(5, theDay);
        return retVal;
    }
}

