/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.rest.server.Constants;
import org.apache.commons.codec.binary.Base64;

@DatatypeDef(name="base64Binary")
public class Base64BinaryDt
extends BasePrimitive<byte[]> {
    public Base64BinaryDt() {
    }

    @SimpleSetter
    public Base64BinaryDt(@SimpleSetter.Parameter(name="theBytes") byte[] theBytes) {
        this.setValue(theBytes);
    }

    @Override
    protected byte[] parse(String theValue) {
        return Base64.decodeBase64((byte[])theValue.getBytes(Constants.CHARSET_UTF8));
    }

    @Override
    protected String encode(byte[] theValue) {
        return new String(Base64.encodeBase64((byte[])theValue), Constants.CHARSET_UTF8);
    }
}

