/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mondrian.olap.Annotation;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jHierarchy;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import mondrian.olap4j.MondrianOlap4jProperty;
import mondrian.olap4j.MondrianOlap4jSchema;
import mondrian.rolap.RolapConnection;
import mondrian.server.Locus;
import org.olap4j.OlapException;
import org.olap4j.impl.ArrayNamedListImpl;
import org.olap4j.impl.Named;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;

public class MondrianOlap4jLevel
extends MondrianOlap4jMetadataElement
implements org.olap4j.metadata.Level,
Named {
    final MondrianOlap4jSchema olap4jSchema;
    final Level level;

    MondrianOlap4jLevel(MondrianOlap4jSchema olap4jSchema, Level level) {
        this.olap4jSchema = olap4jSchema;
        this.level = level;
    }

    public boolean equals(Object obj) {
        return obj instanceof MondrianOlap4jLevel && this.level.equals(((MondrianOlap4jLevel)((Object)obj)).level);
    }

    public int hashCode() {
        return this.level.hashCode();
    }

    public int getDepth() {
        return this.level.getDepth() - this.getDepthOffset();
    }

    private int getDepthOffset() {
        Role.HierarchyAccess accessDetails = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection.getMondrianConnection2().getRole().getAccessDetails(this.level.getHierarchy());
        if (accessDetails == null) {
            return 0;
        }
        return accessDetails.getTopLevelDepth();
    }

    public Hierarchy getHierarchy() {
        return new MondrianOlap4jHierarchy(this.olap4jSchema, this.level.getHierarchy());
    }

    public Dimension getDimension() {
        return new MondrianOlap4jDimension(this.olap4jSchema, this.level.getDimension());
    }

    public boolean isCalculated() {
        return false;
    }

    public Level.Type getLevelType() {
        if (this.level.isAll()) {
            return Level.Type.ALL;
        }
        switch (this.level.getLevelType()) {
            case Regular: {
                return Level.Type.REGULAR;
            }
            case TimeDays: {
                return Level.Type.TIME_DAYS;
            }
            case TimeHalfYears: {
                return Level.Type.TIME_HALF_YEAR;
            }
            case TimeHours: {
                return Level.Type.TIME_HOURS;
            }
            case TimeMinutes: {
                return Level.Type.TIME_MINUTES;
            }
            case TimeMonths: {
                return Level.Type.TIME_MONTHS;
            }
            case TimeQuarters: {
                return Level.Type.TIME_QUARTERS;
            }
            case TimeSeconds: {
                return Level.Type.TIME_SECONDS;
            }
            case TimeUndefined: {
                return Level.Type.TIME_UNDEFINED;
            }
            case TimeWeeks: {
                return Level.Type.TIME_WEEKS;
            }
            case TimeYears: {
                return Level.Type.TIME_YEARS;
            }
        }
        throw Util.unexpected((Enum)this.level.getLevelType());
    }

    public NamedList<org.olap4j.metadata.Property> getProperties() {
        return this.getProperties(true);
    }

    NamedList<org.olap4j.metadata.Property> getProperties(boolean includeStandard) {
        ArrayNamedListImpl<org.olap4j.metadata.Property> list = new ArrayNamedListImpl<org.olap4j.metadata.Property>(){

            public String getName(Object property) {
                return ((org.olap4j.metadata.Property)property).getName();
            }
        };
        if (includeStandard) {
            list.addAll(Arrays.asList(Property.StandardMemberProperty.values()));
            list.addAll(MondrianOlap4jProperty.MEMBER_EXTENSIONS.values());
        }
        for (Property property : this.level.getProperties()) {
            list.add((Object)new MondrianOlap4jProperty(property));
        }
        return list;
    }

    public List<org.olap4j.metadata.Member> getMembers() throws OlapException {
        final MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        final RolapConnection mondrianConnection = olap4jConnection.getMondrianConnection();
        return (List)Locus.execute((RolapConnection)mondrianConnection, (String)"Reading members of level", (Locus.Action)new Locus.Action<List<org.olap4j.metadata.Member>>(){

            public List<org.olap4j.metadata.Member> execute() {
                SchemaReader schemaReader = mondrianConnection.getSchemaReader().withLocus();
                final List levelMembers = schemaReader.getLevelMembers(MondrianOlap4jLevel.this.level, true);
                return new AbstractList<org.olap4j.metadata.Member>(){

                    @Override
                    public org.olap4j.metadata.Member get(int index) {
                        return olap4jConnection.toOlap4j((Member)levelMembers.get(index));
                    }

                    @Override
                    public int size() {
                        return levelMembers.size();
                    }
                };
            }
        });
    }

    public String getName() {
        return this.level.getName();
    }

    public String getUniqueName() {
        return this.level.getUniqueName();
    }

    public String getCaption() {
        return this.level.getLocalized(OlapElement.LocalizedProperty.CAPTION, this.olap4jSchema.getLocale());
    }

    public String getDescription() {
        return this.level.getLocalized(OlapElement.LocalizedProperty.DESCRIPTION, this.olap4jSchema.getLocale());
    }

    public Map<String, Annotation> getAnnotations() {
        return this.level.getAnnotationMap();
    }

    public int getCardinality() {
        return this.level.getApproxRowCount();
    }

    public boolean isVisible() {
        return this.level.isVisible();
    }

    protected OlapElement getOlapElement() {
        return this.level;
    }
}

