/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.saiku.query.IQuerySet;
import org.saiku.query.ISortableQuerySet;

public class QueryUtil {
    public static List<String> parseParameters(String expression) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)expression)) {
            char[] exArray = expression.toCharArray();
            for (int i = 0; i < exArray.length - 2; ++i) {
                if (exArray[i] != '$' || exArray[i + 1] != '{') continue;
                StringBuffer sb = new StringBuffer();
                i += 2;
                while (i < exArray.length && exArray[i] != '}') {
                    sb.append(exArray[i]);
                    ++i;
                }
                String newParam = sb.toString();
                if (!StringUtils.isNotBlank((String)newParam)) continue;
                parameterNames.add(newParam);
            }
        }
        return parameterNames;
    }

    public static List<String> retrieveSortableSetParameters(ISortableQuerySet sqs) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        String sortEval = sqs.getSortEvaluationLiteral();
        List<String> sortParameters = QueryUtil.parseParameters(sortEval);
        parameterNames.addAll(sortParameters);
        parameterNames.addAll(QueryUtil.retrieveSetParameters(sqs));
        return parameterNames;
    }

    public static List<String> retrieveSetParameters(IQuerySet qs) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        String mdx = qs.getMdxSetExpression();
        List<String> mdxParameters = QueryUtil.parseParameters(mdx);
        parameterNames.addAll(mdxParameters);
        return parameterNames;
    }
}

