/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.OlapException;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LevelNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.WithSetNode;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.saiku.query.IQuerySet;
import org.saiku.query.ISortableQuerySet;
import org.saiku.query.NodeConverter;
import org.saiku.query.Query;
import org.saiku.query.QueryAxis;
import org.saiku.query.QueryDetails;
import org.saiku.query.QueryHierarchy;
import org.saiku.query.QueryLevel;
import org.saiku.query.mdx.IFilterFunction;
import org.saiku.query.metadata.CalculatedMeasure;
import org.saiku.query.metadata.CalculatedMember;

public class Olap4jNodeConverter
extends NodeConverter {
    public static SelectNode toQuery(Query query) throws Exception {
        List cellpropertyList = Collections.emptyList();
        ArrayList<ParseTreeNode> withList = new ArrayList<ParseTreeNode>();
        ArrayList<QueryAxis> axisList = new ArrayList<QueryAxis>();
        axisList.add(query.getAxes().get(Axis.COLUMNS));
        axisList.add(query.getAxes().get(Axis.ROWS));
        AxisNode filterAxis = null;
        if (query.getAxes().containsKey(Axis.FILTER)) {
            QueryAxis axis = query.getAxes().get(Axis.FILTER);
            if (!axis.hierarchies.isEmpty()) {
                filterAxis = Olap4jNodeConverter.toAxis(withList, axis);
            }
        }
        return new SelectNode(null, withList, Olap4jNodeConverter.toAxisList(withList, axisList), (ParseTreeNode)new CubeNode(null, query.getCube()), filterAxis, cellpropertyList);
    }

    private static List<AxisNode> toAxisList(List<ParseTreeNode> withList, List<QueryAxis> axes) throws Exception {
        ArrayList<AxisNode> axisList = new ArrayList<AxisNode>();
        for (QueryAxis axis : axes) {
            AxisNode axisNode = Olap4jNodeConverter.toAxis(withList, axis);
            if (axisNode == null) continue;
            axisList.add(axisNode);
        }
        return axisList;
    }

    private static AxisNode toAxis(List<ParseTreeNode> withList, QueryAxis axis) throws Exception {
        Query.BackendFlavor flavor = axis.getQuery().getFlavor();
        ParseTreeNode axisExpression = null;
        boolean axisAsSet = false;
        boolean isFilter = Axis.FILTER.equals((Object)axis.getLocation());
        if (!axis.isMdxSetExpression()) {
            ArrayList<ParseTreeNode> hierarchies = new ArrayList<ParseTreeNode>();
            int hierarchyCount = axis.getQueryHierarchies().size();
            if (hierarchyCount == 1) {
                axisExpression = Olap4jNodeConverter.toHierarchy(withList, axis.getQueryHierarchies().get(0));
                axisAsSet = true;
            } else if (hierarchyCount > 1) {
                for (QueryHierarchy h : axis.getQueryHierarchies()) {
                    ParseTreeNode hierarchyNode = Olap4jNodeConverter.toHierarchy(withList, h);
                    if (!isFilter) {
                        WithSetNode withNode = new WithSetNode(null, Olap4jNodeConverter.getIdentifier(axis.getName(), h.getHierarchy().getDimension().getName(), h.getName()), hierarchyNode);
                        withList.add((ParseTreeNode)withNode);
                        hierarchies.add((ParseTreeNode)withNode.getIdentifier());
                        continue;
                    }
                    hierarchies.add(hierarchyNode);
                }
                axisExpression = Olap4jNodeConverter.generateCrossJoin(hierarchies, axis.isNonEmpty(), true);
            }
        }
        axisExpression = Olap4jNodeConverter.toSortedQuerySet(axisExpression, axis);
        ParseTreeNode axisNode = null;
        if (flavor != null && !Query.BackendFlavor.SSAS.equals((Object)flavor) && axisExpression != null && axisAsSet) {
            WithSetNode withNode = new WithSetNode(null, Olap4jNodeConverter.getIdentifier(axis.getName()), axisExpression);
            withList.add((ParseTreeNode)withNode);
            axisNode = withNode.getIdentifier();
        } else {
            axisNode = axisExpression;
        }
        QueryDetails details = axis.getQuery().getDetails();
        if (details.getMeasures().size() > 0 && axis.getLocation().equals(details.getAxis())) {
            for (Measure m : details.getMeasures()) {
                if (!m.isCalculatedInQuery()) continue;
                WithMemberNode wm = Olap4jNodeConverter.toOlap4jCalculatedMember((CalculatedMeasure)m);
                withList.add((ParseTreeNode)wm);
            }
            ParseTreeNode measuresNode = Olap4jNodeConverter.toOlap4jMeasureSet(details.getMeasures());
            if (axisNode == null) {
                axisNode = measuresNode;
            } else {
                ArrayList<ParseTreeNode> axisNodes = new ArrayList<ParseTreeNode>();
                if (details.getLocation().equals((Object)QueryDetails.Location.TOP)) {
                    axisNodes.add(measuresNode);
                    axisNodes.add(axisNode);
                } else {
                    axisNodes.add(axisNode);
                    axisNodes.add(measuresNode);
                }
                axisNode = Olap4jNodeConverter.generateCrossJoin(axisNodes);
            }
        }
        if (axisNode == null) {
            return null;
        }
        return new AxisNode(null, axis.isNonEmpty(), axis.getLocation(), new ArrayList(), axisNode);
    }

    private static ParseTreeNode toHierarchy(List<ParseTreeNode> withList, QueryHierarchy h) throws OlapException {
        ParseTreeNode hierarchySet = null;
        if (!h.isMdxSetExpression()) {
            ParseTreeNode levelNode;
            QueryLevel l;
            int i;
            boolean isFilter = Axis.FILTER.equals((Object)h.getAxis().getLocation());
            if (h.getActiveQueryLevels().size() == 0 && h.getActiveCalculatedMembers().size() == 0) {
                return new CallNode(null, "{}", Syntax.Braces, new ArrayList());
            }
            ArrayList<ParseTreeNode> levels = new ArrayList<ParseTreeNode>();
            IdentifierNode existSet = null;
            boolean allSimple = true;
            int firstComplex = -1;
            for (i = 0; i < h.getActiveQueryLevels().size(); ++i) {
                l = h.getActiveQueryLevels().get(i);
                if ((allSimple = allSimple & l != null & l.isSimple()) || firstComplex != -1) continue;
                firstComplex = i;
                levelNode = Olap4jNodeConverter.toLevel(l);
                levelNode = Olap4jNodeConverter.toQuerySet(levelNode, l);
                existSet = Olap4jNodeConverter.getIdentifier(h.getHierarchy().getDimension().getName(), h.getName(), l.getName());
                break;
            }
            for (i = 0; i < h.getActiveQueryLevels().size(); ++i) {
                l = h.getActiveQueryLevels().get(i);
                levelNode = Olap4jNodeConverter.toLevel(l);
                levelNode = Olap4jNodeConverter.toQuerySet(levelNode, l);
                if (h.isConsistent() && existSet != null && i != firstComplex && !l.getLevel().getLevelType().equals((Object)Level.Type.ALL)) {
                    levelNode = new CallNode(null, "Exists", Syntax.Function, new ParseTreeNode[]{levelNode, existSet});
                }
                if (!allSimple && h.getActiveQueryLevels().size() > 1) {
                    WithSetNode withNode = new WithSetNode(null, Olap4jNodeConverter.getIdentifier(h.getHierarchy().getDimension().getName(), h.getName(), l.getName()), levelNode);
                    withList.add((ParseTreeNode)withNode);
                    levelNode = withNode.getIdentifier();
                    if (!l.isSimple() || existSet != null && i > firstComplex) {
                        existSet = levelNode;
                    }
                }
                levels.add(levelNode);
            }
            CallNode levelSet = null;
            if (h.getAxis().isLowestLevelsOnly()) {
                ParseTreeNode lowestLevel = (ParseTreeNode)levels.remove(levels.size() - 1);
                levels.clear();
                levels.add(lowestLevel);
            }
            if (levels.size() > 1) {
                levelSet = Olap4jNodeConverter.generateListSetCall(levels);
            } else if (levels.size() == 1) {
                levelSet = (ParseTreeNode)levels.get(0);
            }
            if (!isFilter && !h.getAxis().isLowestLevelsOnly() && h.needsHierarchize()) {
                levelSet = new CallNode(null, "Hierarchize", Syntax.Function, new ParseTreeNode[]{levelSet});
            }
            ArrayList<ParseTreeNode> cmNodes = new ArrayList<ParseTreeNode>();
            for (CalculatedMember cm : h.getActiveCalculatedMembers()) {
                WithMemberNode wm = Olap4jNodeConverter.toOlap4jCalculatedMember(cm);
                withList.add((ParseTreeNode)wm);
                cmNodes.add((ParseTreeNode)wm.getIdentifier());
            }
            if (cmNodes.size() > 0) {
                CallNode cmSet = Olap4jNodeConverter.generateListSetCall(cmNodes);
                hierarchySet = levelSet != null ? Olap4jNodeConverter.generateSetCall(new ParseTreeNode[]{cmSet, levelSet}) : cmSet;
            } else {
                hierarchySet = levelSet;
            }
        }
        hierarchySet = Olap4jNodeConverter.toSortedQuerySet(hierarchySet, h);
        if (h.isVisualTotals()) {
            hierarchySet = h.getVisualTotalsPattern() != null ? new CallNode(null, "VisualTotals", Syntax.Function, new ParseTreeNode[]{hierarchySet, LiteralNode.createString(null, (String)h.getVisualTotalsPattern())}) : new CallNode(null, "VisualTotals", Syntax.Function, new ParseTreeNode[]{hierarchySet});
        }
        return hierarchySet;
    }

    private static ParseTreeNode toLevel(QueryLevel level) throws OlapException {
        ArrayList<Member> inclusions = new ArrayList<Member>();
        ArrayList<Member> exclusions = new ArrayList<Member>();
        inclusions.addAll(level.getInclusions());
        exclusions.addAll(level.getExclusions());
        if (level.hasParameter()) {
            String parameterName = level.getParameterName();
            String parameterValue = level.getQueryHierarchy().getQuery().getParameter(parameterName);
            if (StringUtils.isNotBlank((String)parameterValue)) {
                List<Member> resolvedParameters = Olap4jNodeConverter.resolveParameter(level.getQueryHierarchy().getQuery().getCube(), level.getUniqueName(), parameterValue);
                switch (level.getParameterSelectionType()) {
                    case EXCLUSION: {
                        exclusions.clear();
                        exclusions.addAll(resolvedParameters);
                        break;
                    }
                    case INCLUSION: {
                        inclusions.clear();
                        inclusions.addAll(resolvedParameters);
                        break;
                    }
                }
            }
        }
        CallNode baseNode = new CallNode(null, "Members", Syntax.Property, new ParseTreeNode[]{new LevelNode(null, level.getLevel())});
        if (level.getLevel().getLevelType().equals((Object)Level.Type.ALL)) {
            try {
                baseNode = new MemberNode(null, level.getLevel().getHierarchy().getDefaultMember());
            }
            catch (OlapException e) {
                throw new RuntimeException("Cannot include hierarchy default member for " + level.getUniqueName());
            }
        }
        baseNode = Olap4jNodeConverter.generateSetCall(new ParseTreeNode[]{baseNode});
        if (level.isRange()) {
            if (level.getRangeStart() != null && level.getRangeEnd() != null) {
                ArrayList<MemberNode> args = new ArrayList<MemberNode>();
                args.add(new MemberNode(null, level.getRangeStart()));
                args.add(new MemberNode(null, level.getRangeEnd()));
                baseNode = new CallNode(null, ":", Syntax.Infix, args);
            } else {
                String startExpr = level.getRangeStartExpr();
                String endExpr = level.getRangeEndExpr();
                baseNode = StringUtils.isBlank((String)endExpr) ? Olap4jNodeConverter.toMdxNode(startExpr) : Olap4jNodeConverter.toMdxNode(startExpr + " : " + endExpr);
            }
        }
        if (inclusions.size() > 0) {
            baseNode = Olap4jNodeConverter.toOlap4jMemberSet(inclusions);
        }
        if (exclusions.size() > 0) {
            ParseTreeNode exceptSet = Olap4jNodeConverter.toOlap4jMemberSet(exclusions);
            baseNode = new CallNode(null, "Except", Syntax.Function, new ParseTreeNode[]{baseNode, exceptSet});
        }
        return baseNode;
    }

    @Deprecated
    private static List<Member> resolveParameter(Cube cube, String parent, String value) throws OlapException {
        List parentParts = null;
        if (StringUtils.isNotBlank((String)parent)) {
            parentParts = IdentifierParser.parseIdentifier((String)parent);
        }
        ArrayList<Member> resolvedList = new ArrayList<Member>();
        if (StringUtils.isNotBlank((String)value)) {
            String[] vs;
            for (String v : vs = value.split(",")) {
                if (!StringUtils.isNotBlank((String)(v = v.trim()))) continue;
                List nameParts = IdentifierParser.parseIdentifier((String)v);
                ArrayList combined = new ArrayList();
                if (parentParts != null && nameParts.size() == 1) {
                    combined.addAll(parentParts);
                }
                combined.addAll(nameParts);
                Member m = cube.lookupMember(combined);
                if (m == null) {
                    throw new OlapException("Cannot find member with name parts: " + ((Object)combined).toString());
                }
                resolvedList.add(m);
            }
        }
        return resolvedList;
    }

    private static ParseTreeNode toMdxNode(String mdx) {
        DefaultMdxParserImpl parser = new DefaultMdxParserImpl();
        ParseTreeNode expression = parser.parseExpression(mdx);
        return expression;
    }

    private static ParseTreeNode toQuerySet(ParseTreeNode expression, IQuerySet o) {
        DefaultMdxParserImpl parser = new DefaultMdxParserImpl();
        if (o.isMdxSetExpression()) {
            expression = Olap4jNodeConverter.toMdxNode("{" + o.getMdxSetExpression() + "}");
        }
        if (expression != null && o.getFilters().size() > 0) {
            for (IFilterFunction filter : o.getFilters()) {
                expression = filter.visit((MdxParser)parser, expression);
            }
        }
        return expression;
    }

    private static ParseTreeNode toSortedQuerySet(ParseTreeNode expression, ISortableQuerySet o) {
        if ((expression = Olap4jNodeConverter.toQuerySet(expression, o)) == null) {
            return null;
        }
        if (o.getSortOrder() != null) {
            LiteralNode evaluatorNode = LiteralNode.createSymbol(null, (String)o.getSortEvaluationLiteral());
            expression = new CallNode(null, "Order", Syntax.Function, new ParseTreeNode[]{expression, evaluatorNode, LiteralNode.createSymbol(null, (String)o.getSortOrder().name())});
        } else if (o.getHierarchizeMode() != null) {
            if (o.getHierarchizeMode().equals((Object)ISortableQuerySet.HierarchizeMode.PRE)) {
                expression = new CallNode(null, "Hierarchize", Syntax.Function, new ParseTreeNode[]{expression});
            } else if (o.getHierarchizeMode().equals((Object)ISortableQuerySet.HierarchizeMode.POST)) {
                expression = new CallNode(null, "Hierarchize", Syntax.Function, new ParseTreeNode[]{expression, LiteralNode.createSymbol(null, (String)o.getHierarchizeMode().name())});
            } else {
                throw new RuntimeException("Missing value handler.");
            }
        }
        return expression;
    }
}

