/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation.handlers;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceContentStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;

public class PDPolygonAppearanceHandler
extends PDAbstractAppearanceHandler {
    public PDPolygonAppearanceHandler(PDAnnotation annotation) {
        super(annotation);
    }

    @Override
    public void generateAppearanceStreams() {
        this.generateNormalAppearance();
        this.generateRolloverAppearance();
        this.generateDownAppearance();
    }

    @Override
    public void generateNormalAppearance() {
        float lineWidth = this.getLineWidth();
        try {
            PDAnnotation annotation = this.getAnnotation();
            PDAppearanceContentStream contentStream = this.getNormalAppearanceAsContentStream();
            contentStream.setStrokingColorOnDemand(this.getColor());
            contentStream.setBorderLine(lineWidth, ((PDAnnotationMarkup)annotation).getBorderStyle());
            this.setRectDifference(lineWidth);
            COSBase path = annotation.getCOSObject().getDictionaryObject(COSName.getPDFName("Path"));
            if (path instanceof COSArray) {
                COSArray pathArray = (COSArray)path;
                for (int i = 0; i < pathArray.size(); ++i) {
                    COSBase points = pathArray.get(i);
                    if (!(points instanceof COSArray)) continue;
                    float[] pointsArray = ((COSArray)points).toFloatArray();
                    if (i == 0 && pointsArray.length == 2) {
                        contentStream.moveTo(pointsArray[0], pointsArray[1]);
                        continue;
                    }
                    if (pointsArray.length == 2) {
                        contentStream.lineTo(pointsArray[0], pointsArray[1]);
                        continue;
                    }
                    if (pointsArray.length != 6) continue;
                    contentStream.curveTo(pointsArray[0], pointsArray[1], pointsArray[2], pointsArray[3], pointsArray[4], pointsArray[5]);
                }
            } else {
                COSBase vertices = annotation.getCOSObject().getDictionaryObject(COSName.VERTICES);
                if (!(vertices instanceof COSArray)) {
                    return;
                }
                COSArray verticesArray = (COSArray)vertices;
                int nPoints = verticesArray.size() / 2;
                for (int i = 0; i < nPoints; ++i) {
                    COSBase bx = verticesArray.getObject(i * 2);
                    COSBase by = verticesArray.getObject(i * 2 + 1);
                    if (!(bx instanceof COSNumber) || !(by instanceof COSNumber)) continue;
                    float x = ((COSNumber)bx).floatValue();
                    float y = ((COSNumber)by).floatValue();
                    if (i == 0) {
                        contentStream.moveTo(x, y);
                        continue;
                    }
                    contentStream.lineTo(x, y);
                }
                contentStream.stroke();
            }
            contentStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }

    float getLineWidth() {
        PDAnnotationLink annotation = (PDAnnotationLink)this.getAnnotation();
        PDBorderStyleDictionary bs = annotation.getBorderStyle();
        if (bs != null) {
            return bs.getWidth();
        }
        COSArray borderCharacteristics = annotation.getBorder();
        if (borderCharacteristics != null && borderCharacteristics.size() >= 3) {
            return borderCharacteristics.getInt(3);
        }
        return 1.0f;
    }
}

