/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation.handlers;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceContentStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;

public class PDLinkAppearanceHandler
extends PDAbstractAppearanceHandler {
    public PDLinkAppearanceHandler(PDAnnotation annotation) {
        super(annotation);
    }

    @Override
    public void generateAppearanceStreams() {
        this.generateNormalAppearance();
        this.generateRolloverAppearance();
        this.generateDownAppearance();
    }

    @Override
    public void generateNormalAppearance() {
        float lineWidth = this.getLineWidth();
        try {
            PDAppearanceContentStream contentStream = this.getNormalAppearanceAsContentStream();
            contentStream.setStrokingColorOnDemand(this.getColor());
            boolean hasBackground = contentStream.setNonStrokingColorOnDemand(this.getAnnotation().getColor());
            contentStream.setBorderLine(lineWidth, ((PDAnnotationLink)this.getAnnotation()).getBorderStyle());
            this.setRectDifference(lineWidth);
            PDRectangle borderEdge = this.getPaddedRectangle(this.getRectangle(), lineWidth / 2.0f);
            contentStream.addRect(borderEdge.getLowerLeftX(), borderEdge.getLowerLeftY(), borderEdge.getWidth(), borderEdge.getHeight());
            contentStream.drawShape(lineWidth, hasBackground);
            contentStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }

    float getLineWidth() {
        PDAnnotationLink annotation = (PDAnnotationLink)this.getAnnotation();
        PDBorderStyleDictionary bs = annotation.getBorderStyle();
        if (bs != null) {
            return bs.getWidth();
        }
        COSArray borderCharacteristics = annotation.getBorder();
        if (borderCharacteristics != null && borderCharacteristics.size() >= 3) {
            return borderCharacteristics.getInt(3);
        }
        return 1.0f;
    }
}

