/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation.handlers;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquareCircle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceContentStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;

public class PDCircleAppearanceHandler
extends PDAbstractAppearanceHandler {
    public PDCircleAppearanceHandler(PDAnnotation annotation) {
        super(annotation);
    }

    @Override
    public void generateAppearanceStreams() {
        this.generateNormalAppearance();
        this.generateRolloverAppearance();
        this.generateDownAppearance();
    }

    @Override
    public void generateNormalAppearance() {
        float lineWidth = this.getLineWidth();
        try {
            PDAppearanceContentStream contentStream = this.getNormalAppearanceAsContentStream();
            contentStream.setStrokingColorOnDemand(this.getColor());
            boolean hasBackground = contentStream.setNonStrokingColorOnDemand(((PDAnnotationSquareCircle)this.getAnnotation()).getInteriorColor());
            this.handleOpacity(((PDAnnotationSquareCircle)this.getAnnotation()).getConstantOpacity());
            contentStream.setBorderLine(lineWidth, ((PDAnnotationSquareCircle)this.getAnnotation()).getBorderStyle());
            this.setRectDifference(lineWidth);
            PDRectangle bbox = this.getRectangle();
            PDRectangle borderEdge = this.getPaddedRectangle(bbox, lineWidth / 2.0f);
            float x0 = borderEdge.getLowerLeftX();
            float y0 = borderEdge.getLowerLeftY();
            float x1 = borderEdge.getUpperRightX();
            float y1 = borderEdge.getUpperRightY();
            float xm = x0 + borderEdge.getWidth() / 2.0f;
            float ym = y0 + borderEdge.getHeight() / 2.0f;
            float magic = 0.55555415f;
            float vOffset = borderEdge.getHeight() / 2.0f * magic;
            float hOffset = borderEdge.getWidth() / 2.0f * magic;
            contentStream.moveTo(xm, y1);
            contentStream.curveTo(xm + hOffset, y1, x1, ym + vOffset, x1, ym);
            contentStream.curveTo(x1, ym - vOffset, xm + hOffset, y0, xm, y0);
            contentStream.curveTo(xm - hOffset, y0, x0, ym - vOffset, x0, ym);
            contentStream.curveTo(x0, ym + vOffset, xm - hOffset, y1, xm, y1);
            contentStream.closePath();
            contentStream.drawShape(lineWidth, hasBackground);
            contentStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }

    float getLineWidth() {
        PDAnnotationSquareCircle annotation = (PDAnnotationSquareCircle)this.getAnnotation();
        PDBorderStyleDictionary bs = annotation.getBorderStyle();
        if (bs != null) {
            return bs.getWidth();
        }
        COSArray borderCharacteristics = annotation.getBorder();
        if (borderCharacteristics != null && borderCharacteristics.size() >= 3) {
            return borderCharacteristics.getInt(3);
        }
        return 1.0f;
    }
}

