/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation.handlers;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquareCircle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceContentStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAppearanceHandler;

public abstract class PDAbstractAppearanceHandler
implements PDAppearanceHandler {
    private PDAnnotation annotation;
    private PDAppearanceEntry appearanceEntry;
    private PDAppearanceContentStream contentStream;

    public PDAbstractAppearanceHandler(PDAnnotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public abstract void generateNormalAppearance();

    @Override
    public abstract void generateRolloverAppearance();

    @Override
    public abstract void generateDownAppearance();

    PDAnnotation getAnnotation() {
        return this.annotation;
    }

    PDColor getColor() {
        return this.annotation.getColor();
    }

    PDRectangle getRectangle() {
        return this.annotation.getRectangle();
    }

    PDAppearanceDictionary getAppearance() {
        PDAppearanceDictionary appearanceDictionary = this.annotation.getAppearance();
        if (appearanceDictionary == null) {
            appearanceDictionary = new PDAppearanceDictionary();
            this.annotation.setAppearance(appearanceDictionary);
        }
        return appearanceDictionary;
    }

    PDAppearanceContentStream getNormalAppearanceAsContentStream() throws IOException {
        this.appearanceEntry = this.getNormalAppearance();
        this.contentStream = this.getAppearanceEntryAsContentStream(this.appearanceEntry);
        return this.contentStream;
    }

    PDAppearanceEntry getDownAppearance() {
        PDAppearanceDictionary appearanceDictionary = this.getAppearance();
        PDAppearanceEntry appearanceEntry = appearanceDictionary.getDownAppearance();
        if (appearanceEntry.isSubDictionary()) {
            appearanceEntry = new PDAppearanceEntry(new COSStream());
            appearanceDictionary.setDownAppearance(appearanceEntry);
        }
        return appearanceEntry;
    }

    PDAppearanceEntry getRolloverAppearance() {
        PDAppearanceDictionary appearanceDictionary = this.getAppearance();
        PDAppearanceEntry appearanceEntry = appearanceDictionary.getRolloverAppearance();
        if (appearanceEntry.isSubDictionary()) {
            appearanceEntry = new PDAppearanceEntry(new COSStream());
            appearanceDictionary.setRolloverAppearance(appearanceEntry);
        }
        return appearanceEntry;
    }

    void setRectDifference(float lineWidth) {
        if (this.annotation instanceof PDAnnotationSquareCircle && lineWidth > 0.0f) {
            PDRectangle differences = new PDRectangle(lineWidth / 2.0f, lineWidth / 2.0f, 0.0f, 0.0f);
            ((PDAnnotationSquareCircle)this.annotation).setRectDifference(differences);
        }
    }

    PDRectangle getPaddedRectangle(PDRectangle rectangle, float padding) {
        return new PDRectangle(rectangle.getLowerLeftX() + padding, rectangle.getLowerLeftY() + padding, rectangle.getWidth() - 2.0f * padding, rectangle.getHeight() - 2.0f * padding);
    }

    void handleOpacity(float opacity) throws IOException {
        if (opacity < 1.0f) {
            PDExtendedGraphicsState gs = new PDExtendedGraphicsState();
            gs.setStrokingAlphaConstant(Float.valueOf(opacity));
            gs.setNonStrokingAlphaConstant(Float.valueOf(opacity));
            PDAppearanceStream appearanceStream = this.appearanceEntry.getAppearanceStream();
            PDResources resources = appearanceStream.getResources();
            if (resources == null) {
                resources = new PDResources();
                appearanceStream.setResources(resources);
                this.contentStream.setResources(resources);
            }
            this.contentStream.setGraphicsStateParameters(gs);
        }
    }

    private PDAppearanceEntry getNormalAppearance() {
        PDAppearanceDictionary appearanceDictionary = this.getAppearance();
        PDAppearanceEntry appearanceEntry = appearanceDictionary.getNormalAppearance();
        if (appearanceEntry.isSubDictionary()) {
            appearanceEntry = new PDAppearanceEntry(new COSStream());
            appearanceDictionary.setNormalAppearance(appearanceEntry);
        }
        return appearanceEntry;
    }

    private PDAppearanceContentStream getAppearanceEntryAsContentStream(PDAppearanceEntry appearanceEntry) throws IOException {
        PDAppearanceStream appearanceStream = appearanceEntry.getAppearanceStream();
        this.setTransformationMatrix(appearanceStream);
        return new PDAppearanceContentStream(appearanceStream);
    }

    private void setTransformationMatrix(PDAppearanceStream appearanceStream) {
        PDRectangle bbox = this.getRectangle();
        appearanceStream.setBBox(bbox);
        AffineTransform transform = AffineTransform.getTranslateInstance(-bbox.getLowerLeftX(), -bbox.getLowerLeftY());
        appearanceStream.setMatrix(transform);
    }
}

