/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.contentstream.PDAbstractContentStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public final class PDAppearanceContentStream
extends PDAbstractContentStream
implements Closeable {
    public PDAppearanceContentStream(PDAppearanceStream appearance) throws IOException {
        this(appearance, appearance.getStream().createOutputStream());
    }

    public PDAppearanceContentStream(PDAppearanceStream appearance, OutputStream outputStream) throws IOException {
        super(appearance, outputStream);
        this.setResources(appearance.getResources());
    }

    public boolean setStrokingColorOnDemand(PDColor color) throws IOException {
        float[] components;
        if (color != null && (components = color.getComponents()) != null && components.length > 0) {
            this.setStrokingColor(components);
            return true;
        }
        return false;
    }

    public void setStrokingColor(float[] components) throws IOException {
        for (float value : components) {
            this.writeOperand(value);
        }
        int numComponents = components.length;
        switch (numComponents) {
            case 1: {
                this.writeOperator("G");
                break;
            }
            case 3: {
                this.writeOperator("RG");
                break;
            }
            case 4: {
                this.writeOperator("K");
            }
        }
    }

    public boolean setNonStrokingColorOnDemand(PDColor color) throws IOException {
        float[] components;
        if (color != null && (components = color.getComponents()) != null && components.length > 0) {
            this.setNonStrokingColor(components);
            return true;
        }
        return false;
    }

    public void setNonStrokingColor(float[] components) throws IOException {
        for (float value : components) {
            this.writeOperand(value);
        }
        int numComponents = components.length;
        switch (numComponents) {
            case 1: {
                this.writeOperator("g");
                break;
            }
            case 3: {
                this.writeOperator("rg");
                break;
            }
            case 4: {
                this.writeOperator("k");
            }
        }
    }

    public void setBorderLine(float lineWidth, PDBorderStyleDictionary bs) throws IOException {
        if (bs != null && bs.getCOSObject().containsKey(COSName.D)) {
            this.setLineDashPattern(bs.getDashStyle().getDashArray(), 0.0f);
        } else {
            this.setLineWidthOnDemand(lineWidth);
        }
    }

    public void setLineWidthOnDemand(float lineWidth) throws IOException {
        if (!((double)Math.abs(lineWidth - 1.0f) < 1.0E-6)) {
            this.setLineWidth(lineWidth);
        }
    }

    public void drawShape(float lineWidth, boolean hasBackground) throws IOException {
        if ((double)lineWidth < 1.0E-6) {
            this.writeOperator("n");
        } else if (!hasBackground) {
            this.stroke();
        } else {
            this.fillAndStroke();
        }
    }

    public static enum AppendMode {
        OVERWRITE,
        APPEND,
        PREPEND;


        public boolean isOverwrite() {
            return this == OVERWRITE;
        }

        public boolean isPrepend() {
            return this == PREPEND;
        }
    }
}

