/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDAbstractContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;

public final class PDPageContentStream
extends PDAbstractContentStream
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PDPageContentStream.class);
    private final PDDocument document;
    private final Stack<PDFont> fontStack = new Stack();
    private final Stack<PDColorSpace> nonStrokingColorSpaceStack = new Stack();
    private final Stack<PDColorSpace> strokingColorSpaceStack = new Stack();

    public PDPageContentStream(PDDocument document, PDPage sourcePage) throws IOException {
        this(document, sourcePage, AppendMode.OVERWRITE, true, false);
    }

    @Deprecated
    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress) throws IOException {
        this(document, sourcePage, appendContent, compress, false);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, AppendMode appendContent, boolean compress) throws IOException {
        this(document, sourcePage, appendContent, compress, false);
    }

    @Deprecated
    public PDPageContentStream(PDDocument document, PDPage sourcePage, boolean appendContent, boolean compress, boolean resetContext) throws IOException {
        this(document, sourcePage, appendContent ? AppendMode.APPEND : AppendMode.OVERWRITE, compress, resetContext);
    }

    public PDPageContentStream(PDDocument document, PDPage sourcePage, AppendMode appendContent, boolean compress, boolean resetContext) throws IOException {
        COSName filter;
        this.document = document;
        COSName cOSName = filter = compress ? COSName.FLATE_DECODE : null;
        if (!appendContent.isOverwrite() && sourcePage.hasContents()) {
            COSArray array;
            PDStream contentsToAppend = new PDStream(document);
            COSBase contents = sourcePage.getCOSObject().getDictionaryObject(COSName.CONTENTS);
            if (contents instanceof COSArray) {
                array = (COSArray)contents;
            } else {
                array = new COSArray();
                array.add(contents);
            }
            if (appendContent.isPrepend()) {
                array.add(0, contentsToAppend.getCOSObject());
            } else {
                array.add(contentsToAppend);
            }
            if (resetContext) {
                PDStream saveGraphics = new PDStream(document);
                this.setOutput(saveGraphics.createOutputStream(filter));
                this.saveGraphicsState();
                this.close();
                array.add(0, saveGraphics.getCOSObject());
            }
            sourcePage.getCOSObject().setItem(COSName.CONTENTS, (COSBase)array);
            this.setOutput(contentsToAppend.createOutputStream(filter));
            if (resetContext) {
                this.restoreGraphicsState();
            }
        } else {
            if (sourcePage.hasContents()) {
                LOG.warn("You are overwriting an existing content, you should use the append mode");
            }
            PDStream contents = new PDStream(document);
            sourcePage.setContents(contents);
            this.setOutput(contents.createOutputStream(filter));
        }
        PDResources resources = sourcePage.getResources();
        if (resources == null) {
            resources = new PDResources();
            sourcePage.setResources(resources);
        }
        this.setResources(resources);
        this.setMaximumFractionDigits(5);
    }

    public PDPageContentStream(PDDocument doc, PDAppearanceStream appearance) throws IOException {
        this(doc, appearance, appearance.getStream().createOutputStream());
    }

    public PDPageContentStream(PDDocument doc, PDAppearanceStream appearance, OutputStream outputStream) throws IOException {
        super(appearance, outputStream);
        this.document = doc;
        this.setResources(appearance.getResources());
    }

    @Override
    public void setFont(PDFont font, float fontSize) throws IOException {
        if (this.fontStack.isEmpty()) {
            this.fontStack.add(font);
        } else {
            this.fontStack.setElementAt(font, this.fontStack.size() - 1);
        }
        if (font.willBeSubset()) {
            this.document.getFontsToSubset().add(font);
        }
        this.writeOperand(this.getResources().add(font));
        this.writeOperand(fontSize);
        this.writeOperator("Tf");
    }

    @Deprecated
    public void drawString(String text) throws IOException {
        this.showText(text);
    }

    @Override
    public void showText(String text) throws IOException {
        if (!this.isInTextMode()) {
            throw new IllegalStateException("Must call beginText() before showText()");
        }
        if (this.fontStack.isEmpty()) {
            throw new IllegalStateException("Must call setFont() before showText()");
        }
        PDFont font = this.fontStack.peek();
        if (font.willBeSubset()) {
            int codePoint;
            for (int offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                font.addToSubset(codePoint);
            }
        }
        COSWriter.writeString(font.encode(text), this.getOutput());
        this.write(" ");
        this.writeOperator("Tj");
    }

    @Deprecated
    public void moveTextPositionByAmount(float tx, float ty) throws IOException {
        this.newLineAtOffset(tx, ty);
    }

    @Deprecated
    public void setTextMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        this.setTextMatrix(new Matrix((float)a, (float)b, (float)c, (float)d, (float)e, (float)f));
    }

    @Deprecated
    public void setTextMatrix(AffineTransform matrix) throws IOException {
        this.setTextMatrix(new Matrix(matrix));
    }

    @Deprecated
    public void setTextScaling(double sx, double sy, double tx, double ty) throws IOException {
        this.setTextMatrix(new Matrix((float)sx, 0.0f, 0.0f, (float)sy, (float)tx, (float)ty));
    }

    @Deprecated
    public void setTextTranslation(double tx, double ty) throws IOException {
        this.setTextMatrix(Matrix.getTranslateInstance((float)tx, (float)ty));
    }

    @Deprecated
    public void setTextRotation(double angle, double tx, double ty) throws IOException {
        this.setTextMatrix(Matrix.getRotateInstance(angle, (float)tx, (float)ty));
    }

    @Deprecated
    public void drawInlineImage(PDInlineImage inlineImage, float x, float y) throws IOException {
        this.drawImage(inlineImage, x, y, (float)inlineImage.getWidth(), (float)inlineImage.getHeight());
    }

    @Deprecated
    public void drawInlineImage(PDInlineImage inlineImage, float x, float y, float width, float height) throws IOException {
        this.drawImage(inlineImage, x, y, width, height);
    }

    @Deprecated
    public void drawXObject(PDXObject xobject, float x, float y, float width, float height) throws IOException {
        AffineTransform transform = new AffineTransform(width, 0.0f, 0.0f, height, x, y);
        this.drawXObject(xobject, transform);
    }

    @Deprecated
    public void drawXObject(PDXObject xobject, AffineTransform transform) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: drawXObject is not allowed within a text block.");
        }
        String xObjectPrefix = xobject instanceof PDImageXObject ? "Im" : "Form";
        COSName objMapping = this.getResources().add(xobject, xObjectPrefix);
        this.saveGraphicsState();
        this.transform(new Matrix(transform));
        this.writeOperand(objMapping);
        this.writeOperator("Do");
        this.restoreGraphicsState();
    }

    @Deprecated
    public void concatenate2CTM(double a, double b, double c, double d, double e, double f) throws IOException {
        this.transform(new Matrix((float)a, (float)b, (float)c, (float)d, (float)e, (float)f));
    }

    @Deprecated
    public void concatenate2CTM(AffineTransform at) throws IOException {
        this.transform(new Matrix(at));
    }

    @Override
    public void saveGraphicsState() throws IOException {
        if (!this.fontStack.isEmpty()) {
            this.fontStack.push(this.fontStack.peek());
        }
        if (!this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.push(this.strokingColorSpaceStack.peek());
        }
        if (!this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.push(this.nonStrokingColorSpaceStack.peek());
        }
        this.writeOperator("q");
    }

    @Override
    public void restoreGraphicsState() throws IOException {
        if (!this.fontStack.isEmpty()) {
            this.fontStack.pop();
        }
        if (!this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.pop();
        }
        if (!this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.pop();
        }
        this.writeOperator("Q");
    }

    @Deprecated
    public void setStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.setStrokingColorSpaceStack(colorSpace);
        this.writeOperand(this.getName(colorSpace));
        this.writeOperator("CS");
    }

    @Deprecated
    public void setNonStrokingColorSpace(PDColorSpace colorSpace) throws IOException {
        this.setNonStrokingColorSpaceStack(colorSpace);
        this.writeOperand(this.getName(colorSpace));
        this.writeOperator("cs");
    }

    @Deprecated
    public void setStrokingColor(float[] components) throws IOException {
        if (this.strokingColorSpaceStack.isEmpty()) {
            throw new IllegalStateException("The color space must be set before setting a color");
        }
        for (float component : components) {
            this.writeOperand(component);
        }
        PDColorSpace currentStrokingColorSpace = this.strokingColorSpaceStack.peek();
        if (currentStrokingColorSpace instanceof PDSeparation || currentStrokingColorSpace instanceof PDPattern || currentStrokingColorSpace instanceof PDICCBased) {
            this.writeOperator("SCN");
        } else {
            this.writeOperator("SC");
        }
    }

    @Deprecated
    public void setStrokingColor(int c, int m, int y, int k) throws IOException {
        if (this.isOutside255Interval(c) || this.isOutside255Interval(m) || this.isOutside255Interval(y) || this.isOutside255Interval(k)) {
            throw new IllegalArgumentException("Parameters must be within 0..255, but are " + String.format("(%d,%d,%d,%d)", c, m, y, k));
        }
        this.setStrokingColor((float)c / 255.0f, (float)m / 255.0f, (float)y / 255.0f, (float)k / 255.0f);
    }

    @Deprecated
    public void setStrokingColor(int g) throws IOException {
        if (this.isOutside255Interval(g)) {
            throw new IllegalArgumentException("Parameter must be within 0..255, but is " + g);
        }
        this.setStrokingColor((float)g / 255.0f);
    }

    @Deprecated
    public void setNonStrokingColor(float[] components) throws IOException {
        if (this.nonStrokingColorSpaceStack.isEmpty()) {
            throw new IllegalStateException("The color space must be set before setting a color");
        }
        for (float component : components) {
            this.writeOperand(component);
        }
        PDColorSpace currentNonStrokingColorSpace = this.nonStrokingColorSpaceStack.peek();
        if (currentNonStrokingColorSpace instanceof PDSeparation || currentNonStrokingColorSpace instanceof PDPattern || currentNonStrokingColorSpace instanceof PDICCBased) {
            this.writeOperator("scn");
        } else {
            this.writeOperator("sc");
        }
    }

    @Deprecated
    public void fillRect(float x, float y, float width, float height) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: fillRect is not allowed within a text block.");
        }
        this.addRect(x, y, width, height);
        this.fill();
    }

    @Deprecated
    public void addBezier312(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        this.curveTo(x1, y1, x2, y2, x3, y3);
    }

    @Deprecated
    public void addBezier32(float x2, float y2, float x3, float y3) throws IOException {
        this.curveTo2(x2, y2, x3, y3);
    }

    @Deprecated
    public void addBezier31(float x1, float y1, float x3, float y3) throws IOException {
        this.curveTo1(x1, y1, x3, y3);
    }

    @Deprecated
    public void addLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: addLine is not allowed within a text block.");
        }
        this.moveTo(xStart, yStart);
        this.lineTo(xEnd, yEnd);
    }

    @Deprecated
    public void drawLine(float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: drawLine is not allowed within a text block.");
        }
        this.moveTo(xStart, yStart);
        this.lineTo(xEnd, yEnd);
        this.stroke();
    }

    @Deprecated
    public void addPolygon(float[] x, float[] y) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: addPolygon is not allowed within a text block.");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("Error: some points are missing coordinate");
        }
        for (int i = 0; i < x.length; ++i) {
            if (i == 0) {
                this.moveTo(x[i], y[i]);
                continue;
            }
            this.lineTo(x[i], y[i]);
        }
        this.closeSubPath();
    }

    @Deprecated
    public void drawPolygon(float[] x, float[] y) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: drawPolygon is not allowed within a text block.");
        }
        this.addPolygon(x, y);
        this.stroke();
    }

    @Deprecated
    public void fillPolygon(float[] x, float[] y) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: fillPolygon is not allowed within a text block.");
        }
        this.addPolygon(x, y);
        this.fill();
    }

    @Deprecated
    public void fill(int windingRule) throws IOException {
        if (windingRule == 1) {
            this.fill();
        } else if (windingRule == 0) {
            this.fillEvenOdd();
        } else {
            throw new IllegalArgumentException("Error: unknown value for winding rule");
        }
    }

    @Deprecated
    public void closeSubPath() throws IOException {
        this.closePath();
    }

    @Deprecated
    public void clipPath(int windingRule) throws IOException {
        if (this.isInTextMode()) {
            throw new IllegalStateException("Error: clipPath is not allowed within a text block.");
        }
        if (windingRule == 1) {
            this.writeOperator("W");
        } else if (windingRule == 0) {
            this.writeOperator("W*");
        } else {
            throw new IllegalArgumentException("Error: unknown value for winding rule");
        }
        this.writeOperator("n");
    }

    @Deprecated
    public void beginMarkedContentSequence(COSName tag) throws IOException {
        this.beginMarkedContent(tag);
    }

    @Deprecated
    public void beginMarkedContentSequence(COSName tag, COSName propsName) throws IOException {
        this.writeOperand(tag);
        this.writeOperand(propsName);
        this.writeOperator("BDC");
    }

    @Deprecated
    public void endMarkedContentSequence() throws IOException {
        this.endMarkedContent();
    }

    @Deprecated
    public void appendRawCommands(String commands) throws IOException {
        this.write(commands);
    }

    @Deprecated
    public void appendRawCommands(byte[] commands) throws IOException {
        this.write(commands);
    }

    @Deprecated
    public void appendRawCommands(int data) throws IOException {
        this.writeOperand(data);
    }

    @Deprecated
    public void appendRawCommands(double data) throws IOException {
        this.writeOperand(data);
    }

    @Deprecated
    public void appendRawCommands(float data) throws IOException {
        this.writeOperand(data);
    }

    @Deprecated
    public void appendCOSName(COSName name) throws IOException {
        this.writeOperand(name);
    }

    @Override
    public void setGraphicsStateParameters(PDExtendedGraphicsState state) throws IOException {
        this.writeOperand(this.getResources().add(state));
        this.writeOperator("gs");
    }

    public void setRenderingMode(RenderingMode rm) throws IOException {
        this.writeOperand(rm.intValue());
        this.writeOperator("Tr");
    }

    public static enum AppendMode {
        OVERWRITE,
        APPEND,
        PREPEND;


        public boolean isOverwrite() {
            return this == OVERWRITE;
        }

        public boolean isPrepend() {
            return this == PREPEND;
        }
    }
}

