/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.pagepane;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;

final class DebugTextOverlay {
    private PDDocument document;
    private int pageIndex;
    private float scale;
    private boolean showTextStripper;
    private boolean showTextStripperBeads;
    private boolean showFontBBox;

    public DebugTextOverlay(PDDocument document, int pageIndex, float scale, boolean showTextStripper, boolean showTextStripperBeads, boolean showFontBBox) {
        this.document = document;
        this.pageIndex = pageIndex;
        this.scale = scale;
        this.showTextStripper = showTextStripper;
        this.showTextStripperBeads = showTextStripperBeads;
        this.showFontBBox = showFontBBox;
    }

    public void renderTo(Graphics2D graphics) throws IOException {
        DebugTextStripper stripper = new DebugTextStripper(graphics);
        stripper.stripPage(this.document, this.document.getPage(this.pageIndex), this.pageIndex, this.scale);
    }

    private class DebugTextStripper
    extends PDFTextStripper {
        private Graphics2D graphics;
        private AffineTransform flip;

        public DebugTextStripper(Graphics2D graphics) throws IOException {
            this.graphics = graphics;
        }

        public void stripPage(PDDocument document, PDPage page, int pageIndex, float scale) throws IOException {
            PDRectangle cropBox = page.getCropBox();
            this.flip = new AffineTransform();
            this.flip.translate(0.0, cropBox.getHeight());
            this.flip.scale(1.0, -1.0);
            this.transform(this.graphics, page, scale);
            this.graphics.setStroke(new BasicStroke(0.5f));
            this.setStartPage(pageIndex + 1);
            this.setEndPage(pageIndex + 1);
            OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
            this.writeText(document, dummy);
            if (DebugTextOverlay.this.showTextStripperBeads) {
                List<PDThreadBead> pageArticles = page.getThreadBeads();
                for (PDThreadBead bead : pageArticles) {
                    PDRectangle r = bead.getRectangle();
                    GeneralPath p = r.transform(Matrix.getTranslateInstance(-cropBox.getLowerLeftX(), cropBox.getLowerLeftY()));
                    Shape s = this.flip.createTransformedShape(p);
                    this.graphics.setColor(Color.green);
                    this.graphics.draw(s);
                }
            }
        }

        private void transform(Graphics2D graphics, PDPage page, float scale) {
            graphics.scale(scale, scale);
            int rotationAngle = page.getRotation();
            PDRectangle cropBox = page.getCropBox();
            if (rotationAngle != 0) {
                float translateX = 0.0f;
                float translateY = 0.0f;
                switch (rotationAngle) {
                    case 90: {
                        translateX = cropBox.getHeight();
                        break;
                    }
                    case 270: {
                        translateY = cropBox.getWidth();
                        break;
                    }
                    case 180: {
                        translateX = cropBox.getWidth();
                        translateY = cropBox.getHeight();
                    }
                }
                graphics.translate(translateX, translateY);
                graphics.rotate((float)Math.toRadians(rotationAngle));
            }
        }

        @Override
        protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
            for (TextPosition text : textPositions) {
                if (DebugTextOverlay.this.showTextStripper) {
                    AffineTransform at = (AffineTransform)this.flip.clone();
                    at.concatenate(text.getTextMatrix().createAffineTransform());
                    Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, text.getWidthDirAdj() / text.getTextMatrix().getScalingFactorX(), text.getHeightDir() / text.getTextMatrix().getScalingFactorY());
                    this.graphics.setColor(Color.red);
                    this.graphics.draw(at.createTransformedShape(rect));
                }
                if (!DebugTextOverlay.this.showFontBBox) continue;
                PDFont font = text.getFont();
                BoundingBox bbox = font.getBoundingBox();
                float xadvance = font.getWidth(text.getCharacterCodes()[0]);
                Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, bbox.getLowerLeftY(), xadvance, bbox.getHeight());
                AffineTransform at = (AffineTransform)this.flip.clone();
                at.concatenate(text.getTextMatrix().createAffineTransform());
                if (font instanceof PDType3Font) {
                    at.concatenate(font.getFontMatrix().createAffineTransform());
                } else {
                    at.scale(0.001f, 0.001f);
                }
                this.graphics.setColor(Color.blue);
                this.graphics.draw(at.createTransformedShape(rect));
            }
        }
    }
}

