/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.pagepane;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

final class DebugPageDrawer
extends PageDrawer {
    private final boolean showGlyphBounds;

    DebugPageDrawer(PageDrawerParameters parameters, boolean showGlyphBounds) throws IOException {
        super(parameters);
        this.showGlyphBounds = showGlyphBounds;
    }

    @Override
    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        super.showGlyph(textRenderingMatrix, font, code, unicode, displacement);
        if (this.showGlyphBounds) {
            float fontWidth;
            if (font instanceof PDType3Font) {
                return;
            }
            AffineTransform at = textRenderingMatrix.createAffineTransform();
            at.concatenate(font.getFontMatrix().createAffineTransform());
            PDVectorFont vectorFont = (PDVectorFont)((Object)font);
            GeneralPath path = vectorFont.getNormalizedPath(code);
            if (path == null) {
                return;
            }
            if (!font.isEmbedded() && (fontWidth = font.getWidthFromFont(code)) > 0.0f && (double)Math.abs(fontWidth - displacement.getX() * 1000.0f) > 1.0E-4) {
                float pdfWidth = displacement.getX() * 1000.0f;
                at.scale(pdfWidth / fontWidth, 1.0);
            }
            Shape glyph = at.createTransformedShape(path);
            Rectangle2D bbox = glyph.getBounds2D();
            Graphics2D graphics = this.getGraphics();
            Color color = graphics.getColor();
            Stroke stroke = graphics.getStroke();
            Shape clip = graphics.getClip();
            graphics.setClip(graphics.getDeviceConfiguration().getBounds());
            graphics.setColor(Color.cyan);
            graphics.setStroke(new BasicStroke(0.5f));
            graphics.draw(bbox);
            graphics.setStroke(stroke);
            graphics.setColor(color);
            graphics.setClip(clip);
        }
    }
}

