/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Stack;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Charsets;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.NumberFormatUtil;

public abstract class PDAbstractContentStream
implements Closeable {
    private OutputStream output;
    private PDResources resources;
    private boolean inTextMode = false;
    private final Stack<PDFont> fontStack = new Stack();
    private final Stack<PDColorSpace> nonStrokingColorSpaceStack = new Stack();
    private final Stack<PDColorSpace> strokingColorSpaceStack = new Stack();
    private final NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private final byte[] formatBuffer = new byte[32];

    public PDAbstractContentStream() throws IOException {
        this.formatDecimal.setMaximumFractionDigits(4);
        this.formatDecimal.setGroupingUsed(false);
    }

    public PDAbstractContentStream(PDAppearanceStream appearance) throws IOException {
        this(appearance, appearance.getStream().createOutputStream());
    }

    public PDAbstractContentStream(PDAppearanceStream appearance, OutputStream outputStream) throws IOException {
        this.output = outputStream;
        this.resources = appearance.getResources();
        this.formatDecimal.setMaximumFractionDigits(4);
        this.formatDecimal.setGroupingUsed(false);
    }

    protected void setMaximumFractionDigits(int fractionDigitsNumber) {
        this.formatDecimal.setMaximumFractionDigits(fractionDigitsNumber);
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setOutput(OutputStream outputStream) {
        this.output = outputStream;
    }

    public PDResources getResources() {
        return this.resources;
    }

    public void setResources(PDResources resources) {
        this.resources = resources;
    }

    public Stack<PDColorSpace> getStrokingColorSpaceStack() {
        return this.strokingColorSpaceStack;
    }

    public Stack<PDColorSpace> getNonStrokingColorSpaceStack() {
        return this.nonStrokingColorSpaceStack;
    }

    public boolean isInTextMode() {
        return this.inTextMode;
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: Nested beginText() calls are not allowed.");
        }
        this.writeOperator("BT");
        this.inTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Error: You must call beginText() before calling endText.");
        }
        this.writeOperator("ET");
        this.inTextMode = false;
    }

    public void setFont(PDFont font, float fontSize) throws IOException {
        if (this.fontStack.isEmpty()) {
            this.fontStack.add(font);
        } else {
            this.fontStack.setElementAt(font, this.fontStack.size() - 1);
        }
        this.writeOperand(this.resources.add(font));
        this.writeOperand(fontSize);
        this.writeOperator("Tf");
    }

    public void showText(String text) throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Must call beginText() before showText()");
        }
        if (this.fontStack.isEmpty()) {
            throw new IllegalStateException("Must call setFont() before showText()");
        }
        PDFont font = this.fontStack.peek();
        if (font.willBeSubset()) {
            int codePoint;
            for (int offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                font.addToSubset(codePoint);
            }
        }
        COSWriter.writeString(font.encode(text), this.output);
        this.write(" ");
        this.writeOperator("Tj");
    }

    public void setLeading(double leading) throws IOException {
        this.writeOperand((float)leading);
        this.writeOperator("TL");
    }

    public void newLine() throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Must call beginText() before newLine()");
        }
        this.writeOperator("T*");
    }

    public void newLineAtOffset(float tx, float ty) throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Error: must call beginText() before newLineAtOffset()");
        }
        this.writeOperand(tx);
        this.writeOperand(ty);
        this.writeOperator("Td");
    }

    public void setTextMatrix(Matrix matrix) throws IOException {
        if (!this.inTextMode) {
            throw new IllegalStateException("Error: must call beginText() before setTextMatrix");
        }
        this.writeAffineTransform(matrix.createAffineTransform());
        this.writeOperator("Tm");
    }

    public void drawImage(PDImageXObject image, float x, float y) throws IOException {
        this.drawImage(image, x, y, (float)image.getWidth(), (float)image.getHeight());
    }

    public void drawImage(PDImageXObject image, float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        AffineTransform transform = new AffineTransform(width, 0.0f, 0.0f, height, x, y);
        this.transform(new Matrix(transform));
        this.writeOperand(this.resources.add(image));
        this.writeOperator("Do");
        this.restoreGraphicsState();
    }

    public void drawImage(PDImageXObject image, Matrix matrix) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        AffineTransform transform = matrix.createAffineTransform();
        this.transform(new Matrix(transform));
        this.writeOperand(this.resources.add(image));
        this.writeOperator("Do");
        this.restoreGraphicsState();
    }

    public void drawImage(PDInlineImage inlineImage, float x, float y) throws IOException {
        this.drawImage(inlineImage, x, y, (float)inlineImage.getWidth(), (float)inlineImage.getHeight());
    }

    public void drawImage(PDInlineImage inlineImage, float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        this.transform(new Matrix(width, 0.0f, 0.0f, height, x, y));
        StringBuilder sb = new StringBuilder();
        sb.append("BI");
        sb.append("\n /W ");
        sb.append(inlineImage.getWidth());
        sb.append("\n /H ");
        sb.append(inlineImage.getHeight());
        sb.append("\n /CS ");
        sb.append("/");
        sb.append(inlineImage.getColorSpace().getName());
        if (inlineImage.getDecode() != null && inlineImage.getDecode().size() > 0) {
            sb.append("\n /D ");
            sb.append("[");
            for (COSBase base : inlineImage.getDecode()) {
                sb.append(((COSNumber)base).intValue());
                sb.append(" ");
            }
            sb.append("]");
        }
        if (inlineImage.isStencil()) {
            sb.append("\n /IM true");
        }
        sb.append("\n /BPC ");
        sb.append(inlineImage.getBitsPerComponent());
        this.write(sb.toString());
        this.writeLine();
        this.writeOperator("ID");
        this.writeBytes(inlineImage.getData());
        this.writeLine();
        this.writeOperator("EI");
        this.restoreGraphicsState();
    }

    public void drawForm(PDFormXObject form) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: drawForm is not allowed within a text block.");
        }
        this.writeOperand(this.resources.add(form));
        this.writeOperator("Do");
    }

    public void transform(Matrix matrix) throws IOException {
        this.writeAffineTransform(matrix.createAffineTransform());
        this.writeOperator("cm");
    }

    public void saveGraphicsState() throws IOException {
        if (!this.fontStack.isEmpty()) {
            this.fontStack.push(this.fontStack.peek());
        }
        if (!this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.push(this.strokingColorSpaceStack.peek());
        }
        if (!this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.push(this.nonStrokingColorSpaceStack.peek());
        }
        this.writeOperator("q");
    }

    public void restoreGraphicsState() throws IOException {
        if (!this.fontStack.isEmpty()) {
            this.fontStack.pop();
        }
        if (!this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.pop();
        }
        if (!this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.pop();
        }
        this.writeOperator("Q");
    }

    protected COSName getName(PDColorSpace colorSpace) throws IOException {
        if (colorSpace instanceof PDDeviceGray || colorSpace instanceof PDDeviceRGB || colorSpace instanceof PDDeviceCMYK) {
            return COSName.getPDFName(colorSpace.getName());
        }
        return this.resources.add(colorSpace);
    }

    public void setStrokingColor(PDColor color) throws IOException {
        if (this.strokingColorSpaceStack.isEmpty() || this.strokingColorSpaceStack.peek() != color.getColorSpace()) {
            this.writeOperand(this.getName(color.getColorSpace()));
            this.writeOperator("CS");
            this.setStrokingColorSpaceStack(color.getColorSpace());
        }
        for (float value : color.getComponents()) {
            this.writeOperand(value);
        }
        if (color.getColorSpace() instanceof PDPattern) {
            this.writeOperand(color.getPatternName());
        }
        if (color.getColorSpace() instanceof PDPattern || color.getColorSpace() instanceof PDSeparation || color.getColorSpace() instanceof PDDeviceN || color.getColorSpace() instanceof PDICCBased) {
            this.writeOperator("SCN");
        } else {
            this.writeOperator("SC");
        }
    }

    public void setStrokingColor(Color color) throws IOException {
        float[] components = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        PDColor pdColor = new PDColor(components, (PDColorSpace)PDDeviceRGB.INSTANCE);
        this.setStrokingColor(pdColor);
    }

    public void setStrokingColor(int r, int g, int b) throws IOException {
        if (this.isOutside255Interval(r) || this.isOutside255Interval(g) || this.isOutside255Interval(b)) {
            throw new IllegalArgumentException("Parameters must be within 0..255, but are " + String.format("(%d,%d,%d)", r, g, b));
        }
        this.writeOperand((float)r / 255.0f);
        this.writeOperand((float)g / 255.0f);
        this.writeOperand((float)b / 255.0f);
        this.writeOperator("RG");
        this.setStrokingColorSpaceStack(PDDeviceRGB.INSTANCE);
    }

    public void setStrokingColor(float c, float m, float y, float k) throws IOException {
        if (this.isOutsideOneInterval(c) || this.isOutsideOneInterval(m) || this.isOutsideOneInterval(y) || this.isOutsideOneInterval(k)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are " + String.format("(%.2f,%.2f,%.2f,%.2f)", Float.valueOf(c), Float.valueOf(m), Float.valueOf(y), Float.valueOf(k)));
        }
        this.writeOperand(c);
        this.writeOperand(m);
        this.writeOperand(y);
        this.writeOperand(k);
        this.writeOperator("K");
        this.setStrokingColorSpaceStack(PDDeviceCMYK.INSTANCE);
    }

    public void setStrokingColor(double g) throws IOException {
        if (this.isOutsideOneInterval(g)) {
            throw new IllegalArgumentException("Parameter must be within 0..1, but is " + g);
        }
        this.writeOperand((float)g);
        this.writeOperator("G");
        this.setStrokingColorSpaceStack(PDDeviceGray.INSTANCE);
    }

    public void setNonStrokingColor(PDColor color) throws IOException {
        if (this.nonStrokingColorSpaceStack.isEmpty() || this.nonStrokingColorSpaceStack.peek() != color.getColorSpace()) {
            this.writeOperand(this.getName(color.getColorSpace()));
            this.writeOperator("cs");
            this.setNonStrokingColorSpaceStack(color.getColorSpace());
        }
        for (float value : color.getComponents()) {
            this.writeOperand(value);
        }
        if (color.getColorSpace() instanceof PDPattern) {
            this.writeOperand(color.getPatternName());
        }
        if (color.getColorSpace() instanceof PDPattern || color.getColorSpace() instanceof PDSeparation || color.getColorSpace() instanceof PDDeviceN || color.getColorSpace() instanceof PDICCBased) {
            this.writeOperator("scn");
        } else {
            this.writeOperator("sc");
        }
    }

    public void setNonStrokingColor(Color color) throws IOException {
        float[] components = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        PDColor pdColor = new PDColor(components, (PDColorSpace)PDDeviceRGB.INSTANCE);
        this.setNonStrokingColor(pdColor);
    }

    public void setNonStrokingColor(int r, int g, int b) throws IOException {
        if (this.isOutside255Interval(r) || this.isOutside255Interval(g) || this.isOutside255Interval(b)) {
            throw new IllegalArgumentException("Parameters must be within 0..255, but are " + String.format("(%d,%d,%d)", r, g, b));
        }
        this.writeOperand((float)r / 255.0f);
        this.writeOperand((float)g / 255.0f);
        this.writeOperand((float)b / 255.0f);
        this.writeOperator("rg");
        this.setNonStrokingColorSpaceStack(PDDeviceRGB.INSTANCE);
    }

    public void setNonStrokingColor(int c, int m, int y, int k) throws IOException {
        if (this.isOutside255Interval(c) || this.isOutside255Interval(m) || this.isOutside255Interval(y) || this.isOutside255Interval(k)) {
            throw new IllegalArgumentException("Parameters must be within 0..255, but are " + String.format("(%d,%d,%d,%d)", c, m, y, k));
        }
        this.setNonStrokingColor((float)c / 255.0f, (float)m / 255.0f, (float)y / 255.0f, (float)k / 255.0f);
    }

    public void setNonStrokingColor(double c, double m, double y, double k) throws IOException {
        if (this.isOutsideOneInterval(c) || this.isOutsideOneInterval(m) || this.isOutsideOneInterval(y) || this.isOutsideOneInterval(k)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are " + String.format("(%.2f,%.2f,%.2f,%.2f)", c, m, y, k));
        }
        this.writeOperand((float)c);
        this.writeOperand((float)m);
        this.writeOperand((float)y);
        this.writeOperand((float)k);
        this.writeOperator("k");
        this.setNonStrokingColorSpaceStack(PDDeviceCMYK.INSTANCE);
    }

    public void setNonStrokingColor(int g) throws IOException {
        if (this.isOutside255Interval(g)) {
            throw new IllegalArgumentException("Parameter must be within 0..255, but is " + g);
        }
        this.setNonStrokingColor((float)g / 255.0f);
    }

    public void setNonStrokingColor(double g) throws IOException {
        if (this.isOutsideOneInterval(g)) {
            throw new IllegalArgumentException("Parameter must be within 0..1, but is " + g);
        }
        this.writeOperand((float)g);
        this.writeOperator("g");
        this.setNonStrokingColorSpaceStack(PDDeviceGray.INSTANCE);
    }

    public void addRect(float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: addRect is not allowed within a text block.");
        }
        this.writeOperand(x);
        this.writeOperand(y);
        this.writeOperand(width);
        this.writeOperand(height);
        this.writeOperator("re");
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: curveTo is not allowed within a text block.");
        }
        this.writeOperand(x1);
        this.writeOperand(y1);
        this.writeOperand(x2);
        this.writeOperand(y2);
        this.writeOperand(x3);
        this.writeOperand(y3);
        this.writeOperator("c");
    }

    public void curveTo2(float x2, float y2, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: curveTo2 is not allowed within a text block.");
        }
        this.writeOperand(x2);
        this.writeOperand(y2);
        this.writeOperand(x3);
        this.writeOperand(y3);
        this.writeOperator("v");
    }

    public void curveTo1(float x1, float y1, float x3, float y3) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: curveTo1 is not allowed within a text block.");
        }
        this.writeOperand(x1);
        this.writeOperand(y1);
        this.writeOperand(x3);
        this.writeOperand(y3);
        this.writeOperator("y");
    }

    public void moveTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: moveTo is not allowed within a text block.");
        }
        this.writeOperand(x);
        this.writeOperand(y);
        this.writeOperator("m");
    }

    public void lineTo(float x, float y) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: lineTo is not allowed within a text block.");
        }
        this.writeOperand(x);
        this.writeOperand(y);
        this.writeOperator("l");
    }

    public void stroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: stroke is not allowed within a text block.");
        }
        this.writeOperator("S");
    }

    public void closeAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closeAndStroke is not allowed within a text block.");
        }
        this.writeOperator("s");
    }

    public void fill() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fill is not allowed within a text block.");
        }
        this.writeOperator("f");
    }

    public void fillEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fillEvenOdd is not allowed within a text block.");
        }
        this.writeOperator("f*");
    }

    public void fillAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fillAndStroke is not allowed within a text block.");
        }
        this.writeOperator("B");
    }

    public void fillAndStrokeEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: fillAndStrokeEvenOdd is not allowed within a text block.");
        }
        this.writeOperator("B*");
    }

    public void closeAndFillAndStroke() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closeAndFillAndStroke is not allowed within a text block.");
        }
        this.writeOperator("b");
    }

    public void closeAndFillAndStrokeEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closeAndFillAndStrokeEvenOdd is not allowed within a text block.");
        }
        this.writeOperator("b*");
    }

    public void shadingFill(PDShading shading) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: shadingFill is not allowed within a text block.");
        }
        this.writeOperand(this.resources.add(shading));
        this.writeOperator("sh");
    }

    public void closePath() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: closePath is not allowed within a text block.");
        }
        this.writeOperator("h");
    }

    public void clip() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: clip is not allowed within a text block.");
        }
        this.writeOperator("W");
        this.writeOperator("n");
    }

    public void clipEvenOdd() throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: clipEvenOdd is not allowed within a text block.");
        }
        this.writeOperator("W*");
        this.writeOperator("n");
    }

    public void setLineWidth(float lineWidth) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: setLineWidth is not allowed within a text block.");
        }
        this.writeOperand(lineWidth);
        this.writeOperator("w");
    }

    public void setLineJoinStyle(int lineJoinStyle) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: setLineJoinStyle is not allowed within a text block.");
        }
        if (lineJoinStyle < 0 || lineJoinStyle > 2) {
            throw new IllegalArgumentException("Error: unknown value for line join style");
        }
        this.writeOperand(lineJoinStyle);
        this.writeOperator("j");
    }

    public void setLineCapStyle(int lineCapStyle) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: setLineCapStyle is not allowed within a text block.");
        }
        if (lineCapStyle < 0 || lineCapStyle > 2) {
            throw new IllegalArgumentException("Error: unknown value for line cap style");
        }
        this.writeOperand(lineCapStyle);
        this.writeOperator("J");
    }

    public void setLineDashPattern(float[] pattern, float phase) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: setLineDashPattern is not allowed within a text block.");
        }
        this.write("[");
        for (float value : pattern) {
            this.writeOperand(value);
        }
        this.write("] ");
        this.writeOperand(phase);
        this.writeOperator("d");
    }

    public void setMiterLimit(float miterLimit) throws IOException {
        if (this.inTextMode) {
            throw new IllegalStateException("Error: setMiterLimit is not allowed within a text block.");
        }
        this.writeOperand(miterLimit);
        this.writeOperator("M");
    }

    public void beginMarkedContent(COSName tag) throws IOException {
        this.writeOperand(tag);
        this.writeOperator("BMC");
    }

    public void beginMarkedContent(COSName tag, PDPropertyList propertyList) throws IOException {
        this.writeOperand(tag);
        this.writeOperand(this.resources.add(propertyList));
        this.writeOperator("BDC");
    }

    public void endMarkedContent() throws IOException {
        this.writeOperator("EMC");
    }

    public void setGraphicsStateParameters(PDExtendedGraphicsState state) throws IOException {
        this.writeOperand(this.resources.add(state));
        this.writeOperator("gs");
    }

    public void addComment(String comment) throws IOException {
        if (comment.indexOf(10) >= 0 || comment.indexOf(13) >= 0) {
            throw new IllegalArgumentException("comment should not include a newline");
        }
        this.output.write(37);
        this.output.write(comment.getBytes(Charsets.US_ASCII));
        this.output.write(10);
    }

    protected void writeOperand(double data) throws IOException {
        this.write(this.formatDecimal.format(data));
        this.output.write(32);
    }

    protected void writeOperand(float real) throws IOException {
        int byteCount = NumberFormatUtil.formatFloatFast(real, this.formatDecimal.getMaximumFractionDigits(), this.formatBuffer);
        if (byteCount == -1) {
            this.write(this.formatDecimal.format(real));
        } else {
            this.output.write(this.formatBuffer, 0, byteCount);
        }
        this.output.write(32);
    }

    protected void writeOperand(int integer) throws IOException {
        this.write(this.formatDecimal.format(integer));
        this.output.write(32);
    }

    protected void writeOperand(COSName name) throws IOException {
        name.writePDF(this.output);
        this.output.write(32);
    }

    protected void writeOperator(String text) throws IOException {
        this.output.write(text.getBytes(Charsets.US_ASCII));
        this.output.write(10);
    }

    protected void write(String text) throws IOException {
        this.output.write(text.getBytes(Charsets.US_ASCII));
    }

    protected void write(byte[] data) throws IOException {
        this.output.write(data);
    }

    protected void writeLine() throws IOException {
        this.output.write(10);
    }

    protected void writeBytes(byte[] data) throws IOException {
        this.output.write(data);
    }

    private void writeAffineTransform(AffineTransform transform) throws IOException {
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            this.writeOperand((float)v);
        }
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    protected boolean isOutside255Interval(int val) {
        return val < 0 || val > 255;
    }

    private boolean isOutsideOneInterval(double val) {
        return val < 0.0 || val > 1.0;
    }

    protected void setStrokingColorSpaceStack(PDColorSpace colorSpace) {
        if (this.strokingColorSpaceStack.isEmpty()) {
            this.strokingColorSpaceStack.add(colorSpace);
        } else {
            this.strokingColorSpaceStack.setElementAt(colorSpace, this.strokingColorSpaceStack.size() - 1);
        }
    }

    protected void setNonStrokingColorSpaceStack(PDColorSpace colorSpace) {
        if (this.nonStrokingColorSpaceStack.isEmpty()) {
            this.nonStrokingColorSpaceStack.add(colorSpace);
        } else {
            this.nonStrokingColorSpaceStack.setElementAt(colorSpace, this.nonStrokingColorSpaceStack.size() - 1);
        }
    }

    public void setCharacterSpacing(float spacing) throws IOException {
        this.writeOperand(spacing);
        this.writeOperator("Tc");
    }

    public void setWordSpacing(float spacing) throws IOException {
        this.writeOperand(spacing);
        this.writeOperator("Tw");
    }

    public static enum AppendMode {
        OVERWRITE,
        APPEND,
        PREPEND;


        public boolean isOverwrite() {
            return this == OVERWRITE;
        }

        public boolean isPrepend() {
            return this == PREPEND;
        }
    }
}

