/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.ui.textsearcher;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

class SearchEngine {
    private final Document document;
    private final Highlighter highlighter;
    private final Highlighter.HighlightPainter painter;

    SearchEngine(JTextComponent textComponent, Highlighter.HighlightPainter painter) {
        this.document = textComponent.getDocument();
        this.highlighter = textComponent.getHighlighter();
        this.painter = painter;
    }

    public List<Highlighter.Highlight> search(String searchKey, boolean isCaseSensitive) {
        ArrayList<Highlighter.Highlight> highlights = new ArrayList<Highlighter.Highlight>();
        if (searchKey != null) {
            int resultantOffset;
            String textContent;
            this.highlighter.removeAllHighlights();
            if ("".equals(searchKey)) {
                return highlights;
            }
            try {
                textContent = this.document.getText(0, this.document.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return highlights;
            }
            if (!isCaseSensitive) {
                textContent = textContent.toLowerCase();
                searchKey = searchKey.toLowerCase();
            }
            int searchKeyLength = searchKey.length();
            int startAt = 0;
            int indexOfHighLight = 0;
            while ((resultantOffset = textContent.indexOf(searchKey, startAt)) != -1) {
                try {
                    this.highlighter.addHighlight(resultantOffset, resultantOffset + searchKeyLength, this.painter);
                    highlights.add(this.highlighter.getHighlights()[indexOfHighLight++]);
                    startAt = resultantOffset + searchKeyLength;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        return highlights;
    }
}

