/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.FontToolTip;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.GToolTip;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.KToolTip;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.RGToolTip;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.SCNToolTip;

public class ToolTipController {
    private static final String FONT_OPERATOR = "Tf";
    private static final String STROKING_COLOR = "SCN";
    private static final String STROKING_COLOR_SPACE = "CS";
    private static final String NON_STROKING_COLOR_SPACE = "cs";
    private static final String NON_STROKING_COLOR = "scn";
    private static final String RGB_STROKING_COLOR = "RG";
    private static final String RGB_NON_STROKING_COLOR = "rg";
    private static final String CMYK_STROKING_COLOR = "K";
    private static final String CMYK_NON_STROKING_COLOR = "k";
    private static final String GRAY_STROKING_COLOR = "G";
    private static final String GRAY_NON_STROKING_COLOR = "g";
    private final PDResources resources;
    private JTextComponent textComponent;

    public ToolTipController(PDResources resources) {
        this.resources = resources;
    }

    static List<String> getWords(String str) {
        ArrayList<String> words = new ArrayList<String>();
        for (String string : str.trim().split(" ")) {
            if ((string = string.trim()).isEmpty() || string.equals("\n")) continue;
            words.add(string);
        }
        return words;
    }

    public String getToolTip(int offset, JTextComponent textComponent) {
        this.textComponent = textComponent;
        String word = this.getWord(offset);
        String rowText = this.getRowText(offset);
        if (word != null) {
            if (word.equals(FONT_OPERATOR)) {
                FontToolTip toolTip = new FontToolTip(this.resources, rowText);
                return toolTip.getToolTipText();
            }
            if (word.equals(STROKING_COLOR)) {
                String colorSpaceName = this.findColorSpace(offset, STROKING_COLOR_SPACE);
                if (colorSpaceName != null) {
                    SCNToolTip toolTip = new SCNToolTip(this.resources, colorSpaceName, rowText);
                    return toolTip.getToolTipText();
                }
            } else if (word.equals(NON_STROKING_COLOR)) {
                String colorSpaceName = this.findColorSpace(offset, NON_STROKING_COLOR_SPACE);
                if (colorSpaceName != null) {
                    SCNToolTip toolTip = new SCNToolTip(this.resources, colorSpaceName, rowText);
                    return toolTip.getToolTipText();
                }
            } else {
                if (word.equals(RGB_STROKING_COLOR) || word.equals(RGB_NON_STROKING_COLOR)) {
                    RGToolTip toolTip = new RGToolTip(rowText);
                    return toolTip.getToolTipText();
                }
                if (word.equals(CMYK_STROKING_COLOR) || word.equals(CMYK_NON_STROKING_COLOR)) {
                    KToolTip toolTip = new KToolTip(rowText);
                    return toolTip.getToolTipText();
                }
                if (word.equals(GRAY_STROKING_COLOR) || word.equals(GRAY_NON_STROKING_COLOR)) {
                    GToolTip toolTip = new GToolTip(rowText);
                    return toolTip.getToolTipText();
                }
            }
        }
        return null;
    }

    private String findColorSpace(int offset, String colorSpaceType) {
        try {
            while (offset != -1) {
                String previousRowText = this.getRowText(offset = Utilities.getPositionAbove(this.textComponent, offset, 0));
                if (previousRowText == null) {
                    return null;
                }
                if (!this.isColorSpace(colorSpaceType, previousRowText = previousRowText.trim())) continue;
                return previousRowText.split(" ")[0];
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private boolean isColorSpace(String colorSpaceType, String rowText) {
        List<String> words = ToolTipController.getWords(rowText);
        return words.size() == 2 && words.get(1).equals(colorSpaceType);
    }

    private String getWord(int offset) {
        try {
            int start = Utilities.getWordStart(this.textComponent, offset);
            int end = Utilities.getWordEnd(this.textComponent, offset);
            return this.textComponent.getDocument().getText(start, end - start + 1).trim();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getRowText(int offset) {
        try {
            int rowStart = Utilities.getRowStart(this.textComponent, offset);
            int rowEnd = Utilities.getRowEnd(this.textComponent, offset);
            return this.textComponent.getDocument().getText(rowStart, rowEnd - rowStart + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

