/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.ToolTip;
import org.apache.pdfbox.tools.pdfdebugger.streampane.tooltip.ToolTipController;

abstract class ColorToolTip
implements ToolTip {
    private String toolTipText;

    ColorToolTip() {
    }

    static String colorHexValue(Color color) {
        return String.format("%02x", color.getRed()) + String.format("%02x", color.getGreen()) + String.format("%02x", color.getBlue());
    }

    float[] extractColorValues(String rowtext) {
        List<String> words = ToolTipController.getWords(rowtext);
        words.remove(words.size() - 1);
        float[] values = new float[words.size()];
        int index = 0;
        try {
            for (String word : words) {
                values[index++] = Float.parseFloat(word);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return values;
    }

    String getMarkUp(String hexValue) {
        return "<html>\n<body bgcolor=#ffffff>\n<div style=\"width:50px;height:20px;border:1px; background-color:#" + hexValue + ";\"></div></body>\n" + "</html>";
    }

    public void setToolTipText(String toolTip) {
        this.toolTipText = toolTip;
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }
}

