/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.pagepane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.pdfdebugger.ui.RotationMenu;
import org.apache.pdfbox.tools.pdfdebugger.ui.ZoomMenu;
import org.apache.pdfbox.tools.util.ImageUtil;

public class PagePane
implements ActionListener,
AncestorListener {
    private JPanel panel;
    private int pageIndex = -1;
    private final PDDocument document;
    private JLabel label;
    private ZoomMenu zoomMenu;
    private RotationMenu rotationMenu;

    public PagePane(PDDocument document, COSDictionary page) {
        PDPage pdPage = new PDPage(page);
        this.pageIndex = document.getPages().indexOf(pdPage);
        this.document = document;
        this.initUI();
    }

    private void initUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        String pageLabelText = this.pageIndex < 0 ? "Page number not found" : "Page " + (this.pageIndex + 1);
        JLabel pageLabel = new JLabel(pageLabelText);
        pageLabel.setAlignmentX(0.5f);
        pageLabel.setFont(new Font("Monospaced", 1, 30));
        pageLabel.setBackground(Color.GREEN);
        this.panel.add(pageLabel);
        this.label = new JLabel();
        this.label.setBackground(this.panel.getBackground());
        this.label.setAlignmentX(0.5f);
        this.panel.add(this.label);
        this.panel.addAncestorListener(this);
        new RenderWorker(1.0f, 0).execute();
    }

    public Component getPanel() {
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (ZoomMenu.isZoomMenu(actionCommand) || RotationMenu.isRotationMenu(actionCommand)) {
            new RenderWorker(ZoomMenu.getZoomScale(), RotationMenu.getRotationDegrees()).execute();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.zoomMenu = ZoomMenu.getInstance();
        this.zoomMenu.addMenuListeners(this);
        this.zoomMenu.setZoomSelection("100%");
        this.zoomMenu.setEnableMenu(true);
        this.rotationMenu = RotationMenu.getInstance();
        this.rotationMenu.addMenuListeners(this);
        this.rotationMenu.setRotationSelection("0\u00b0");
        this.rotationMenu.setEnableMenu(true);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.zoomMenu.setEnableMenu(false);
        this.rotationMenu.setEnableMenu(false);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private final class RenderWorker
    extends SwingWorker<BufferedImage, Integer> {
        private final float scale;
        private final int rotation;

        private RenderWorker(float scale, int rotation) {
            this.scale = scale;
            this.rotation = rotation;
        }

        @Override
        protected BufferedImage doInBackground() throws IOException {
            PagePane.this.label.setIcon(null);
            PagePane.this.label.setText("Loading...");
            PDFRenderer renderer = new PDFRenderer(PagePane.this.document);
            BufferedImage bim = renderer.renderImage(PagePane.this.pageIndex, this.scale);
            return ImageUtil.getRotatedImage(bim, this.rotation);
        }

        @Override
        protected void done() {
            try {
                PagePane.this.label.setIcon(new ImageIcon((Image)this.get()));
                PagePane.this.label.setText(null);
            }
            catch (InterruptedException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

