/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.fontencodingpane;

import java.awt.Dimension;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.tools.pdfdebugger.fontencodingpane.FontEncodingView;
import org.apache.pdfbox.tools.pdfdebugger.fontencodingpane.FontPane;

class Type0Font
implements FontPane {
    private FontEncodingView view;

    Type0Font(PDCIDFontType2 descendantFont, PDFont parentFont) throws IOException {
        Object[][] cidtogid = this.readCIDToGIDMap(descendantFont, parentFont);
        if (cidtogid != null) {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("Font", descendantFont.getName());
            attributes.put("CID count", Integer.toString(cidtogid.length));
            this.view = new FontEncodingView(cidtogid, attributes, new String[]{"CID", "GID", "Unicode Character"});
        }
    }

    private Object[][] readCIDToGIDMap(PDCIDFontType2 font, PDFont parentFont) throws IOException {
        Object[][] cid2gid = null;
        COSDictionary dict = font.getCOSObject();
        COSBase map = dict.getDictionaryObject(COSName.CID_TO_GID_MAP);
        if (map instanceof COSStream) {
            COSStream stream = (COSStream)map;
            COSInputStream is = stream.createInputStream();
            byte[] mapAsBytes = IOUtils.toByteArray(is);
            IOUtils.closeQuietly(is);
            int numberOfInts = mapAsBytes.length / 2;
            cid2gid = new Object[numberOfInts][3];
            int offset = 0;
            for (int index = 0; index < numberOfInts; ++index) {
                int gid = (mapAsBytes[offset] & 0xFF) << 8 | mapAsBytes[offset + 1] & 0xFF;
                cid2gid[index][0] = index;
                cid2gid[index][1] = gid;
                if (gid != 0 && parentFont.toUnicode(index) != null) {
                    cid2gid[index][2] = parentFont.toUnicode(index);
                }
                offset += 2;
            }
        }
        return cid2gid;
    }

    @Override
    public JPanel getPanel() {
        if (this.view != null) {
            return this.view.getPanel();
        }
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(300, 500));
        return panel;
    }
}

