/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.fontencodingpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class FontEncodingView {
    private JPanel panel;

    FontEncodingView(Object[][] tableData, Map<String, String> headerAttributes, String[] columnNames) {
        this.createView(this.getHeaderPanel(headerAttributes), this.getTable(tableData, columnNames));
    }

    private void createView(JPanel headerPanel, JTable table) {
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setPreferredSize(new Dimension(300, 500));
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        scrollPane.setAlignmentX(0.0f);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.05;
        gbc.fill = 2;
        gbc.anchor = 19;
        this.panel.add((Component)headerPanel, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.9;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 1792;
        this.panel.add((Component)scrollPane, gbc);
    }

    private JTable getTable(Object[][] tableData, String[] columnNames) {
        JTable table = new JTable(tableData, columnNames);
        table.setRowHeight(40);
        table.setDefaultRenderer(Object.class, new GlyphCellRenderer());
        return table;
    }

    private JPanel getHeaderPanel(Map<String, String> attributes) {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        if (attributes != null) {
            Iterator<String> keys = attributes.keySet().iterator();
            int row = 0;
            while (keys.hasNext()) {
                String key = keys.next();
                JLabel encodingNameLabel = new JLabel(key + ": " + attributes.get(key));
                encodingNameLabel.setFont(new Font("Monospaced", 1, 17));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = row++;
                gbc.weighty = 0.1;
                gbc.anchor = 21;
                headerPanel.add((Component)encodingNameLabel, gbc);
            }
        }
        return headerPanel;
    }

    JPanel getPanel() {
        return this.panel;
    }

    private static final class GlyphCellRenderer
    implements TableCellRenderer {
        private GlyphCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object o, boolean b, boolean b1, int i, int i1) {
            if (o != null) {
                JLabel label = new JLabel(o.toString());
                label.setHorizontalAlignment(0);
                label.setFont(new Font("SansSerif", 0, 25));
                if ("No glyph".equals(o) || ".notdef".equals(o)) {
                    label.setText(o.toString());
                    label.setForeground(Color.RED);
                }
                return label;
            }
            return new JLabel();
        }
    }
}

