/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.fontencodingpane;

import java.io.IOException;
import javax.swing.JPanel;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.tools.pdfdebugger.fontencodingpane.FontPane;
import org.apache.pdfbox.tools.pdfdebugger.fontencodingpane.SimpleFont;
import org.apache.pdfbox.tools.pdfdebugger.fontencodingpane.Type0Font;

public class FontEncodingPaneController {
    private FontPane fontPane;

    public FontEncodingPaneController(COSName fontName, COSDictionary dictionary) {
        PDResources resources = new PDResources(dictionary);
        try {
            PDFont font = resources.getFont(fontName);
            if (font instanceof PDSimpleFont) {
                this.fontPane = new SimpleFont((PDSimpleFont)font);
            } else if (font instanceof PDType0Font && ((PDType0Font)font).getDescendantFont() instanceof PDCIDFontType2) {
                this.fontPane = new Type0Font((PDCIDFontType2)((PDType0Font)font).getDescendantFont(), font);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JPanel getPane() {
        if (this.fontPane != null) {
            return this.fontPane.getPanel();
        }
        return null;
    }
}

