/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.flagbitspane;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class FlagBitsPaneView {
    private final JPanel panel;
    private final String flagHeader;
    private final String flagValue;
    private final Object[][] tableData;
    private final String[] columnNames;

    FlagBitsPaneView(String flagHeader, String flagValue, Object[][] tableRowData, String[] columnNames) {
        this.flagHeader = flagHeader;
        this.flagValue = flagValue;
        this.tableData = tableRowData;
        this.columnNames = columnNames;
        this.panel = new JPanel();
        if (flagValue != null && this.tableData != null) {
            this.createView();
        }
    }

    private void createView() {
        this.panel.setLayout(new GridBagLayout());
        this.panel.setPreferredSize(new Dimension(300, 500));
        JLabel flagLabel = new JLabel(this.flagHeader);
        flagLabel.setAlignmentX(0.5f);
        flagLabel.setFont(new Font("Monospaced", 1, 30));
        JPanel flagLabelPanel = new JPanel();
        flagLabelPanel.setAlignmentX(0.0f);
        flagLabelPanel.add(flagLabel);
        JLabel flagValueLabel = new JLabel(this.flagValue);
        flagValueLabel.setAlignmentX(0.0f);
        flagValueLabel.setFont(new Font("Monospaced", 1, 20));
        JTable table = new JTable(this.tableData, this.columnNames);
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        scrollPane.setAlignmentX(0.0f);
        Box box = Box.createVerticalBox();
        box.add(flagValueLabel);
        box.add(scrollPane);
        box.setAlignmentX(0.0f);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.05;
        gbc.fill = 2;
        gbc.anchor = 19;
        this.panel.add((Component)flagLabelPanel, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.9;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 1792;
        this.panel.add((Component)box, gbc);
    }

    JPanel getPanel() {
        return this.panel;
    }
}

