/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.gui;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.gui.PDFPagePanel;

public class PageWrapper
implements MouseMotionListener,
MouseListener {
    private final JPanel pageWrapper = new JPanel();
    private PDFPagePanel pagePanel = null;
    private final JLabel statusLabel;
    private static final int SPACE_AROUND_DOCUMENT = 20;

    public PageWrapper(JLabel statusLabel) throws IOException {
        this.statusLabel = statusLabel;
        this.pagePanel = new PDFPagePanel();
        this.pageWrapper.setLayout(null);
        this.pageWrapper.add(this.pagePanel);
        this.pagePanel.setLocation(20, 20);
        this.pageWrapper.setBorder(LineBorder.createBlackLineBorder());
        this.pagePanel.addMouseMotionListener(this);
        this.pagePanel.addMouseListener(this);
    }

    public void displayPage(PDFRenderer renderer, PDPage page, int pageNum) throws IOException {
        this.pagePanel.setPage(renderer, page, pageNum);
        this.pagePanel.setPreferredSize(this.pagePanel.getSize());
        Dimension d = this.pagePanel.getSize();
        d.width += 40;
        d.height += 40;
        this.pageWrapper.setPreferredSize(d);
        this.pageWrapper.validate();
    }

    public JPanel getPanel() {
        return this.pageWrapper;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.statusLabel.setText(e.getX() + "," + e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.statusLabel.setText("");
    }
}

