/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.encoding.DictionaryEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class PDType3Font
extends PDSimpleFont {
    private static final Log LOG = LogFactory.getLog(PDType3Font.class);
    private static final String D0_OPERATOR = "d0";
    private static final String D1_OPERATOR = "d1";
    private PDResources resources;
    private COSDictionary charProcs;
    private Matrix fontMatrix;

    public PDType3Font(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.readEncoding();
    }

    @Override
    public String getName() {
        return this.dict.getNameAsString(COSName.NAME);
    }

    @Override
    protected final void readEncoding() throws IOException {
        COSDictionary encodingDict = (COSDictionary)this.dict.getDictionaryObject(COSName.ENCODING);
        this.encoding = new DictionaryEncoding(encodingDict);
        this.glyphList = GlyphList.getZapfDingbats();
    }

    @Override
    protected Encoding readEncodingFromFont() throws IOException {
        throw new UnsupportedOperationException("not supported for Type 3 fonts");
    }

    @Override
    protected Boolean isFontSymbolic() {
        return false;
    }

    @Override
    public GeneralPath getPath(String name) throws IOException {
        throw new UnsupportedOperationException("not supported for Type 3 fonts");
    }

    @Override
    public boolean hasGlyph(String name) throws IOException {
        COSStream stream = (COSStream)this.getCharProcs().getDictionaryObject(COSName.getPDFName(name));
        return stream != null;
    }

    @Override
    public FontBoxFont getFontBoxFont() {
        throw new UnsupportedOperationException("not supported for Type 3 fonts");
    }

    @Override
    public Vector getDisplacement(int code) throws IOException {
        return this.getFontMatrix().transform(new Vector(this.getWidth(code), 0.0f));
    }

    @Override
    public float getWidth(int code) throws IOException {
        int firstChar = this.dict.getInt(COSName.FIRST_CHAR, -1);
        int lastChar = this.dict.getInt(COSName.LAST_CHAR, -1);
        if (this.getWidths().size() > 0 && code >= firstChar && code <= lastChar) {
            return this.getWidths().get(code - firstChar).floatValue();
        }
        PDFontDescriptor fd = this.getFontDescriptor();
        if (fd != null) {
            return fd.getMissingWidth();
        }
        LOG.error("No width for glyph " + code + " in font " + this.getName());
        return 0.0f;
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        try {
            PDType3CharProc charProc = this.getCharProc(code);
            if (charProc == null) {
                throw new IOException("No CharProc for glyph " + code + " found");
            }
            ArrayList<COSBase> arguments = new ArrayList<COSBase>();
            PDFStreamParser parser = new PDFStreamParser(charProc);
            Object token = parser.parseNextToken();
            while (token != null) {
                if (token instanceof COSObject) {
                    arguments.add(((COSObject)token).getObject());
                } else {
                    if (token instanceof Operator) {
                        return this.parseType3WidthOperator((Operator)token, arguments);
                    }
                    arguments.add((COSBase)token);
                }
                token = parser.parseNextToken();
            }
        }
        catch (IOException e) {
            LOG.error("Error processing CharProc for glyph " + code);
            LOG.error(e);
        }
        return -1.0f;
    }

    private float parseType3WidthOperator(Operator operator, List arguments) throws IOException {
        if (operator.getName().equals(D0_OPERATOR) || operator.getName().equals(D1_OPERATOR)) {
            Object obj = arguments.get(0);
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj instanceof COSNumber) {
                return ((COSNumber)obj).floatValue();
            }
            throw new IOException("Unexpected argument type. Expected : COSInteger or Number / Received : " + obj.getClass().getName());
        }
        throw new IOException("Type3 CharProc : First operator must be d0 or d1");
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public float getHeight(int code) throws IOException {
        PDFontDescriptor desc = this.getFontDescriptor();
        if (desc != null) {
            PDRectangle fontBBox = desc.getFontBoundingBox();
            float retval = 0.0f;
            if (fontBBox != null) {
                retval = fontBBox.getHeight() / 2.0f;
            }
            if (retval == 0.0f) {
                retval = desc.getCapHeight();
            }
            if (retval == 0.0f) {
                retval = desc.getAscent();
            }
            if (retval == 0.0f && (retval = desc.getXHeight()) > 0.0f) {
                retval -= desc.getDescent();
            }
            return retval;
        }
        return 0.0f;
    }

    @Override
    protected byte[] encode(int unicode) throws IOException {
        throw new UnsupportedOperationException("Not implemented: Type3");
    }

    @Override
    public int readCode(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            COSArray array = (COSArray)this.dict.getDictionaryObject(COSName.FONT_MATRIX);
            if (array != null) {
                this.fontMatrix = new Matrix(array);
            } else {
                return super.getFontMatrix();
            }
        }
        return this.fontMatrix;
    }

    @Override
    public boolean isDamaged() {
        return false;
    }

    public PDResources getResources() {
        COSDictionary resources;
        if (this.resources == null && (resources = (COSDictionary)this.dict.getDictionaryObject(COSName.RESOURCES)) != null) {
            this.resources = new PDResources(resources);
        }
        return this.resources;
    }

    public PDRectangle getFontBBox() {
        COSArray rect = (COSArray)this.dict.getDictionaryObject(COSName.FONT_BBOX);
        PDRectangle retval = null;
        if (rect != null) {
            retval = new PDRectangle(rect);
        }
        return retval;
    }

    @Override
    public BoundingBox getBoundingBox() {
        PDRectangle rect = this.getFontBBox();
        return new BoundingBox(rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getWidth(), rect.getHeight());
    }

    public COSDictionary getCharProcs() {
        if (this.charProcs == null) {
            this.charProcs = (COSDictionary)this.dict.getDictionaryObject(COSName.CHAR_PROCS);
        }
        return this.charProcs;
    }

    public PDType3CharProc getCharProc(int code) {
        String name = this.getEncoding().getName(code);
        if (!name.equals(".notdef")) {
            COSStream stream = (COSStream)this.getCharProcs().getDictionaryObject(COSName.getPDFName(name));
            if (stream == null) {
                return null;
            }
            return new PDType3CharProc(this, stream);
        }
        return null;
    }
}

