/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.NullOutputFormat;

public class TestTrackerBlacklistAcrossJobs
extends TestCase {
    private static final String[] hosts = new String[]{"host1.rack.com", "host2.rack.com", "host3.rack.com"};
    final Path inDir = new Path("/testing");
    final Path outDir = new Path("/output");

    public void testBlacklistAcrossJobs() throws IOException {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        Configuration conf = new Configuration();
        dfs = new MiniDFSCluster(conf, 1, true, null, hosts);
        fileSys = dfs.getFileSystem();
        if (!fileSys.mkdirs(this.inDir)) {
            throw new IOException("Mkdirs failed to create " + this.inDir.toString());
        }
        UtilsForTests.writeFile(dfs.getNameNode(), conf, new Path(this.inDir + "/file"), (short)1);
        JobConf jtConf = new JobConf();
        jtConf.setInt("mapred.max.tracker.blacklists", 1);
        mr = new MiniMRCluster(3, fileSys.getUri().toString(), 1, null, hosts, jtConf);
        JobConf mrConf = mr.createJobConf();
        JobConf job = new JobConf((Configuration)mrConf);
        job.setInt("mapred.max.tracker.failures", 1);
        job.setNumMapTasks(30);
        job.setNumReduceTasks(0);
        job.setMapperClass(SleepJobFailOnHost.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setOutputFormat(NullOutputFormat.class);
        job.setInputFormat(SleepJob.SleepInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{this.inDir});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)this.outDir);
        JobClient jc = new JobClient(mrConf);
        RunningJob running = JobClient.runJob((JobConf)job);
        TestTrackerBlacklistAcrossJobs.assertEquals((String)"Job failed", (int)2, (int)running.getJobState());
        TestTrackerBlacklistAcrossJobs.assertEquals((String)"Didn't blacklist the host", (int)1, (int)jc.getClusterStatus().getBlacklistedTrackers());
        TestTrackerBlacklistAcrossJobs.assertEquals((String)"Fault count should be 1", (int)1, (int)mr.getFaultCount(hosts[0]));
        running = JobClient.runJob((JobConf)job);
        TestTrackerBlacklistAcrossJobs.assertEquals((String)"Job failed", (int)2, (int)running.getJobState());
        TestTrackerBlacklistAcrossJobs.assertEquals((String)"Didn't blacklist the host", (int)1, (int)jc.getClusterStatus().getBlacklistedTrackers());
        TestTrackerBlacklistAcrossJobs.assertEquals((String)"Fault count should be 1", (int)1, (int)mr.getFaultCount(hosts[0]));
    }

    public static class SleepJobFailOnHost
    extends MapReduceBase
    implements Mapper<IntWritable, IntWritable, IntWritable, NullWritable> {
        String hostname = "";

        public void configure(JobConf job) {
            this.hostname = job.get("slave.host.name");
        }

        public void map(IntWritable key, IntWritable value, OutputCollector<IntWritable, NullWritable> output, Reporter reporter) throws IOException {
            if (this.hostname.equals(hosts[0])) {
                throw new IOException("failing on host: " + hosts[0]);
            }
        }
    }
}

