/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestSubmitJob
extends TestCase {
    private MiniMRCluster miniMRCluster;

    protected void tearDown() throws Exception {
        if (this.miniMRCluster != null) {
            this.miniMRCluster.shutdown();
        }
    }

    public void testJobWithInvalidMemoryReqs() throws Exception {
        JobConf jtConf = new JobConf();
        jtConf.setLong("mapred.cluster.map.memory.mb", 1024L);
        jtConf.setLong("mapred.cluster.reduce.memory.mb", 2048L);
        jtConf.setLong("mapred.cluster.max.map.memory.mb", 3072L);
        jtConf.setLong("mapred.cluster.max.reduce.memory.mb", 4096L);
        this.miniMRCluster = new MiniMRCluster(0, "file:///", 0, null, null, jtConf);
        JobConf clusterConf = this.miniMRCluster.createJobConf();
        JobConf jobConf = new JobConf((Configuration)clusterConf);
        jobConf.setMemoryForReduceTask(1024L);
        this.runJobAndVerifyFailure(jobConf, -1L, 1024L, "Invalid job requirements.");
        jobConf = new JobConf((Configuration)clusterConf);
        jobConf.setMemoryForMapTask(1024L);
        this.runJobAndVerifyFailure(jobConf, 1024L, -1L, "Invalid job requirements.");
        jobConf = new JobConf((Configuration)clusterConf);
        jobConf.setMemoryForMapTask(4096L);
        jobConf.setMemoryForReduceTask(1024L);
        this.runJobAndVerifyFailure(jobConf, 4096L, 1024L, "Exceeds the cluster's max-memory-limit.");
        jobConf = new JobConf((Configuration)clusterConf);
        jobConf.setMemoryForMapTask(1024L);
        jobConf.setMemoryForReduceTask(5120L);
        this.runJobAndVerifyFailure(jobConf, 1024L, 5120L, "Exceeds the cluster's max-memory-limit.");
    }

    private void runJobAndVerifyFailure(JobConf jobConf, long memForMapTasks, long memForReduceTasks, String expectedMsg) throws Exception, IOException {
        String[] args = new String[]{"-m", "0", "-r", "0", "-mt", "0", "-rt", "0"};
        boolean throwsException = false;
        String msg = null;
        try {
            ToolRunner.run((Configuration)jobConf, (Tool)new SleepJob(), (String[])args);
        }
        catch (RemoteException re) {
            throwsException = true;
            msg = re.unwrapRemoteException().getMessage();
        }
        TestSubmitJob.assertTrue((boolean)throwsException);
        TestSubmitJob.assertNotNull((Object)msg);
        String overallExpectedMsg = "(" + memForMapTasks + " memForMapTasks " + memForReduceTasks + " memForReduceTasks): " + expectedMsg;
        TestSubmitJob.assertTrue((String)("Observed message - " + msg + " - doesn't contain expected message - " + overallExpectedMsg), (boolean)msg.contains(overallExpectedMsg));
    }
}

