/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestMiniMRWithDFSWithDistinctUsers;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class TestMapredSystemDir
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestMapredSystemDir.class);
    private static final UnixUserGroupInformation DFS_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("dfs", true);
    private static final UnixUserGroupInformation MR_UGI = TestMiniMRWithDFSWithDistinctUsers.createUGI("mr", false);
    private static final FsPermission SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)475);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGarbledMapredSystemDir() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.permissions.supergroup", "supergroup");
            UnixUserGroupInformation.saveToConf((Configuration)conf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)DFS_UGI);
            dfs = new MiniDFSCluster(conf, 1, true, null);
            FileSystem fs = dfs.getFileSystem();
            Path mapredSysDir = new Path("/mapred");
            fs.mkdirs(mapredSysDir);
            fs.setPermission(mapredSysDir, new FsPermission(SYSTEM_DIR_PERMISSION));
            fs.setOwner(mapredSysDir, "mr", "mrgroup");
            Configuration mrConf = new Configuration();
            UnixUserGroupInformation.saveToConf((Configuration)mrConf, (String)"hadoop.job.ugi", (UnixUserGroupInformation)MR_UGI);
            mr = new MiniMRCluster(0, 0, 0, dfs.getFileSystem().getUri().toString(), 1, null, null, MR_UGI, new JobConf(mrConf));
            JobTracker jobtracker = mr.getJobTrackerRunner().getJobTracker();
            Path garbage = new Path(jobtracker.getSystemDir(), "garbage");
            fs.mkdirs(garbage);
            fs.setPermission(garbage, new FsPermission(SYSTEM_DIR_PERMISSION));
            fs.setOwner(garbage, "test", "test-group");
            mr.stopJobTracker();
            mr.getJobTrackerConf().setBoolean("mapred.jobtracker.restart.recover", false);
            mr.startJobTracker(false);
            for (int i = 0; i < 5; ++i) {
                LOG.info((Object)("Check #" + i));
                if (!mr.getJobTrackerRunner().isActive()) {
                    return;
                }
                UtilsForTests.waitFor(2000L);
            }
            TestMapredSystemDir.assertFalse((String)"JobTracker did not bail out (waited for 10 secs)", (boolean)mr.getJobTrackerRunner().isActive());
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

