/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.EmptyInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputLogFilter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestEmptyJob
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestEmptyJob.class.getName());
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    MiniMRCluster mr = null;

    private boolean launchEmptyJob(URI fileSys, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path(TEST_ROOT_DIR, "testing/empty/input");
        Path outDir = new Path(TEST_ROOT_DIR, "testing/empty/output");
        Path inDir2 = new Path(TEST_ROOT_DIR, "testing/dummy/input");
        Path outDir2 = new Path(TEST_ROOT_DIR, "testing/dummy/output");
        Path share = new Path(TEST_ROOT_DIR, "share");
        JobConf conf = this.mr.createJobConf();
        FileSystem fs = FileSystem.get((URI)fileSys, (Configuration)conf);
        fs.delete(new Path(TEST_ROOT_DIR), true);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            LOG.warn((Object)("Can't create " + inDir));
            return false;
        }
        FileSystem.setDefaultUri((Configuration)conf, (URI)fileSys);
        conf.setJobName("empty");
        conf.setInputFormat(EmptyInputFormat.class);
        conf.setOutputCommitter(CommitterWithDelayCleanup.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(IntWritable.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        conf.set("share", share.toString());
        JobClient jc = new JobClient(conf);
        RunningJob runningJob = jc.submitJob(conf);
        JobInProgress job = this.mr.getJobTrackerRunner().getJobTracker().getJob(runningJob.getID());
        while (true) {
            if (job.isCleanupLaunched()) break;
            UtilsForTests.waitFor(100L);
        }
        LOG.info((Object)("Waiting for cleanup to be launched for job " + runningJob.getID()));
        LOG.info((Object)"Launching dummy job ");
        RunningJob dJob = null;
        try {
            JobConf dConf = new JobConf((Configuration)conf);
            dConf.setOutputCommitter(FileOutputCommitter.class);
            dJob = UtilsForTests.runJob(dConf, inDir2, outDir2, 2, 0);
        }
        catch (Exception e) {
            LOG.info((Object)"Exception ", (Throwable)e);
            throw new IOException(e);
        }
        do {
            LOG.info((Object)("Waiting for job " + dJob.getID() + " to complete"));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (!dJob.isComplete());
        TestEmptyJob.assertTrue((boolean)dJob.isSuccessful());
        fs.create(share).close();
        do {
            LOG.info((Object)("Waiting for job " + runningJob.getID() + " to complete"));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (!runningJob.isComplete());
        TestEmptyJob.assertTrue((boolean)runningJob.isComplete());
        TestEmptyJob.assertTrue((boolean)runningJob.isSuccessful());
        JobID jobID = runningJob.getID();
        TaskReport[] jobSetupTasks = jc.getSetupTaskReports(jobID);
        TestEmptyJob.assertTrue((String)"Number of job-setup tips is not 2!", (jobSetupTasks.length == 2 ? 1 : 0) != 0);
        TestEmptyJob.assertTrue((String)("Setup progress is " + runningJob.setupProgress() + " and not 1.0"), ((double)runningJob.setupProgress() == 1.0 ? 1 : 0) != 0);
        TestEmptyJob.assertTrue((String)"Setup task is not finished!", (boolean)this.mr.getJobTrackerRunner().getJobTracker().getJob(jobID).isSetupFinished());
        TestEmptyJob.assertTrue((String)"Number of maps is not zero!", (jc.getMapTaskReports(runningJob.getID()).length == 0 ? 1 : 0) != 0);
        TestEmptyJob.assertTrue((String)("Map progress is " + runningJob.mapProgress() + " and not 1.0!"), ((double)runningJob.mapProgress() == 1.0 ? 1 : 0) != 0);
        TestEmptyJob.assertTrue((String)("Reduce progress is " + runningJob.reduceProgress() + " and not 1.0!"), ((double)runningJob.reduceProgress() == 1.0 ? 1 : 0) != 0);
        TestEmptyJob.assertTrue((String)("Number of reduces is not " + numReduces), (jc.getReduceTaskReports(runningJob.getID()).length == numReduces ? 1 : 0) != 0);
        TaskReport[] jobCleanupTasks = jc.getCleanupTaskReports(jobID);
        TestEmptyJob.assertTrue((String)"Number of job-cleanup tips is not 2!", (jobCleanupTasks.length == 2 ? 1 : 0) != 0);
        TestEmptyJob.assertTrue((String)("Cleanup progress is " + runningJob.cleanupProgress() + " and not 1.0"), ((double)runningJob.cleanupProgress() == 1.0 ? 1 : 0) != 0);
        TestEmptyJob.assertTrue((String)"Job output directory doesn't exit!", (boolean)fs.exists(outDir));
        FileStatus[] list = fs.listStatus(outDir, (PathFilter)new OutputLogFilter());
        TestEmptyJob.assertTrue((String)("Number of part-files is " + list.length + " and not " + numReduces), (list.length == numReduces ? 1 : 0) != 0);
        fs.delete(outDir, true);
        LOG.info((Object)("job is complete: " + runningJob.isSuccessful()));
        return runningJob.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyJob() throws IOException {
        FileSystem fileSys = null;
        try {
            int taskTrackers = 2;
            JobConf conf = new JobConf();
            fileSys = FileSystem.get((Configuration)conf);
            conf.set("mapred.job.tracker.handler.count", "1");
            conf.set("mapred.job.tracker", "127.0.0.1:0");
            conf.set("mapred.job.tracker.http.address", "127.0.0.1:0");
            conf.set("mapred.task.tracker.http.address", "127.0.0.1:0");
            this.mr = new MiniMRCluster(2, fileSys.getUri().toString(), 1, null, null, conf);
            TestEmptyJob.assertTrue((boolean)this.launchEmptyJob(fileSys.getUri(), 3, 1));
            TestEmptyJob.assertTrue((boolean)this.launchEmptyJob(fileSys.getUri(), 0, 0));
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (this.mr != null) {
                this.mr.shutdown();
            }
        }
    }

    static class CommitterWithDelayCleanup
    extends FileOutputCommitter {
        CommitterWithDelayCleanup() {
        }

        public void cleanupJob(JobContext context) throws IOException {
            Configuration conf = context.getConfiguration();
            Path share = new Path(conf.get("share"));
            FileSystem fs = FileSystem.get((Configuration)conf);
            while (!fs.exists(share)) {
                UtilsForTests.waitFor(100L);
            }
            super.cleanupJob(context);
        }
    }
}

