/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.UnixUserGroupInformation;

public class MiniMRCluster {
    private static final Log LOG = LogFactory.getLog(MiniMRCluster.class);
    private Thread jobTrackerThread;
    private JobTrackerRunner jobTracker;
    private int jobTrackerPort = 0;
    private int taskTrackerPort = 0;
    private int jobTrackerInfoPort = 0;
    private int numTaskTrackers;
    private List<TaskTrackerRunner> taskTrackerList = new ArrayList<TaskTrackerRunner>();
    private List<Thread> taskTrackerThreadList = new ArrayList<Thread>();
    private String namenode;
    private UnixUserGroupInformation ugi = null;
    private JobConf conf;
    private JobConf job;

    public String getTaskTrackerLocalDir(int taskTracker) {
        return this.taskTrackerList.get(taskTracker).getLocalDir();
    }

    public JobTrackerRunner getJobTrackerRunner() {
        return this.jobTracker;
    }

    TaskTrackerRunner getTaskTrackerRunner(int id) {
        return this.taskTrackerList.get(id);
    }

    public int getNumTaskTrackers() {
        return this.taskTrackerList.size();
    }

    public void waitUntilIdle() {
        this.waitTaskTrackers();
        try {
            JobClient client = new JobClient(this.job);
            while (client.getClusterStatus().getTaskTrackers() < this.taskTrackerList.size()) {
                for (TaskTrackerRunner runner : this.taskTrackerList) {
                    if (!runner.isDead) continue;
                    throw new RuntimeException("TaskTracker is dead");
                }
                Thread.sleep(1000L);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void waitTaskTrackers() {
        for (TaskTrackerRunner runner : this.taskTrackerList) {
            while (!(runner.isDead || runner.isInitialized && runner.tt.isIdle())) {
                if (!runner.isInitialized) {
                    LOG.info((Object)"Waiting for task tracker to start.");
                } else {
                    LOG.info((Object)("Waiting for task tracker " + runner.tt.getName() + " to be idle."));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getJobTrackerPort() {
        return this.jobTrackerPort;
    }

    public JobConf createJobConf() {
        return this.createJobConf(new JobConf());
    }

    public JobConf createJobConf(JobConf conf) {
        if (conf == null) {
            conf = new JobConf();
        }
        return MiniMRCluster.configureJobConf(conf, this.namenode, this.jobTrackerPort, this.jobTrackerInfoPort, this.ugi);
    }

    static JobConf configureJobConf(JobConf conf, String namenode, int jobTrackerPort, int jobTrackerInfoPort, UnixUserGroupInformation ugi) {
        JobConf result = new JobConf((Configuration)conf);
        FileSystem.setDefaultUri((Configuration)result, (String)namenode);
        result.set("mapred.job.tracker", "localhost:" + jobTrackerPort);
        result.set("mapred.job.tracker.http.address", "127.0.0.1:" + jobTrackerInfoPort);
        if (ugi != null) {
            result.set("mapred.system.dir", "/mapred/system");
            UnixUserGroupInformation.saveToConf((Configuration)result, (String)"hadoop.job.ugi", (UnixUserGroupInformation)ugi);
        }
        JobClient.setTaskOutputFilter((JobConf)result, (JobClient.TaskStatusFilter)JobClient.TaskStatusFilter.ALL);
        return result;
    }

    public MiniMRCluster(int numTaskTrackers, String namenode, int numDir, String[] racks, String[] hosts) throws IOException {
        this(0, 0, numTaskTrackers, namenode, numDir, racks, hosts);
    }

    public MiniMRCluster(int numTaskTrackers, String namenode, int numDir, String[] racks, String[] hosts, JobConf conf) throws IOException {
        this(0, 0, numTaskTrackers, namenode, numDir, racks, hosts, null, conf);
    }

    public MiniMRCluster(int numTaskTrackers, String namenode, int numDir) throws IOException {
        this(0, 0, numTaskTrackers, namenode, numDir);
    }

    public MiniMRCluster(int jobTrackerPort, int taskTrackerPort, int numTaskTrackers, String namenode, int numDir) throws IOException {
        this(jobTrackerPort, taskTrackerPort, numTaskTrackers, namenode, numDir, null);
    }

    public MiniMRCluster(int jobTrackerPort, int taskTrackerPort, int numTaskTrackers, String namenode, int numDir, String[] racks) throws IOException {
        this(jobTrackerPort, taskTrackerPort, numTaskTrackers, namenode, numDir, racks, null);
    }

    public MiniMRCluster(int jobTrackerPort, int taskTrackerPort, int numTaskTrackers, String namenode, int numDir, String[] racks, String[] hosts) throws IOException {
        this(jobTrackerPort, taskTrackerPort, numTaskTrackers, namenode, numDir, racks, hosts, null);
    }

    public MiniMRCluster(int jobTrackerPort, int taskTrackerPort, int numTaskTrackers, String namenode, int numDir, String[] racks, String[] hosts, UnixUserGroupInformation ugi) throws IOException {
        this(jobTrackerPort, taskTrackerPort, numTaskTrackers, namenode, numDir, racks, hosts, ugi, null);
    }

    public MiniMRCluster(int jobTrackerPort, int taskTrackerPort, int numTaskTrackers, String namenode, int numDir, String[] racks, String[] hosts, UnixUserGroupInformation ugi, JobConf conf) throws IOException {
        int i;
        if (racks != null && racks.length < numTaskTrackers) {
            LOG.error((Object)"Invalid number of racks specified. It should be at least equal to the number of tasktrackers");
            this.shutdown();
        }
        if (hosts != null && numTaskTrackers > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of tasktrackers [" + numTaskTrackers + "].");
        }
        if (racks == null) {
            System.out.println("Generating rack names for tasktrackers");
            racks = new String[numTaskTrackers];
            for (i = 0; i < racks.length; ++i) {
                racks[i] = "/default-rack";
            }
        }
        if (hosts == null) {
            System.out.println("Generating host names for tasktrackers");
            hosts = new String[numTaskTrackers];
            for (i = 0; i < numTaskTrackers; ++i) {
                hosts[i] = "host" + i + ".foo.com";
            }
        }
        this.jobTrackerPort = jobTrackerPort;
        this.taskTrackerPort = taskTrackerPort;
        this.jobTrackerInfoPort = 0;
        this.numTaskTrackers = 0;
        this.namenode = namenode;
        this.ugi = ugi;
        this.conf = conf;
        this.startJobTracker();
        for (int idx = 0; idx < numTaskTrackers; ++idx) {
            String rack = null;
            String host = null;
            if (racks != null) {
                rack = racks[idx];
            }
            if (hosts != null) {
                host = hosts[idx];
            }
            this.startTaskTracker(host, rack, idx, numDir);
        }
        this.job = this.createJobConf(conf);
        this.waitUntilIdle();
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(JobID id, int from, int max) throws IOException {
        return this.jobTracker.getJobTracker().getTaskCompletionEvents(id, from, max);
    }

    public void setJobPriority(JobID jobId, JobPriority priority) {
        this.jobTracker.getJobTracker().setJobPriority(jobId, priority);
    }

    public JobPriority getJobPriority(JobID jobId) {
        return this.jobTracker.getJobTracker().getJob(jobId).getPriority();
    }

    public long getJobFinishTime(JobID jobId) {
        return this.jobTracker.getJobTracker().getJob(jobId).getFinishTime();
    }

    public void initializeJob(JobID jobId) throws IOException {
        JobInProgress job = this.jobTracker.getJobTracker().getJob(jobId);
        this.jobTracker.getJobTracker().initJob(job);
    }

    public MapTaskCompletionEventsUpdate getMapTaskCompletionEventsUpdates(int index, JobID jobId, int max) throws IOException {
        String jtId = this.jobTracker.getJobTracker().getTrackerIdentifier();
        TaskAttemptID dummy = new TaskAttemptID(jtId, jobId.getId(), false, 0, 0);
        return this.taskTrackerList.get(index).getTaskTracker().getMapCompletionEvents(jobId, 0, max, dummy);
    }

    public JobConf getJobTrackerConf() {
        return this.conf;
    }

    public int getNumEventsRecovered() {
        return this.jobTracker.getJobTracker().recoveryManager.totalEventsRecovered();
    }

    public int getFaultCount(String hostName) {
        return this.jobTracker.getJobTracker().getFaultCount(hostName);
    }

    public void startJobTracker() {
        this.startJobTracker(true);
    }

    void startJobTracker(boolean wait) {
        this.jobTracker = new JobTrackerRunner(this.conf);
        this.jobTrackerThread = new Thread(this.jobTracker);
        this.jobTrackerThread.start();
        if (!wait) {
            return;
        }
        while (this.jobTracker.isActive() && !this.jobTracker.isUp()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        ClusterStatus status = null;
        if (this.jobTracker.isUp()) {
            status = this.jobTracker.getJobTracker().getClusterStatus(false);
            while (this.jobTracker.isActive() && status.getJobTrackerState() == JobTracker.State.INITIALIZING) {
                try {
                    LOG.info((Object)"JobTracker still initializing. Waiting.");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                status = this.jobTracker.getJobTracker().getClusterStatus(false);
            }
        }
        if (!this.jobTracker.isActive()) {
            return;
        }
        this.jobTrackerPort = this.jobTracker.getJobTrackerPort();
        this.jobTrackerInfoPort = this.jobTracker.getJobTrackerInfoPort();
    }

    public void stopJobTracker() {
        this.jobTracker.shutdown();
        this.jobTrackerThread.interrupt();
        try {
            this.jobTrackerThread.join();
        }
        catch (InterruptedException ex) {
            LOG.error((Object)"Problem waiting for job tracker to finish", (Throwable)ex);
        }
    }

    public void stopTaskTracker(int id) {
        TaskTrackerRunner tracker = this.taskTrackerList.remove(id);
        tracker.shutdown();
        Thread thread = this.taskTrackerThreadList.remove(id);
        thread.interrupt();
        try {
            thread.join();
            tracker.isDead = true;
            --this.numTaskTrackers;
        }
        catch (InterruptedException ex) {
            LOG.error((Object)"Problem waiting for task tracker to finish", (Throwable)ex);
        }
    }

    public void startTaskTracker(String host, String rack, int idx, int numDir) throws IOException {
        if (rack != null) {
            StaticMapping.addNodeToRack(host, rack);
        }
        if (host != null) {
            NetUtils.addStaticResolution((String)host, (String)"localhost");
        }
        TaskTrackerRunner taskTracker = new TaskTrackerRunner(idx, numDir, host, this.conf);
        Thread taskTrackerThread = new Thread(taskTracker);
        this.taskTrackerList.add(taskTracker);
        this.taskTrackerThreadList.add(taskTrackerThread);
        taskTrackerThread.start();
        ++this.numTaskTrackers;
    }

    int getTaskTrackerID(String trackerName) {
        for (int id = 0; id < this.numTaskTrackers; ++id) {
            if (!this.taskTrackerList.get(id).getTaskTracker().getName().equals(trackerName)) continue;
            return id;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.waitTaskTrackers();
            for (int idx = 0; idx < this.numTaskTrackers; ++idx) {
                TaskTrackerRunner taskTracker = this.taskTrackerList.get(idx);
                Thread taskTrackerThread = this.taskTrackerThreadList.get(idx);
                taskTracker.shutdown();
                taskTrackerThread.interrupt();
                try {
                    taskTrackerThread.join();
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)"Problem shutting down task tracker", (Throwable)ex);
                }
            }
            this.stopJobTracker();
        }
        finally {
            File configDir = new File("build", "minimr");
            File siteFile = new File(configDir, "mapred-site.xml");
            siteFile.delete();
        }
    }

    public static void main(String[] args) throws IOException {
        LOG.info((Object)"Bringing up Jobtracker and tasktrackers.");
        MiniMRCluster mr = new MiniMRCluster(4, "file:///", 1);
        LOG.info((Object)"JobTracker and TaskTrackers are up.");
        mr.shutdown();
        LOG.info((Object)"JobTracker and TaskTrackers brought down.");
    }

    class TaskTrackerRunner
    implements Runnable {
        volatile TaskTracker tt;
        int trackerId;
        String[] localDirs;
        volatile boolean isInitialized = false;
        volatile boolean isDead = false;
        int numDir;

        TaskTrackerRunner(int trackerId, int numDir, String hostname, JobConf cfg) throws IOException {
            this.trackerId = trackerId;
            this.numDir = numDir;
            this.localDirs = new String[numDir];
            JobConf conf = null;
            conf = cfg == null ? MiniMRCluster.this.createJobConf() : MiniMRCluster.this.createJobConf(cfg);
            if (hostname != null) {
                conf.set("slave.host.name", hostname);
            }
            conf.set("mapred.task.tracker.http.address", "0.0.0.0:0");
            conf.set("mapred.task.tracker.report.address", "127.0.0.1:" + MiniMRCluster.this.taskTrackerPort);
            File localDirBase = new File(conf.get("mapred.local.dir")).getAbsoluteFile();
            localDirBase.mkdirs();
            StringBuffer localPath = new StringBuffer();
            for (int i = 0; i < numDir; ++i) {
                File ttDir = new File(localDirBase, Integer.toString(trackerId) + "_" + 0);
                if (!ttDir.mkdirs() && !ttDir.isDirectory()) {
                    throw new IOException("Mkdirs failed to create " + ttDir);
                }
                this.localDirs[i] = ttDir.toString();
                if (i != 0) {
                    localPath.append(",");
                }
                localPath.append(this.localDirs[i]);
            }
            conf.set("mapred.local.dir", localPath.toString());
            LOG.info((Object)("mapred.local.dir is " + localPath));
            try {
                this.tt = new TaskTracker(conf);
                this.isInitialized = true;
            }
            catch (Throwable e) {
                this.isDead = true;
                this.tt = null;
                LOG.error((Object)("task tracker " + trackerId + " crashed"), e);
            }
        }

        @Override
        public void run() {
            try {
                if (this.tt != null) {
                    this.tt.run();
                }
            }
            catch (Throwable e) {
                this.isDead = true;
                this.tt = null;
                LOG.error((Object)("task tracker " + this.trackerId + " crashed"), e);
            }
        }

        public String getLocalDir() {
            return this.localDirs[0];
        }

        public String[] getLocalDirs() {
            return this.localDirs;
        }

        public TaskTracker getTaskTracker() {
            return this.tt;
        }

        public void shutdown() {
            if (this.tt != null) {
                try {
                    this.tt.shutdown();
                }
                catch (Throwable e) {
                    LOG.error((Object)("task tracker " + this.trackerId + " could not shut down"), e);
                }
            }
        }
    }

    class JobTrackerRunner
    implements Runnable {
        private JobTracker tracker = null;
        private volatile boolean isActive = true;
        JobConf jc = null;

        public JobTrackerRunner(JobConf conf) {
            this.jc = conf;
        }

        public boolean isUp() {
            return this.tracker != null;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public int getJobTrackerPort() {
            return this.tracker.getTrackerPort();
        }

        public int getJobTrackerInfoPort() {
            return this.tracker.getInfoPort();
        }

        public JobTracker getJobTracker() {
            return this.tracker;
        }

        @Override
        public void run() {
            try {
                this.jc = this.jc == null ? MiniMRCluster.this.createJobConf() : MiniMRCluster.this.createJobConf(this.jc);
                File f = new File("build/test/mapred/local").getAbsoluteFile();
                this.jc.set("mapred.local.dir", f.getAbsolutePath());
                this.jc.setClass("topology.node.switch.mapping.impl", StaticMapping.class, DNSToSwitchMapping.class);
                String id = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                this.tracker = JobTracker.startTracker((JobConf)this.jc, (String)id);
                this.tracker.offerService();
            }
            catch (Throwable e) {
                LOG.error((Object)"Job tracker crashed", e);
                this.isActive = false;
            }
        }

        public void shutdown() {
            try {
                if (this.tracker != null) {
                    this.tracker.stopTracker();
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Problem shutting down job tracker", e);
            }
            this.isActive = false;
        }
    }
}

