/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.util.StringUtils;

public class TestStartup
extends TestCase {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String WILDCARD_HTTP_HOST = "0.0.0.0:";
    private static final Log LOG = LogFactory.getLog((String)TestStartup.class.getName());
    private Configuration config;
    private File hdfsDir = null;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    private long editsLength = 0L;
    private long fsimageLength = 0L;

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 4096L);
        byte[] buffer = new byte[8192];
        Random rand = new Random(0xAAAAEEFL);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    protected void setUp() throws Exception {
        this.config = new Configuration();
        String baseDir = System.getProperty("test.build.data", "/tmp");
        this.hdfsDir = new File(baseDir, "dfs");
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        LOG.info((Object)("--hdfsdir is " + this.hdfsDir.getAbsolutePath()));
        this.config.set("dfs.name.dir", new File(this.hdfsDir, "name").getPath());
        this.config.set("dfs.data.dir", new File(this.hdfsDir, "data").getPath());
        this.config.set("fs.checkpoint.dir", new File(this.hdfsDir, "secondary").getPath());
        this.config.set("dfs.secondary.http.address", "0.0.0.0:0");
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
    }

    public void tearDown() throws Exception {
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + this.hdfsDir + "'");
        }
    }

    public void createCheckPoint() throws IOException {
        LOG.info((Object)"--starting mini cluster");
        MiniDFSCluster cluster = null;
        SecondaryNameNode sn = null;
        try {
            cluster = new MiniDFSCluster(0, this.config, 1, true, false, false, null, null, null, null);
            cluster.waitActive();
            LOG.info((Object)"--starting Secondary Node");
            sn = new SecondaryNameNode(this.config);
            TestStartup.assertNotNull((Object)sn);
            FileSystem fileSys = cluster.getFileSystem();
            Path file1 = new Path("t1");
            this.writeFile(fileSys, file1, 1);
            LOG.info((Object)"--doing checkpoint");
            sn.doCheckpoint();
            LOG.info((Object)"--done checkpoint");
        }
        catch (IOException e) {
            TestStartup.fail((String)StringUtils.stringifyException((Throwable)e));
            System.err.println("checkpoint failed");
            throw e;
        }
        finally {
            if (sn != null) {
                sn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            LOG.info((Object)"--file t1 created, cluster shutdown");
        }
    }

    private void corruptNameNodeFiles() throws IOException {
        List nameDirs = (List)FSNamesystem.getNamespaceDirs((Configuration)this.config);
        List nameEditsDirs = (List)FSNamesystem.getNamespaceEditsDirs((Configuration)this.config);
        File dir = (File)nameDirs.get(0);
        this.fsimageLength = new File(new File(dir, "current"), FSImage.NameNodeFile.IMAGE.getName()).length();
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Cannot remove directory: " + dir);
        }
        LOG.info((Object)("--removed dir " + dir + ";len was =" + this.fsimageLength));
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        dir = (File)nameEditsDirs.get(0);
        this.editsLength = new File(new File(dir, "current"), FSImage.NameNodeFile.EDITS.getName()).length();
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Cannot remove directory: " + dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        LOG.info((Object)("--removed dir and recreated " + dir + ";len was =" + this.editsLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNameNodeFiles() throws IOException {
        LOG.info((Object)"-- about to start DFS cluster");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster(0, this.config, 1, false, false, false, HdfsConstants.StartupOption.IMPORT, null, null, null);
            cluster.waitActive();
            LOG.info((Object)"--NN started with checkpoint option");
            NameNode nn = cluster.getNameNode();
            TestStartup.assertNotNull((Object)nn);
            FSImage image = nn.getFSImage();
            this.verifyDifferentDirs(image, this.fsimageLength, this.editsLength);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void verifyDifferentDirs(FSImage img, long expectedImgSize, long expectedEditsSize) {
        Storage.StorageDirectory sd = null;
        Iterator it = img.dirIterator();
        while (it.hasNext()) {
            sd = (Storage.StorageDirectory)it.next();
            if (sd.getStorageDirType().isOfType((Storage.StorageDirType)FSImage.NameNodeDirType.IMAGE)) {
                File imf = FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.IMAGE);
                LOG.info((Object)("--image file " + imf.getAbsolutePath() + "; len = " + imf.length() + "; expected = " + expectedImgSize));
                TestStartup.assertEquals((long)expectedImgSize, (long)imf.length());
                continue;
            }
            if (sd.getStorageDirType().isOfType((Storage.StorageDirType)FSImage.NameNodeDirType.EDITS)) {
                File edf = FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.EDITS);
                LOG.info((Object)("-- edits file " + edf.getAbsolutePath() + "; len = " + edf.length() + "; expected = " + expectedEditsSize));
                TestStartup.assertEquals((long)expectedEditsSize, (long)edf.length());
                continue;
            }
            TestStartup.fail((String)"Image/Edits directories are not different");
        }
    }

    public void testChkpointStartup2() throws IOException {
        LOG.info((Object)"--starting checkpointStartup2 - same directory for checkpoint");
        this.config.set("dfs.name.dir", new File(this.hdfsDir, "name").getPath());
        this.config.set("dfs.name.edits.dir", new File(this.hdfsDir, "edits").getPath());
        this.config.set("fs.checkpoint.edits.dir", new File(this.hdfsDir, "chkpt").getPath());
        this.config.set("fs.checkpoint.dir", new File(this.hdfsDir, "chkpt").getPath());
        this.createCheckPoint();
        this.corruptNameNodeFiles();
        this.checkNameNodeFiles();
    }

    public void testChkpointStartup1() throws IOException {
        LOG.info((Object)"--starting testStartup Recovery");
        this.config.set("dfs.name.dir", new File(this.hdfsDir, "name").getPath());
        this.config.set("dfs.name.edits.dir", new File(this.hdfsDir, "edits").getPath());
        this.config.set("fs.checkpoint.edits.dir", new File(this.hdfsDir, "chkpt_edits").getPath());
        this.config.set("fs.checkpoint.dir", new File(this.hdfsDir, "chkpt").getPath());
        this.createCheckPoint();
        this.corruptNameNodeFiles();
        this.checkNameNodeFiles();
    }

    public void testSNNStartup() throws IOException {
        LOG.info((Object)"--starting SecondNN startup test");
        this.config.set("dfs.name.dir", new File(this.hdfsDir, "name").getPath());
        this.config.set("dfs.name.edits.dir", new File(this.hdfsDir, "name").getPath());
        this.config.set("fs.checkpoint.edits.dir", new File(this.hdfsDir, "chkpt_edits").getPath());
        this.config.set("fs.checkpoint.dir", new File(this.hdfsDir, "chkpt").getPath());
        LOG.info((Object)"--starting NN ");
        MiniDFSCluster cluster = null;
        SecondaryNameNode sn = null;
        NameNode nn = null;
        try {
            cluster = new MiniDFSCluster(0, this.config, 1, true, false, false, null, null, null, null);
            cluster.waitActive();
            nn = cluster.getNameNode();
            TestStartup.assertNotNull((Object)nn);
            LOG.info((Object)"--starting SecondNN");
            sn = new SecondaryNameNode(this.config);
            TestStartup.assertNotNull((Object)sn);
            LOG.info((Object)"--doing checkpoint");
            sn.doCheckpoint();
            LOG.info((Object)"--done checkpoint");
            FSImage image = nn.getFSImage();
            Storage.StorageDirectory sd = image.getStorageDir(0);
            TestStartup.assertEquals((Object)sd.getStorageDirType(), (Object)FSImage.NameNodeDirType.IMAGE_AND_EDITS);
            File imf = FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.IMAGE);
            File edf = FSImage.getImageFile((Storage.StorageDirectory)sd, (FSImage.NameNodeFile)FSImage.NameNodeFile.EDITS);
            LOG.info((Object)("--image file " + imf.getAbsolutePath() + "; len = " + imf.length()));
            LOG.info((Object)("--edits file " + edf.getAbsolutePath() + "; len = " + edf.length()));
            FSImage chkpImage = sn.getFSImage();
            this.verifyDifferentDirs(chkpImage, imf.length(), edf.length());
        }
        catch (IOException e) {
            TestStartup.fail((String)StringUtils.stringifyException((Throwable)e));
            System.err.println("checkpoint failed");
            throw e;
        }
        finally {
            if (sn != null) {
                sn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

