/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;

public class TestDFSStorageStateRecovery
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSStorageStateRecovery");
    private Configuration conf = null;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;
    static boolean[][] testCases = new boolean[][]{{true, false, false, false, true, true, false}, {true, true, false, false, true, true, true}, {true, false, true, false, true, true, true}, {true, true, true, true, false, false, false}, {true, true, true, false, false, false, false}, {false, true, true, true, false, false, false}, {false, true, true, false, false, false, false}, {false, false, false, false, false, false, false}, {false, true, false, false, false, false, false}, {false, false, true, false, true, true, false}, {true, false, false, true, true, true, false}, {true, true, false, true, false, false, false}, {true, true, true, true, false, false, false}, {true, false, true, true, false, false, false}, {false, true, true, true, false, false, false}, {false, false, true, true, false, false, false}, {false, false, false, true, false, false, false}, {false, true, false, true, true, true, true}};

    void log(String label, int numDirs, int testCaseNum, boolean[] state) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs + " testCase=" + testCaseNum + " current=" + state[0] + " previous=" + state[1] + " previous.tmp=" + state[2] + " removed.tmp=" + state[3]));
    }

    String[] createStorageState(HdfsConstants.NodeType nodeType, boolean[] state) throws Exception {
        String[] baseDirs = nodeType == HdfsConstants.NodeType.NAME_NODE ? this.conf.getStrings("dfs.name.dir") : this.conf.getStrings("dfs.data.dir");
        UpgradeUtilities.createEmptyDirs(baseDirs);
        if (state[0]) {
            UpgradeUtilities.createStorageDirs(nodeType, baseDirs, "current");
        }
        if (state[1]) {
            UpgradeUtilities.createStorageDirs(nodeType, baseDirs, "previous");
        }
        if (state[2]) {
            UpgradeUtilities.createStorageDirs(nodeType, baseDirs, "previous.tmp");
        }
        if (state[3]) {
            UpgradeUtilities.createStorageDirs(nodeType, baseDirs, "removed.tmp");
        }
        return baseDirs;
    }

    void checkResult(HdfsConstants.NodeType nodeType, String[] baseDirs, boolean currentShouldExist, boolean previousShouldExist) throws IOException {
        int i;
        switch (nodeType) {
            case NAME_NODE: {
                if (!currentShouldExist) break;
                for (i = 0; i < baseDirs.length; ++i) {
                    TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current").isDirectory());
                    TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current/VERSION").isFile());
                    TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current/edits").isFile());
                    TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current/fsimage").isFile());
                    TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current/fstime").isFile());
                }
                break;
            }
            case DATA_NODE: {
                if (!currentShouldExist) break;
                for (i = 0; i < baseDirs.length; ++i) {
                    TestDFSStorageStateRecovery.assertEquals((long)UpgradeUtilities.checksumContents(nodeType, new File(baseDirs[i], "current")), (long)UpgradeUtilities.checksumMasterContents(nodeType));
                }
                break;
            }
        }
        if (previousShouldExist) {
            for (i = 0; i < baseDirs.length; ++i) {
                TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "previous").isDirectory());
                TestDFSStorageStateRecovery.assertEquals((long)UpgradeUtilities.checksumContents(nodeType, new File(baseDirs[i], "previous")), (long)UpgradeUtilities.checksumMasterContents(nodeType));
            }
        }
    }

    public void testStorageStates() throws Exception {
        UpgradeUtilities.initialize();
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new Configuration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            for (int i = 0; i < testCases.length; ++i) {
                String[] baseDirs;
                boolean prevAfterRecover;
                boolean curAfterRecover;
                boolean shouldRecover;
                boolean[] testCase;
                block12: {
                    testCase = testCases[i];
                    shouldRecover = testCase[4];
                    curAfterRecover = testCase[5];
                    prevAfterRecover = testCase[6];
                    this.log("NAME_NODE recovery", numDirs, i, testCase);
                    baseDirs = this.createStorageState(HdfsConstants.NodeType.NAME_NODE, testCase);
                    if (shouldRecover) {
                        this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.REGULAR);
                        this.checkResult(HdfsConstants.NodeType.NAME_NODE, baseDirs, curAfterRecover, prevAfterRecover);
                        this.cluster.shutdown();
                    } else {
                        try {
                            this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.REGULAR);
                            throw new AssertionError((Object)"NameNode should have failed to start");
                        }
                        catch (IOException expected) {
                            if (testCases[i][0] || testCases[i][2] || testCases[i][1] || testCases[i][3]) break block12;
                            TestDFSStorageStateRecovery.assertTrue((boolean)expected.getLocalizedMessage().contains("NameNode is not formatted"));
                        }
                    }
                }
                this.log("DATA_NODE recovery", numDirs, i, testCase);
                this.createStorageState(HdfsConstants.NodeType.NAME_NODE, new boolean[]{true, true, false, false});
                this.cluster = new MiniDFSCluster(this.conf, 0, HdfsConstants.StartupOption.REGULAR);
                baseDirs = this.createStorageState(HdfsConstants.NodeType.DATA_NODE, testCase);
                if (!(testCase[0] || testCase[1] || testCase[2] || testCase[3])) {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsConstants.StartupOption.REGULAR, null);
                } else if (shouldRecover) {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsConstants.StartupOption.REGULAR, null);
                    this.checkResult(HdfsConstants.NodeType.DATA_NODE, baseDirs, curAfterRecover, prevAfterRecover);
                } else {
                    try {
                        this.cluster.startDataNodes(this.conf, 1, false, HdfsConstants.StartupOption.REGULAR, null);
                        throw new AssertionError((Object)"DataNode should have failed to start");
                    }
                    catch (Exception expected) {
                        // empty catch block
                    }
                }
                this.cluster.shutdown();
            }
        }
    }

    protected void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSStorageStateRecovery().testStorageStates();
    }
}

