/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class TestLocalFileSystem
extends TestCase {
    private static String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data/work-dir/localfs");

    static void writeFile(FileSystem fs, Path name) throws IOException {
        FSDataOutputStream stm = fs.create(name);
        stm.writeBytes("42\n");
        stm.close();
    }

    static String readFile(FileSystem fs, Path name) throws IOException {
        int n;
        int remaining;
        byte[] b = new byte[1024];
        int offset = 0;
        FSDataInputStream in = fs.open(name);
        while ((remaining = b.length - offset) > 0 && (n = in.read(b, offset, remaining)) != -1) {
            offset += n;
        }
        in.close();
        String s = new String(b, 0, offset);
        System.out.println("s=" + s);
        return s;
    }

    private void cleanupFile(FileSystem fs, Path name) throws IOException {
        TestLocalFileSystem.assertTrue((boolean)fs.exists(name));
        fs.delete(name, true);
        TestLocalFileSystem.assertTrue((!fs.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkingDirectory() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        Path origDir = fileSys.getWorkingDirectory();
        Path subdir = new Path(TEST_ROOT_DIR, "new");
        try {
            TestLocalFileSystem.assertTrue((!fileSys.exists(subdir) ? 1 : 0) != 0);
            TestLocalFileSystem.assertTrue((boolean)fileSys.mkdirs(subdir));
            TestLocalFileSystem.assertTrue((boolean)fileSys.isDirectory(subdir));
            fileSys.setWorkingDirectory(subdir);
            Path dir1 = new Path("dir1");
            TestLocalFileSystem.assertTrue((boolean)fileSys.mkdirs(dir1));
            TestLocalFileSystem.assertTrue((boolean)fileSys.isDirectory(dir1));
            fileSys.delete(dir1, true);
            TestLocalFileSystem.assertTrue((!fileSys.exists(dir1) ? 1 : 0) != 0);
            Path file1 = new Path("file1");
            Path file2 = new Path("sub/file2");
            TestLocalFileSystem.writeFile((FileSystem)fileSys, file1);
            fileSys.copyFromLocalFile(file1, file2);
            TestLocalFileSystem.assertTrue((boolean)fileSys.exists(file1));
            TestLocalFileSystem.assertTrue((boolean)fileSys.isFile(file1));
            this.cleanupFile((FileSystem)fileSys, file2);
            fileSys.copyToLocalFile(file1, file2);
            this.cleanupFile((FileSystem)fileSys, file2);
            fileSys.rename(file1, file2);
            TestLocalFileSystem.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            TestLocalFileSystem.assertTrue((boolean)fileSys.exists(file2));
            fileSys.rename(file2, file1);
            FSDataInputStream stm = fileSys.open(file1);
            byte[] buffer = new byte[3];
            int bytesRead = stm.read(buffer, 0, 3);
            TestLocalFileSystem.assertEquals((String)"42\n", (String)new String(buffer, 0, bytesRead));
            stm.close();
        }
        finally {
            fileSys.setWorkingDirectory(origDir);
            fileSys.delete(subdir, true);
        }
    }

    public void testCopy() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path src = new Path(TEST_ROOT_DIR, "dingo");
        Path dst = new Path(TEST_ROOT_DIR, "yak");
        TestLocalFileSystem.writeFile((FileSystem)fs, src);
        TestLocalFileSystem.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)src, (FileSystem)fs, (Path)dst, (boolean)true, (boolean)false, (Configuration)conf));
        TestLocalFileSystem.assertTrue((!fs.exists(src) && fs.exists(dst) ? 1 : 0) != 0);
        TestLocalFileSystem.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)false, (boolean)false, (Configuration)conf));
        TestLocalFileSystem.assertTrue((fs.exists(src) && fs.exists(dst) ? 1 : 0) != 0);
        TestLocalFileSystem.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)src, (FileSystem)fs, (Path)dst, (boolean)true, (boolean)true, (Configuration)conf));
        TestLocalFileSystem.assertTrue((!fs.exists(src) && fs.exists(dst) ? 1 : 0) != 0);
        fs.mkdirs(src);
        TestLocalFileSystem.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)false, (boolean)false, (Configuration)conf));
        Path tmp = new Path(src, dst.getName());
        TestLocalFileSystem.assertTrue((fs.exists(tmp) && fs.exists(dst) ? 1 : 0) != 0);
        TestLocalFileSystem.assertTrue((boolean)FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)false, (boolean)true, (Configuration)conf));
        TestLocalFileSystem.assertTrue((boolean)fs.delete(tmp, true));
        fs.mkdirs(tmp);
        try {
            FileUtil.copy((FileSystem)fs, (Path)dst, (FileSystem)fs, (Path)src, (boolean)true, (boolean)true, (Configuration)conf);
            TestLocalFileSystem.fail((String)"Failed to detect existing dir");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void testHomeDirectory() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        Path home = new Path(System.getProperty("user.home")).makeQualified((FileSystem)fileSys);
        Path fsHome = fileSys.getHomeDirectory();
        TestLocalFileSystem.assertEquals((Object)home, (Object)fsHome);
    }

    public void testPathEscapes() throws IOException {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path path = new Path(TEST_ROOT_DIR, "foo%bar");
        TestLocalFileSystem.writeFile((FileSystem)fs, path);
        FileStatus status = fs.getFileStatus(path);
        TestLocalFileSystem.assertEquals((Object)path.makeQualified((FileSystem)fs), (Object)status.getPath());
        this.cleanupFile((FileSystem)fs, path);
    }
}

