/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class TestDisableCache
extends TestCase {
    public void testCacheEnabled() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem fs1 = FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
        FileSystem fs2 = FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
        TestDisableCache.assertSame((Object)fs1, (Object)fs2);
    }

    public void testCacheDisabled() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.uncachedfile.impl", conf.get("fs.file.impl"));
        conf.setBoolean("fs.uncachedfile.impl.disable.cache", true);
        FileSystem fs1 = FileSystem.get((URI)new URI("uncachedfile://a"), (Configuration)conf);
        FileSystem fs2 = FileSystem.get((URI)new URI("uncachedfile://a"), (Configuration)conf);
        TestDisableCache.assertNotSame((Object)fs1, (Object)fs2);
    }
}

