/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.wrapper;

import java.io.File;
import java.io.IOException;
import org.apache.flex.utilities.converter.BaseConverter;
import org.apache.flex.utilities.converter.Converter;
import org.apache.flex.utilities.converter.exceptions.ConverterException;
import org.apache.flex.utilities.converter.model.MavenArtifact;

public class WrapperConverter
extends BaseConverter
implements Converter {
    public WrapperConverter(File rootSourceDirectory, File rootTargetDirectory) throws ConverterException {
        super(rootSourceDirectory, rootTargetDirectory);
    }

    protected void processDirectory() throws ConverterException {
        File wrapperRootDir = new File(this.rootSourceDirectory, "templates/swfobject");
        if (!wrapperRootDir.exists() || !wrapperRootDir.isDirectory()) {
            System.out.println("Skipping Wrapper generation.");
            return;
        }
        try {
            File indexHtml = new File(wrapperRootDir, "index.template.html");
            if (!indexHtml.renameTo(new File(wrapperRootDir, "index.html"))) {
                System.out.println("Could not rename index.template.html to index.html.");
            }
            File wrapperWar = File.createTempFile("SWFObjectWrapper-2.2", ".war");
            this.generateZip(wrapperRootDir.listFiles(), wrapperWar);
            MavenArtifact swfobjectWrapper = new MavenArtifact();
            swfobjectWrapper.setGroupId("org.apache.flex.wrapper");
            swfobjectWrapper.setArtifactId("swfobject");
            swfobjectWrapper.setVersion(this.getFlexVersion(this.rootSourceDirectory));
            swfobjectWrapper.setPackaging("war");
            swfobjectWrapper.addDefaultBinaryArtifact(wrapperWar);
            this.writeArtifact(swfobjectWrapper);
        }
        catch (IOException e) {
            throw new ConverterException("Error creating wrapper war.", (Throwable)e);
        }
    }
}

