/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.flex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.flex.utilities.converter.BaseConverter;
import org.apache.flex.utilities.converter.Converter;
import org.apache.flex.utilities.converter.air.AirConverter;
import org.apache.flex.utilities.converter.exceptions.ConverterException;
import org.apache.flex.utilities.converter.flash.FlashConverter;
import org.apache.flex.utilities.converter.model.MavenArtifact;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FlexConverter
extends BaseConverter
implements Converter {
    protected String flexSdkVersion;
    protected String flexBuild;

    public FlexConverter(File rootSourceDirectory, File rootTargetDirectory) throws ConverterException {
        super(rootSourceDirectory, rootTargetDirectory);
        this.flexSdkVersion = this.getFlexVersion(rootSourceDirectory);
        this.flexBuild = this.getFlexBuild(rootSourceDirectory);
    }

    protected void processDirectory() throws ConverterException {
        if (this.flexSdkVersion == null || !this.rootSourceDirectory.exists() || !this.rootSourceDirectory.isDirectory()) {
            System.out.println("Skipping Flex SDK generation.");
            return;
        }
        this.generateCompilerArtifacts();
        this.generateFrameworkArtifacts();
        this.generateTemplatesArtifact();
    }

    protected void generateCompilerArtifacts() throws ConverterException {
        MavenArtifact compiler = new MavenArtifact();
        compiler.setGroupId("org.apache.flex");
        compiler.setArtifactId("compiler");
        compiler.setVersion(this.flexSdkVersion);
        compiler.setPackaging("pom");
        File directory = new File(this.rootSourceDirectory, "lib");
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ConverterException("Compiler directory does not exist.");
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(Arrays.asList(directory.listFiles(new FlexCompilerFilter())));
        File externalDirectory = new File(directory, "external");
        if (externalDirectory.exists() && externalDirectory.isDirectory()) {
            files.addAll(Arrays.asList(externalDirectory.listFiles(new FlexCompilerFilter())));
        }
        for (File sourceFile : files) {
            MavenArtifact artifact = this.resolveArtifact(sourceFile, "org.apache.flex.compiler", this.flexSdkVersion);
            compiler.addDependency(artifact);
        }
        this.writeArtifact(compiler);
    }

    protected void generateFrameworkArtifacts() throws ConverterException {
        File directory = new File(this.rootSourceDirectory, "frameworks" + File.separator + "libs");
        this.generateFrameworkArtifacts(directory, "org.apache.flex");
        this.generateThemeArtifacts();
        this.generateFrameworkConfigurationArtifact();
    }

    protected void generateFrameworkArtifacts(File directory, String curGroupId) throws ConverterException {
        File mobileExperimental;
        MavenArtifact artifact;
        MavenArtifact framework = new MavenArtifact();
        framework.setGroupId(curGroupId);
        framework.setArtifactId("libs".equals(directory.getName()) ? "framework" : directory.getName());
        framework.setVersion(this.flexSdkVersion);
        framework.setPackaging("pom");
        String artifactGroupId = framework.getGroupId() + "." + framework.getArtifactId();
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ConverterException("Framework directory does not exist.");
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(Arrays.asList(directory.listFiles(new FlexFrameworkFilter())));
        for (File sourceFile : files) {
            if ("libs".equals(directory.getName()) && "experimental_mobile.swc".equals(sourceFile.getName())) continue;
            MavenArtifact artifact2 = this.resolveArtifact(sourceFile, artifactGroupId, this.flexSdkVersion);
            framework.addDependency(artifact2);
        }
        if ("libs".equals(directory.getName())) {
            File mxSwc = new File(directory, "mx/mx.swc");
            artifact = this.resolveArtifact(mxSwc, artifactGroupId, this.flexSdkVersion);
            framework.addDependency(artifact);
        }
        if ("mobile".equals(directory.getName()) && (mobileExperimental = new File(directory.getParent(), "experimental_mobile.swc")).exists()) {
            artifact = this.resolveArtifact(mobileExperimental, artifactGroupId, this.flexSdkVersion);
            framework.addDependency(artifact);
        }
        this.writeArtifact(framework);
        ArrayList<File> children = new ArrayList<File>();
        children.addAll(Arrays.asList(directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !"player".equals(pathname.getName()) && !"mx".equals(pathname.getName());
            }
        })));
        for (File childDirectory : children) {
            this.generateFrameworkArtifacts(childDirectory, artifactGroupId);
        }
    }

    protected void generateThemeArtifacts() throws ConverterException {
        File mxfteThemeCss;
        File frameworksDirectory = new File(this.rootSourceDirectory, "frameworks");
        File themesSrcDirectory = new File(frameworksDirectory, "themes");
        if (themesSrcDirectory.exists()) {
            this.generateDefaultThemeArtifacts(themesSrcDirectory);
        }
        if ((mxfteThemeCss = new File(frameworksDirectory, "projects" + File.separator + "spark" + File.separator + "MXFTEText.css")).exists()) {
            this.generateMxFteThemeArtifact(mxfteThemeCss);
        }
    }

    protected void generateTemplatesArtifact() throws ConverterException {
        MavenArtifact templates = new MavenArtifact();
        templates.setGroupId("org.apache.flex");
        templates.setArtifactId("templates");
        templates.setVersion(this.flexSdkVersion);
        templates.setPackaging("jar");
        File templatesDir = new File(this.rootSourceDirectory, "templates");
        File[] directories = templatesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && "automation-runtimeloading-files".equals(pathname.getName());
            }
        });
        try {
            File jar = File.createTempFile("flex-templates-" + this.flexSdkVersion, "jar");
            this.generateZip(directories, jar);
            templates.addDefaultBinaryArtifact(jar);
        }
        catch (IOException e) {
            throw new ConverterException("Error creating runtime zip.", (Throwable)e);
        }
    }

    protected void writeArtifact(MavenArtifact artifact) throws ConverterException {
        if (!"pom".equals(artifact.getPackaging())) {
            File asdocTemplatesZipSourceFile;
            File sourceArtifactSourceFile;
            Map<String, File> resourceBundles;
            File signedRslSourceFile;
            File rslSourceFile = this.getRsl(artifact.getArtifactId());
            if (rslSourceFile != null) {
                File rslTargetFile = new File(artifact.getBinaryTargetFile(this.rootTargetDirectory, "default").getParent(), artifact.getArtifactId() + "-" + artifact.getVersion() + ".swf");
                this.copyFile(rslSourceFile, rslTargetFile);
                artifact.addBinaryArtifact("rsl", rslSourceFile);
            }
            if ((signedRslSourceFile = this.getSignedRsl(artifact.getArtifactId())) != null) {
                File signedRslTargetFile = new File(artifact.getBinaryTargetFile(this.rootTargetDirectory, "default").getParent(), artifact.getArtifactId() + "-" + artifact.getVersion() + ".swz");
                this.copyFile(signedRslSourceFile, signedRslTargetFile);
                artifact.addBinaryArtifact("caching", rslSourceFile);
            }
            if (!(resourceBundles = this.getResourceBundles(artifact.getArtifactId())).isEmpty() && artifact.getBinaryTargetFile(this.rootTargetDirectory, "default") != null) {
                boolean foundResources = false;
                for (String resource : resourceBundles.keySet()) {
                    File resourceSourceFile = resourceBundles.get(resource);
                    File resourceTargetFile = new File(artifact.getBinaryTargetFile(this.rootTargetDirectory, "default").getParent(), artifact.getArtifactId() + "-" + artifact.getVersion() + "-" + resource + ".rb.swc");
                    this.copyFile(resourceSourceFile, resourceTargetFile);
                    foundResources = true;
                }
                if (foundResources) {
                    File resourceDummyTargetFile = new File(artifact.getBinaryTargetFile(this.rootTargetDirectory, "default").getParent(), artifact.getArtifactId() + "-" + artifact.getVersion() + ".rb.swc");
                    this.writeDummy(resourceDummyTargetFile);
                    MavenArtifact resourceBundleDependency = new MavenArtifact();
                    resourceBundleDependency.setGroupId(artifact.getGroupId());
                    resourceBundleDependency.setArtifactId(artifact.getArtifactId());
                    resourceBundleDependency.setVersion(artifact.getVersion());
                    resourceBundleDependency.setPackaging("rb.swc");
                    artifact.addDependency(resourceBundleDependency);
                }
            }
            if ((sourceArtifactSourceFile = this.generateSourceArtifact(artifact.getArtifactId())) != null) {
                File sourceArtifactTargetFile = new File(artifact.getBinaryTargetFile(this.rootTargetDirectory, "default").getParent(), artifact.getArtifactId() + "-" + artifact.getVersion() + "-sources.jar");
                this.copyFile(sourceArtifactSourceFile, sourceArtifactTargetFile);
            }
            if ("asdoc".equals(artifact.getArtifactId()) && (asdocTemplatesZipSourceFile = this.generateAsdocTemplatesZip()) != null) {
                File asdocTemplatesZipTargetFile = new File(artifact.getBinaryTargetFile(this.rootTargetDirectory, "default").getParent(), artifact.getArtifactId() + "-" + artifact.getVersion() + "-template.zip");
                this.copyFile(asdocTemplatesZipSourceFile, asdocTemplatesZipTargetFile);
            }
        }
        super.writeArtifact(artifact);
    }

    protected File generateSourceArtifact(String artifactId) throws ConverterException {
        File[] sourceFiles;
        File frameworksDirectory = new File(this.rootSourceDirectory, "frameworks");
        File librarySrcRootPath = new File(frameworksDirectory, "projects/" + artifactId);
        File librarySourcePath = new File(librarySrcRootPath, "src");
        if (librarySourcePath.listFiles() != null && (sourceFiles = librarySourcePath.listFiles()) != null) {
            File[] zipInputFiles = new File[sourceFiles.length + 1];
            System.arraycopy(sourceFiles, 0, zipInputFiles, 0, sourceFiles.length);
            try {
                File targetFile = File.createTempFile("temp-" + artifactId, "zip");
                JarOutputStream jar = new JarOutputStream(new FileOutputStream(targetFile));
                for (File file : zipInputFiles) {
                    this.addFileToZip(jar, file, librarySourcePath);
                }
                jar.close();
                return targetFile;
            }
            catch (IOException e) {
                throw new ConverterException("Error creating source archive.", (Throwable)e);
            }
        }
        return null;
    }

    protected File generateAsdocTemplatesZip() throws ConverterException {
        File[] sourceFiles;
        File templatesDirectory = new File(this.rootSourceDirectory, "asdoc/templates");
        if (templatesDirectory.listFiles() != null && (sourceFiles = templatesDirectory.listFiles()) != null) {
            File[] zipInputFiles = new File[sourceFiles.length + 1];
            System.arraycopy(sourceFiles, 0, zipInputFiles, 0, sourceFiles.length);
            try {
                File targetFile = File.createTempFile("temp-asdoc-templates", "zip");
                JarOutputStream jar = new JarOutputStream(new FileOutputStream(targetFile));
                for (File file : zipInputFiles) {
                    this.addFileToZip(jar, file, templatesDirectory);
                }
                jar.close();
                return targetFile;
            }
            catch (IOException e) {
                throw new ConverterException("Error creating asdoc-templates archive.", (Throwable)e);
            }
        }
        return null;
    }

    protected void generateFrameworkConfigurationArtifact() throws ConverterException {
        File frameworksDirectory = new File(this.rootSourceDirectory, "frameworks");
        File[] sourceFiles = frameworksDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
        File[] zipInputFiles = new File[sourceFiles.length];
        System.arraycopy(sourceFiles, 0, zipInputFiles, 0, sourceFiles.length);
        try {
            File targetFile = new File(this.rootTargetDirectory, "org.apache.flex.framework.framework.".replace(".", File.separator) + this.flexSdkVersion + File.separator + "framework-" + this.flexSdkVersion + "-configs.zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(targetFile));
            for (File file : zipInputFiles) {
                this.addFileToZip(zipOutputStream, file, frameworksDirectory);
            }
            zipOutputStream.close();
        }
        catch (IOException e) {
            throw new ConverterException("Error generating configuration zip.", (Throwable)e);
        }
    }

    protected void generateDefaultThemeArtifacts(File themesDirectory) throws ConverterException {
        File[] themes = themesDirectory.listFiles();
        if (themes != null) {
            for (File themeDirectory : themes) {
                String themeName;
                File themeFile;
                File targetSwcFile;
                if (!themeDirectory.isDirectory() || (targetSwcFile = (themeFile = new File(themeDirectory, (themeName = themeDirectory.getName().toLowerCase()) + ".swc")).exists() ? themeFile : this.generateThemeSwc(themeDirectory)) == null) continue;
                MavenArtifact themeArtifact = new MavenArtifact();
                themeArtifact.setGroupId("org.apache.flex.framework.themes");
                themeArtifact.setArtifactId(themeName);
                themeArtifact.setVersion(this.flexSdkVersion);
                themeArtifact.setPackaging("swc");
                themeArtifact.addDefaultBinaryArtifact(targetSwcFile);
                super.writeArtifact(themeArtifact);
            }
        }
    }

    protected void generateMxFteThemeArtifact(File themeCssFile) throws ConverterException {
        String themeName = "mxfte";
        File targetSwcFile = this.generateThemeSwc(themeCssFile);
        if (targetSwcFile != null) {
            MavenArtifact themeArtifact = new MavenArtifact();
            themeArtifact.setGroupId("org.apache.flex.framework.themes");
            themeArtifact.setArtifactId("mxfte");
            themeArtifact.setVersion(this.flexSdkVersion);
            themeArtifact.setPackaging("swc");
            themeArtifact.addDefaultBinaryArtifact(targetSwcFile);
            super.writeArtifact(themeArtifact);
        }
    }

    protected File generateThemeSwc(File themeDirectory) throws ConverterException {
        File fdkLibDir = new File(this.rootSourceDirectory, "lib");
        ArrayList<String> processCmd = new ArrayList<String>(10);
        if (fdkLibDir.exists() && fdkLibDir.isDirectory()) {
            try {
                File compcLibrary = new File(fdkLibDir, "compc.jar");
                File frameworkDir = new File(this.rootSourceDirectory, "frameworks");
                String targetPlayer = this.getTargetPlayer(new File(frameworkDir, "libs/player"));
                if (targetPlayer == null) {
                    System.out.println("Skipping theme compilation due to missing playerglobl.swc");
                    return null;
                }
                processCmd.add("java");
                processCmd.add("-Xmx384m");
                processCmd.add("-Dsun.io.useCanonCaches=false");
                processCmd.add("-jar");
                processCmd.add(compcLibrary.getCanonicalPath());
                processCmd.add("+flexlib=" + frameworkDir.getCanonicalPath());
                processCmd.add("-target-player=" + targetPlayer);
                if (themeDirectory.isDirectory()) {
                    File[] contents = themeDirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return (!pathname.isDirectory() || !"src".equals(pathname.getName())) && !"preview.jpg".equals(pathname.getName()) && !pathname.getName().endsWith(".fla");
                        }
                    });
                    if (contents.length == 0) {
                        return null;
                    }
                    for (File resource : contents) {
                        processCmd.add("-include-file");
                        processCmd.add(resource.getName());
                        processCmd.add(resource.getCanonicalPath());
                    }
                } else {
                    processCmd.add("-include-file");
                    processCmd.add(themeDirectory.getName());
                    processCmd.add(themeDirectory.getCanonicalPath());
                }
                File targetFile = File.createTempFile(themeDirectory.getName(), "swc");
                processCmd.add("-o");
                processCmd.add(targetFile.getCanonicalPath());
                File targetDirectory = targetFile.getParentFile();
                if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
                    throw new ConverterException("Could not create directory: " + targetDirectory.getCanonicalPath());
                }
                try {
                    System.out.println("Generating theme '" + themeDirectory.getName() + "'");
                    ProcessBuilder processBuilder = new ProcessBuilder(processCmd);
                    processBuilder.environment().put("PLAYERGLOBAL_HOME", new File(new File(frameworkDir, "libs"), "player").getCanonicalPath());
                    int exitValue = this.exec(processBuilder.start());
                    if (exitValue != 0) {
                        System.out.println("Couldn't create theme swc");
                        System.out.println("----------------------------------------------------------------");
                        System.out.println("Env: '" + processBuilder.environment().get("PLAYERGLOBAL_HOME") + "'");
                        System.out.println(processBuilder.command());
                        System.out.println("----------------------------------------------------------------");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return targetFile;
            }
            catch (IOException e) {
                throw new ConverterException("Error generating theme swc.", (Throwable)e);
            }
        }
        return null;
    }

    protected int exec(Process p) throws InterruptedException, IOException {
        String line;
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        int result = p.waitFor();
        bri.close();
        bre.close();
        System.out.println("Done.");
        return result;
    }

    protected String getFlexBuild(File rootDirectory) throws ConverterException {
        File sdkDescriptor = new File(rootDirectory, "flex-sdk-description.xml");
        if (!sdkDescriptor.exists()) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(sdkDescriptor);
            Element root = dom.getDocumentElement();
            return root.getElementsByTagName("build").item(0).getTextContent();
        }
        catch (ParserConfigurationException pce) {
            throw new ConverterException("Error parsing flex-sdk-description.xml", (Throwable)pce);
        }
        catch (SAXException se) {
            throw new ConverterException("Error parsing flex-sdk-description.xml", (Throwable)se);
        }
        catch (IOException ioe) {
            throw new ConverterException("Error parsing flex-sdk-description.xml", (Throwable)ioe);
        }
    }

    protected File getRsl(String artifactId) {
        FlexRslFilter filter = new FlexRslFilter(artifactId, this.flexSdkVersion, this.flexBuild);
        File rslDirectory = new File(this.rootSourceDirectory, "frameworks" + File.separator + "rsls");
        File[] rsls = rslDirectory.listFiles(filter);
        if (rsls != null && rsls.length == 1) {
            return rsls[0];
        }
        return null;
    }

    protected File getSignedRsl(String artifactId) {
        FlexSignedRslFilter filter = new FlexSignedRslFilter(artifactId, this.flexSdkVersion);
        File rslDirectory = new File(this.rootSourceDirectory, "frameworks" + File.separator + "rsls");
        File[] swzs = rslDirectory.listFiles(filter);
        if (swzs != null && swzs.length == 1) {
            return swzs[0];
        }
        return null;
    }

    protected Map<String, File> getResourceBundles(String artifactId) {
        HashMap<String, File> bundles = new HashMap<String, File>();
        FlexResourceBundleFilter filter = new FlexResourceBundleFilter(artifactId);
        File[] languages = new File(this.rootSourceDirectory, "frameworks" + File.separator + "locale").listFiles();
        if (languages != null) {
            for (File language : languages) {
                File[] resources = language.listFiles(filter);
                if (resources == null || resources.length != 1) continue;
                bundles.put(language.getName(), resources[0]);
            }
        }
        return bundles;
    }

    protected String getTargetPlayer(File playerDir) {
        File[] files;
        if (playerDir.exists() && playerDir.isDirectory() && (files = playerDir.listFiles()) != null && files.length > 0) {
            return files[0].getName();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        FlexConverter converter = new FlexConverter(new File(args[0]), new File(args[1]));
        converter.convert();
    }

    public static class FlexResourceBundleFilter
    implements FilenameFilter {
        private String fileName;

        public FlexResourceBundleFilter(String artifactName) {
            this.fileName = artifactName + "_rb.swc";
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equals(this.fileName);
        }
    }

    public static class FlexSignedRslFilter
    implements FilenameFilter {
        private String fileName;

        public FlexSignedRslFilter(String artifactName, String artifactVersion) {
            this.fileName = artifactName + "_" + artifactVersion + ".swz";
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equals(this.fileName);
        }
    }

    public static class FlexRslFilter
    implements FilenameFilter {
        private String fileName;

        public FlexRslFilter(String artifactName, String artifactVersion, String build) {
            this.fileName = artifactName + "_" + artifactVersion + "." + build + ".swf";
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equals(this.fileName);
        }
    }

    public static class FlexFrameworkFilter
    implements FilenameFilter {
        private AirConverter.AirFrameworkFilter airFilter = new AirConverter.AirFrameworkFilter();
        private FlashConverter.FlashFrameworkFilter flashFilter = new FlashConverter.FlashFrameworkFilter();

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".swc") && !this.airFilter.accept(dir, name) && !this.flashFilter.accept(dir, name);
        }
    }

    public static class FlexCompilerFilter
    implements FilenameFilter {
        private AirConverter.AirCompilerFilter airFilter = new AirConverter.AirCompilerFilter();

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") && !this.airFilter.accept(dir, name) && !name.equals("smali.jar") && !name.equals("baksmali.jar");
        }
    }
}

