/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.utilities.converter.flash;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.flex.utilities.converter.BaseConverter;
import org.apache.flex.utilities.converter.Converter;
import org.apache.flex.utilities.converter.exceptions.ConverterException;
import org.apache.flex.utilities.converter.model.MavenArtifact;

public class FlashConverter
extends BaseConverter
implements Converter {
    public FlashConverter(File rootSourceDirectory, File rootTargetDirectory) throws ConverterException {
        super(rootSourceDirectory, rootTargetDirectory);
    }

    protected void processDirectory() throws ConverterException {
        if (!this.rootSourceDirectory.exists() || !this.rootSourceDirectory.isDirectory()) {
            System.out.println("Skipping Flash SDK generation.");
            return;
        }
        this.generateRuntimeArtifacts();
        this.generateFrameworkArtifacts();
    }

    protected void generateRuntimeArtifacts() throws ConverterException {
        File directory = new File(this.rootSourceDirectory, "runtimes" + File.separator + "player");
        if (!directory.exists() || !directory.isDirectory()) {
            System.out.println("Skipping Flash runtime generation.");
            return;
        }
        ArrayList<File> playerVersions = new ArrayList<File>();
        playerVersions.addAll(Arrays.asList(directory.listFiles(new FlashRuntimeFilter())));
        if (new File(directory, "win").exists()) {
            playerVersions.add(directory);
        }
        for (File versionDir : playerVersions) {
            File lnxDirectory;
            File macDirectory;
            String playerVersionString = versionDir == directory ? "9.0" : versionDir.getName();
            double playerVersion = Double.valueOf(playerVersionString);
            NumberFormat doubleFormat = NumberFormat.getInstance(Locale.US);
            doubleFormat.setMinimumFractionDigits(1);
            doubleFormat.setMaximumFractionDigits(1);
            String version = doubleFormat.format(playerVersion);
            MavenArtifact playerArtifact = new MavenArtifact();
            playerArtifact.setGroupId("com.adobe.flash");
            playerArtifact.setArtifactId("runtime");
            playerArtifact.setVersion(version);
            playerArtifact.setPackaging("exe");
            File windowsDirectory = new File(versionDir, "win");
            if (windowsDirectory.exists()) {
                File flashPlayerBinary = null;
                if (new File(windowsDirectory, "FlashPlayerDebugger.exe").exists()) {
                    flashPlayerBinary = new File(windowsDirectory, "FlashPlayerDebugger.exe");
                } else if (new File(windowsDirectory, "FlashPlayer.exe").exists()) {
                    flashPlayerBinary = new File(windowsDirectory, "FlashPlayer.exe");
                }
                if (flashPlayerBinary != null) {
                    playerArtifact.addBinaryArtifact("win", flashPlayerBinary);
                }
            }
            if ((macDirectory = new File(versionDir, "mac")).exists()) {
                File flashPlayerBinary = null;
                if (new File(macDirectory, "Flash Player.app.zip").exists()) {
                    flashPlayerBinary = new File(macDirectory, "Flash Player.app.zip");
                } else if (new File(macDirectory, "Flash Player Debugger.app.zip").exists()) {
                    flashPlayerBinary = new File(macDirectory, "Flash Player Debugger.app.zip");
                }
                if (flashPlayerBinary != null) {
                    playerArtifact.addBinaryArtifact("mac", flashPlayerBinary);
                }
            }
            if ((lnxDirectory = new File(versionDir, "lnx")).exists()) {
                File flashPlayerBinary;
                if (new File(lnxDirectory, "flashplayer.tar.gz").exists()) {
                    flashPlayerBinary = new File(lnxDirectory, "flashplayer.tar.gz");
                } else if (new File(lnxDirectory, "flashplayerdebugger.tar.gz").exists()) {
                    flashPlayerBinary = new File(lnxDirectory, "flashplayerdebugger.tar.gz");
                } else {
                    throw new ConverterException("Couldn't find player archive.");
                }
                try {
                    ArchiveEntry entry;
                    int n;
                    FileInputStream fin = new FileInputStream(flashPlayerBinary);
                    BufferedInputStream in = new BufferedInputStream(fin);
                    File tempTarFile = File.createTempFile("flex-sdk-linux-flashplayer-binary-" + version, ".tar");
                    FileOutputStream out = new FileOutputStream(tempTarFile);
                    GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
                    byte[] buffer = new byte[1024];
                    while (-1 != (n = gzIn.read(buffer))) {
                        out.write(buffer, 0, n);
                    }
                    out.close();
                    gzIn.close();
                    File uncompressedBinary = null;
                    FileInputStream tarFileInputStream = new FileInputStream(tempTarFile);
                    TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)tarFileInputStream);
                    while ((entry = tarArchiveInputStream.getNextEntry()) != null) {
                        FileOutputStream uncompressedBinaryOutputStream;
                        if ("flashplayer".equals(entry.getName())) {
                            uncompressedBinary = File.createTempFile("flex-sdk-linux-flashplayer-binary-" + version, ".uexe");
                            uncompressedBinaryOutputStream = new FileOutputStream(uncompressedBinary);
                            while (-1 != (n = tarArchiveInputStream.read(buffer))) {
                                uncompressedBinaryOutputStream.write(buffer, 0, n);
                            }
                            uncompressedBinaryOutputStream.close();
                            continue;
                        }
                        if (!"flashplayerdebugger".equals(entry.getName())) continue;
                        uncompressedBinary = File.createTempFile("flex-sdk-linux-flashplayer-binary-" + version, ".uexe");
                        uncompressedBinaryOutputStream = new FileOutputStream(uncompressedBinary);
                        while (-1 != (n = tarArchiveInputStream.read(buffer))) {
                            uncompressedBinaryOutputStream.write(buffer, 0, n);
                        }
                        uncompressedBinaryOutputStream.close();
                    }
                    tarFileInputStream.close();
                    if (uncompressedBinary != null) {
                        playerArtifact.addBinaryArtifact("linux", flashPlayerBinary);
                    }
                }
                catch (FileNotFoundException e) {
                    throw new ConverterException("Error processing the linux player tar file", (Throwable)e);
                }
                catch (IOException e) {
                    throw new ConverterException("Error processing the linux player tar file", (Throwable)e);
                }
            }
            this.writeArtifact(playerArtifact);
        }
    }

    protected void generateFrameworkArtifacts() throws ConverterException {
        File directory = new File(this.rootSourceDirectory, "frameworks.libs.player".replace(".", File.separator));
        if (!directory.exists() || !directory.isDirectory()) {
            System.out.println("Skipping Flash framework generation.");
            return;
        }
        ArrayList<File> playerVersions = new ArrayList<File>();
        File[] versions = directory.listFiles();
        if (versions != null && versions.length > 0) {
            playerVersions.addAll(Arrays.asList(versions));
            for (File versionDir : playerVersions) {
                File playerglobalSwc = new File(versionDir, "playerglobal.swc");
                double playerVersion = Double.valueOf(versionDir.getName());
                NumberFormat doubleFormat = NumberFormat.getInstance(Locale.US);
                doubleFormat.setMinimumFractionDigits(1);
                doubleFormat.setMaximumFractionDigits(1);
                String version = doubleFormat.format(playerVersion);
                MavenArtifact playerglobal = new MavenArtifact();
                playerglobal.setGroupId("com.adobe.flash.framework");
                playerglobal.setArtifactId("playerglobal");
                playerglobal.setVersion(version);
                playerglobal.setPackaging("swc");
                playerglobal.addDefaultBinaryArtifact(playerglobalSwc);
                this.writeArtifact(playerglobal);
                MavenArtifact framework = new MavenArtifact();
                framework.setGroupId("com.adobe.flash");
                framework.setArtifactId("framework");
                framework.setVersion(version);
                framework.setPackaging("pom");
                framework.addDependency(playerglobal);
                this.writePomArtifact(framework);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        FlashConverter converter = new FlashConverter(new File(args[0]), new File(args[1]));
        converter.convert();
    }

    public static class FlashFrameworkFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.equals("playerglobal.swc");
        }
    }

    public static class FlashRuntimeFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && !"win".equalsIgnoreCase(pathname.getName()) && !"lnx".equalsIgnoreCase(pathname.getName()) && !"mac".equalsIgnoreCase(pathname.getName());
        }
    }
}

