/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.config;

import org.apache.camel.util.ObjectHelper;
import org.apache.commons.text.CaseUtils;
import org.apache.kafka.common.config.ConfigDef;

public class ConnectorConfigField {
    private final ConfigDef.ConfigKey fieldDef;
    private final boolean isDeprecated;
    private final boolean isRequired;
    private final Object overrideDefaultValue;

    public ConnectorConfigField(ConfigDef.ConfigKey configKey, boolean isDeprecated, boolean isRequired, Object overrideDefaultValue) {
        ObjectHelper.notNull((Object)configKey, (String)"configKey");
        ObjectHelper.notNull((Object)isDeprecated, (String)"isDeprecated");
        ObjectHelper.notNull((Object)isRequired, (String)"isRequired");
        this.fieldDef = configKey;
        this.isDeprecated = isDeprecated;
        this.isRequired = isRequired;
        this.overrideDefaultValue = overrideDefaultValue;
    }

    public String getRawName() {
        return this.fieldDef.name;
    }

    public String getFieldName() {
        return this.getCamelCase(this.fieldDef.name);
    }

    public String getFieldSetterMethodName() {
        return this.getSetterMethodName(this.fieldDef.name);
    }

    public String getFieldGetterMethodName() {
        return this.getGetterMethodName(this.fieldDef.name, this.fieldDef.type);
    }

    public Class<?> getRawType() {
        return this.getType(this.fieldDef.type);
    }

    public Object getDefaultValue() {
        if (this.overrideDefaultValue != null) {
            return this.overrideDefaultValue;
        }
        return this.fieldDef.defaultValue;
    }

    public String getDefaultValueAsString() {
        return this.getDefaultValueWrappedInString(this.fieldDef);
    }

    public boolean isInternal() {
        return this.fieldDef.name.startsWith("internal.");
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getDescription() {
        if (this.fieldDef.documentation != null) {
            return this.removeNonAsciiChars(this.fieldDef.documentation);
        }
        return "";
    }

    public boolean isTimeField() {
        return this.isMillSecondsInTheFieldName(this.fieldDef.name) && (this.fieldDef.type == ConfigDef.Type.INT || this.fieldDef.type == ConfigDef.Type.LONG);
    }

    private boolean isMillSecondsInTheFieldName(String name) {
        String[] parts = name.split("\\.");
        return parts.length > 0 && parts[parts.length - 1].equalsIgnoreCase("ms");
    }

    private String getSetterMethodName(String name) {
        return this.getCamelCase("set." + name);
    }

    private String getGetterMethodName(String name, ConfigDef.Type type) {
        if (type == ConfigDef.Type.BOOLEAN) {
            return this.getCamelCase("is." + name);
        }
        return this.getCamelCase("get." + name);
    }

    private String getCamelCase(String name) {
        return CaseUtils.toCamelCase((String)name, (boolean)false, (char[])new char[]{'.', '_'});
    }

    private Class<?> getType(ConfigDef.Type type) {
        switch (type) {
            case INT: {
                return Integer.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case STRING: 
            case PASSWORD: 
            case CLASS: 
            case LIST: {
                return String.class;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
        }
        throw new IllegalArgumentException(String.format("Type '%s' is not supported", type.name()));
    }

    private String getDefaultValueWrappedInString(ConfigDef.ConfigKey field) {
        if (this.getDefaultValue() != null) {
            if (field.type() == ConfigDef.Type.STRING || field.type() == ConfigDef.Type.PASSWORD || field.type() == ConfigDef.Type.CLASS) {
                if (this.getDefaultValue() instanceof Class) {
                    return "\"" + ((Class)this.getDefaultValue()).getName() + "\"";
                }
                return "\"" + this.getDefaultValue().toString() + "\"";
            }
            return this.getDefaultValue().toString();
        }
        return null;
    }

    private String removeNonAsciiChars(String text) {
        return text.replaceAll("[^\\x00-\\x7F]", "");
    }
}

