/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ssh.SshComponent;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshConsumer;
import org.apache.camel.component.ssh.SshProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.10.0", scheme="ssh", title="SSH", syntax="ssh:host:port", alternativeSyntax="ssh:username:password@host:port", category={Category.FILE})
public class SshEndpoint
extends ScheduledPollEndpoint {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @UriParam
    private SshConfiguration configuration;

    public SshEndpoint() {
    }

    public SshEndpoint(String uri, SshComponent component) {
        super(uri, (Component)component);
    }

    public SshEndpoint(String uri, SshComponent component, SshConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public boolean isSingletonProducer() {
        return false;
    }

    public Producer createProducer() throws Exception {
        return new SshProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SshConsumer consumer = new SshConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public SshConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SshConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getHost() {
        return this.getConfiguration().getHost();
    }

    public void setHost(String host) {
        this.getConfiguration().setHost(host);
    }

    public int getPort() {
        return this.getConfiguration().getPort();
    }

    public void setPort(int port) {
        this.getConfiguration().setPort(port);
    }

    public String getUsername() {
        return this.getConfiguration().getUsername();
    }

    public void setUsername(String username) {
        this.getConfiguration().setUsername(username);
    }

    public String getPassword() {
        return this.getConfiguration().getPassword();
    }

    public void setPassword(String password) {
        this.getConfiguration().setPassword(password);
    }

    public String getPollCommand() {
        return this.getConfiguration().getPollCommand();
    }

    public void setPollCommand(String pollCommand) {
        this.getConfiguration().setPollCommand(pollCommand);
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.getConfiguration().getKeyPairProvider();
    }

    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.getConfiguration().setKeyPairProvider(keyPairProvider);
    }

    public String getKeyType() {
        return this.getConfiguration().getKeyType();
    }

    public void setKeyType(String keyType) {
        this.getConfiguration().setKeyType(keyType);
    }

    public long getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    public void setTimeout(long timeout) {
        this.getConfiguration().setTimeout(timeout);
    }

    public String getCertResource() {
        return this.getConfiguration().getCertResource();
    }

    public void setCertResource(String certResource) {
        this.getConfiguration().setCertResource(certResource);
    }

    public String getCertResourcePassword() {
        return this.getConfiguration().getCertResourcePassword();
    }

    public void setCertResourcePassword(String certResourcePassword) {
        this.getConfiguration().setCertResourcePassword(certResourcePassword);
    }

    public String getKnownHostsResource() {
        return this.getConfiguration().getKnownHostsResource();
    }

    public void setKnownHostsResource(String knownHostsResource) {
        this.getConfiguration().setKnownHostsResource(knownHostsResource);
    }

    public boolean isFailOnUnknownHost() {
        return this.getConfiguration().isFailOnUnknownHost();
    }

    public void setFailOnUnknownHost(boolean failOnUnknownHost) {
        this.getConfiguration().setFailOnUnknownHost(failOnUnknownHost);
    }

    public String getChannelType() {
        return this.getConfiguration().getChannelType();
    }

    public void setChannelType(String channelType) {
        this.getConfiguration().setChannelType(channelType);
    }

    public String getShellPrompt() {
        return this.getConfiguration().getShellPrompt();
    }

    public void setShellPrompt(String shellPrompt) {
        this.getConfiguration().setShellPrompt(shellPrompt);
    }

    public long getSleepForShellPrompt() {
        return this.getConfiguration().getSleepForShellPrompt();
    }

    public void setSleepForShellPrompt(long sleepForShellPrompt) {
        this.getConfiguration().setSleepForShellPrompt(sleepForShellPrompt);
    }
}

