/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.support.ResourceHelper;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelperKeyPairProvider
extends AbstractKeyPairProvider {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CamelContext camelContext;
    private String[] resources;
    private Supplier<char[]> passwordFinder;

    public ResourceHelperKeyPairProvider() {
    }

    public ResourceHelperKeyPairProvider(String[] resources, CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resources = resources;
    }

    public ResourceHelperKeyPairProvider(String[] resources, Supplier<char[]> passwordFinder, CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resources = resources;
        this.passwordFinder = passwordFinder;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public Supplier<char[]> getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(Supplier<char[]> passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>(this.resources.length);
        for (String resource : this.resources) {
            InputStream is;
            InputStreamReader isr;
            PEMParser r;
            block11: {
                r = null;
                isr = null;
                is = null;
                try {
                    PrivateKey privateKey;
                    PublicKey publicKey;
                    is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.camelContext, (String)resource);
                    isr = new InputStreamReader(is);
                    r = new PEMParser((Reader)isr);
                    Object o = r.readObject();
                    JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                    pemConverter.setProvider("BC");
                    if (this.passwordFinder != null && o instanceof PEMEncryptedKeyPair) {
                        JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                        PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(this.passwordFinder.get());
                        o = pemConverter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor));
                    } else if (this.passwordFinder != null && o instanceof PKCS8EncryptedPrivateKeyInfo) {
                        JceOpenSSLPKCS8DecryptorProviderBuilder jce = new JceOpenSSLPKCS8DecryptorProviderBuilder();
                        jce.setProvider("BC");
                        InputDecryptorProvider decProv = jce.build(this.passwordFinder.get());
                        o = ((PKCS8EncryptedPrivateKeyInfo)o).decryptPrivateKeyInfo(decProv);
                    }
                    if (o instanceof PEMKeyPair) {
                        o = pemConverter.getKeyPair((PEMKeyPair)o);
                        keys.add((KeyPair)o);
                        break block11;
                    }
                    if (o instanceof KeyPair) {
                        keys.add((KeyPair)o);
                        break block11;
                    }
                    if (!(o instanceof PrivateKeyInfo) || (publicKey = this.convertPrivateToPublicKey(privateKey = pemConverter.getPrivateKey((PrivateKeyInfo)o))) == null) break block11;
                    keys.add(new KeyPair(publicKey, privateKey));
                }
                catch (Exception e) {
                    try {
                        this.log.warn("Unable to read key", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
                        throw throwable;
                    }
                    IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
                    continue;
                }
            }
            IoUtils.closeQuietly((Closeable[])new Closeable[]{r, is, isr});
        }
        return keys;
    }

    private PublicKey convertPrivateToPublicKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(((RSAPrivateCrtKey)privateKey).getModulus(), ((RSAPrivateCrtKey)privateKey).getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
            org.bouncycastle.jce.spec.ECParameterSpec paramSpec = EC5Util.convertSpec((ECParameterSpec)ecPrivateKey.getParams());
            ECPoint q = paramSpec.getG().multiply(ecPrivateKey.getS());
            ECPublicKeySpec keySpec = new ECPublicKeySpec(q, paramSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic((KeySpec)keySpec);
        }
        this.log.warn("Unable to convert private key to public key. Only RSA + ECDSA supported");
        return null;
    }
}

