/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils;

import java.util.List;
import java.util.Set;
import org.apache.camel.component.pulsar.utils.PulsarPath;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Tenants;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoConfiguration.class);
    private final PulsarAdmin pulsarAdmin;
    private final Set<String> clusters;

    public AutoConfiguration(PulsarAdmin pulsarAdmin, Set<String> clusters) {
        this.pulsarAdmin = pulsarAdmin;
        this.clusters = clusters;
    }

    public void ensureNameSpaceAndTenant(String path) {
        PulsarPath pulsarPath;
        if (this.pulsarAdmin != null && (pulsarPath = new PulsarPath(path)).isAutoConfigurable()) {
            String tenant = pulsarPath.getTenant();
            String namespace = pulsarPath.getNamespace();
            try {
                this.ensureTenant(tenant);
                this.ensureNameSpace(tenant, namespace);
            }
            catch (PulsarAdminException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    private void ensureNameSpace(String tenant, String namespace) throws PulsarAdminException {
        List namespaces = this.pulsarAdmin.namespaces().getNamespaces(tenant);
        if (!namespaces.contains(namespace)) {
            this.pulsarAdmin.namespaces().createNamespace(namespace, this.clusters);
        }
    }

    private void ensureTenant(String tenant) throws PulsarAdminException {
        Tenants tenants = this.pulsarAdmin.tenants();
        List tenantNames = tenants.getTenants();
        if (!tenantNames.contains(tenant)) {
            TenantInfo tenantInfo = new TenantInfo();
            tenantInfo.setAllowedClusters(this.clusters);
            this.pulsarAdmin.tenants().createTenant(tenant, tenantInfo);
        }
    }

    public boolean isAutoConfigurable() {
        return this.pulsarAdmin != null;
    }
}

