/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.converters;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.util.IOHelper;
import org.bson.BsonArray;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class MongoDbBasicConverters {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbBasicConverters.class);

    private MongoDbBasicConverters() {
    }

    @Converter
    public static Document fromMapToDocument(Map<String, Object> map) {
        return new Document(map);
    }

    @Converter
    public static Map<String, Object> fromDocumentToMap(Document document) {
        return document;
    }

    @Converter
    public static Document fromStringToDocument(String s) {
        return Document.parse((String)s);
    }

    @Converter
    public static ObjectId fromStringToObjectId(String s) {
        return new ObjectId(s);
    }

    @Converter
    public static Document fromFileToDocument(File f, Exchange exchange) throws Exception {
        return MongoDbBasicConverters.fromInputStreamToDocument(new FileInputStream(f), exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static Document fromInputStreamToDocument(InputStream is, Exchange exchange) throws Exception {
        Document answer = null;
        try {
            byte[] input = IOConverter.toBytes((InputStream)is);
            if (MongoDbBasicConverters.isBson(input)) {
                JsonReader reader = new JsonReader(new String(input));
                DocumentCodec documentReader = new DocumentCodec();
                answer = documentReader.decode((BsonReader)reader, DecoderContext.builder().build());
            } else {
                answer = Document.parse((String)IOConverter.toString((byte[])input, (Exchange)exchange));
            }
        }
        finally {
            IOHelper.close((Closeable)is, (String)"InputStream", (Logger)LOG);
        }
        return answer;
    }

    private static boolean isBson(byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == 123) {
                return false;
            }
            if (Character.isWhitespace(input[i])) continue;
            return true;
        }
        return true;
    }

    @Converter
    public static List<Bson> fromStringToList(String value) {
        CodecRegistry codecRegistry = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider()));
        JsonReader reader = new JsonReader(value);
        BsonArrayCodec arrayReader = new BsonArrayCodec(codecRegistry);
        BsonArray docArray = arrayReader.decode((BsonReader)reader, DecoderContext.builder().build());
        ArrayList<Bson> answer = new ArrayList<Bson>(docArray.size());
        for (BsonValue doc : docArray) {
            answer.add((Bson)doc.asDocument());
        }
        return answer;
    }
}

