/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.conf;

import java.util.Map;

public class ConnectionParamsConfiguration {
    private String host = "localhost:27017";
    private String user;
    private String password;
    private String adminDB = "admin";

    public ConnectionParamsConfiguration(Map<String, String> parameters) {
        this.host = parameters.get("host");
        this.user = parameters.get("user");
        this.password = parameters.get("password");
        String optionalAdminDB = parameters.getOrDefault("adminDB", "");
        if (!optionalAdminDB.isEmpty()) {
            this.adminDB = optionalAdminDB;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAdminDB() {
        return this.adminDB;
    }

    public void setAdminDB(String adminDB) {
        this.adminDB = adminDB;
    }

    public String getMongoClientURI() {
        return String.format("mongodb://%s:%s@%s/%s", this.user, this.password, this.host, this.adminDB);
    }

    public String toString() {
        return "MongoConfiguration [host(s)=" + this.host + ", user=" + this.user + ", password=***, adminDB=" + this.adminDB + "]";
    }
}

