/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cluster;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.cluster.KubernetesClusterService;
import org.apache.camel.component.kubernetes.cluster.lock.KubernetesClusterEvent;
import org.apache.camel.component.kubernetes.cluster.lock.KubernetesLeadershipController;
import org.apache.camel.component.kubernetes.cluster.lock.KubernetesLockConfiguration;
import org.apache.camel.spi.HasId;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.apache.camel.util.ObjectHelper;

public class KubernetesClusterView
extends AbstractCamelClusterView {
    private CamelContext camelContext;
    private KubernetesClient kubernetesClient;
    private KubernetesConfiguration configuration;
    private KubernetesLockConfiguration lockConfiguration;
    private KubernetesClusterMember localMember;
    private Map<String, KubernetesClusterMember> memberCache;
    private volatile Optional<CamelClusterMember> currentLeader = Optional.empty();
    private volatile List<CamelClusterMember> currentMembers = Collections.emptyList();
    private KubernetesLeadershipController controller;

    public KubernetesClusterView(CamelContext camelContext, KubernetesClusterService cluster, KubernetesConfiguration configuration, KubernetesLockConfiguration lockConfiguration) {
        super((CamelClusterService)cluster, lockConfiguration.getGroupName());
        this.camelContext = (CamelContext)ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        this.configuration = (KubernetesConfiguration)ObjectHelper.notNull((Object)configuration, (String)"configuration");
        this.lockConfiguration = (KubernetesLockConfiguration)ObjectHelper.notNull((Object)lockConfiguration, (String)"lockConfiguration");
        this.localMember = new KubernetesClusterMember(lockConfiguration.getPodName());
        this.memberCache = new HashMap<String, KubernetesClusterMember>();
    }

    public Optional<CamelClusterMember> getLeader() {
        return this.currentLeader;
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        return this.currentMembers;
    }

    protected void doStart() throws Exception {
        if (this.controller == null) {
            this.kubernetesClient = KubernetesHelper.getKubernetesClient(this.configuration);
            this.controller = new KubernetesLeadershipController(this.camelContext, this.kubernetesClient, this.lockConfiguration, event -> {
                if (event instanceof KubernetesClusterEvent.KubernetesClusterLeaderChangedEvent) {
                    Object leader = ((KubernetesClusterEvent.KubernetesClusterLeaderChangedEvent)KubernetesClusterEvent.KubernetesClusterLeaderChangedEvent.class.cast(event)).getData();
                    this.currentLeader = ((Optional)leader).map(this::toMember);
                    this.fireLeadershipChangedEvent(this.currentLeader);
                } else if (event instanceof KubernetesClusterEvent.KubernetesClusterMemberListChangedEvent) {
                    Object members = ((KubernetesClusterEvent.KubernetesClusterMemberListChangedEvent)KubernetesClusterEvent.KubernetesClusterMemberListChangedEvent.class.cast(event)).getData();
                    Set oldMembers = this.currentMembers.stream().map(HasId::getId).collect(Collectors.toSet());
                    this.currentMembers = members.stream().map(this::toMember).collect(Collectors.toList());
                    HashSet added = new HashSet(members);
                    added.removeAll(oldMembers);
                    HashSet removed = new HashSet(oldMembers);
                    removed.removeAll((Collection<?>)members);
                    for (String id : added) {
                        this.fireMemberAddedEvent(this.toMember(id));
                    }
                    for (String id : removed) {
                        this.fireMemberRemovedEvent(this.toMember(id));
                    }
                }
            });
            this.controller.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.controller != null) {
            this.controller.stop();
            this.controller = null;
            this.kubernetesClient.close();
            this.kubernetesClient = null;
        }
    }

    protected KubernetesClusterMember toMember(String name) {
        if (name.equals(this.localMember.getId())) {
            return this.localMember;
        }
        return this.memberCache.computeIfAbsent(name, x$0 -> new KubernetesClusterMember((String)x$0));
    }

    class KubernetesClusterMember
    implements CamelClusterMember {
        private String podName;

        public KubernetesClusterMember(String podName) {
            this.podName = (String)ObjectHelper.notNull((Object)podName, (String)"podName");
        }

        public boolean isLeader() {
            return KubernetesClusterView.this.currentLeader.isPresent() && ((CamelClusterMember)KubernetesClusterView.this.currentLeader.get()).getId().equals(this.podName);
        }

        public boolean isLocal() {
            return ObjectHelper.equal((Object)KubernetesClusterView.this.lockConfiguration.getPodName(), (Object)this.podName);
        }

        public String getId() {
            return this.podName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("KubernetesClusterMember{");
            sb.append("podName='").append(this.podName).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

