/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jooq.JooqComponent;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqConsumer;
import org.apache.camel.component.jooq.JooqProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.jooq.Query;
import org.jooq.ResultQuery;

@UriEndpoint(firstVersion="3.0.0", scheme="jooq", syntax="jooq:entityType", title="JOOQ", category={Category.DATABASE, Category.SQL})
public class JooqEndpoint
extends ScheduledPollEndpoint {
    private Expression producerExpression;
    @UriParam
    private JooqConfiguration configuration;

    public JooqEndpoint(String uri, String remaining, JooqComponent component, JooqConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() {
        return new JooqProducer(this, this.getProducerExpression());
    }

    public JooqConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JooqConfiguration configuration) {
        this.configuration = configuration;
    }

    public Expression getProducerExpression() {
        if (this.producerExpression == null) {
            this.producerExpression = this.createProducerExpression();
        }
        return this.producerExpression;
    }

    protected Expression createProducerExpression() {
        Class type;
        switch (this.configuration.getOperation()) {
            case NONE: {
                type = this.configuration.getEntityType();
                break;
            }
            case EXECUTE: {
                type = Query.class;
                break;
            }
            case FETCH: {
                type = ResultQuery.class;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation: " + (Object)((Object)this.configuration.getOperation()));
            }
        }
        return new Expression(){

            public Object evaluate(Exchange exchange, Class asType) {
                Object answer = exchange.getIn().getBody(type);
                if (answer == null) {
                    Object defaultValue = exchange.getIn().getBody();
                    if (defaultValue != null) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)new NoTypeConversionAvailableException(defaultValue, type));
                    }
                    answer = exchange.getContext().getInjector().newInstance(type);
                }
                return answer;
            }
        };
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        JooqConsumer consumer = new JooqConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }
}

