/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.hl7.HL7Converter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class HL7ConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        HL7ConverterLoader.addTypeConverter(registry, byte[].class, Message.class, false, (type, exchange, value) -> HL7Converter.toByteArray((Message)value, exchange));
        HL7ConverterLoader.addTypeConverter(registry, Message.class, byte[].class, false, (type, exchange, value) -> HL7Converter.toMessage((byte[])value, exchange));
        HL7ConverterLoader.addTypeConverter(registry, Message.class, String.class, false, (type, exchange, value) -> HL7Converter.toMessage((String)value));
        HL7ConverterLoader.addTypeConverter(registry, String.class, Message.class, false, (type, exchange, value) -> HL7Converter.toString((Message)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

