/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.fhir.FhirComponent;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class FhirComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private FhirConfiguration getOrCreateConfiguration(FhirComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new FhirConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        FhirComponent target = (FhirComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                this.getOrCreateConfiguration(target).setAccessToken((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "client": {
                this.getOrCreateConfiguration(target).setClient((IGenericClient)FhirComponentConfigurer.property((CamelContext)camelContext, IGenericClient.class, (Object)value));
                return true;
            }
            case "clientfactory": 
            case "clientFactory": {
                this.getOrCreateConfiguration(target).setClientFactory((IRestfulClientFactory)FhirComponentConfigurer.property((CamelContext)camelContext, IRestfulClientFactory.class, (Object)value));
                return true;
            }
            case "compress": {
                this.getOrCreateConfiguration(target).setCompress((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((FhirConfiguration)FhirComponentConfigurer.property((CamelContext)camelContext, FhirConfiguration.class, (Object)value));
                return true;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                this.getOrCreateConfiguration(target).setConnectionTimeout((Integer)FhirComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                this.getOrCreateConfiguration(target).setDeferModelScanning((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "encoding": {
                this.getOrCreateConfiguration(target).setEncoding((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "fhircontext": 
            case "fhirContext": {
                this.getOrCreateConfiguration(target).setFhirContext((FhirContext)FhirComponentConfigurer.property((CamelContext)camelContext, FhirContext.class, (Object)value));
                return true;
            }
            case "fhirversion": 
            case "fhirVersion": {
                this.getOrCreateConfiguration(target).setFhirVersion((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                this.getOrCreateConfiguration(target).setForceConformanceCheck((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "log": {
                this.getOrCreateConfiguration(target).setLog((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prettyprint": 
            case "prettyPrint": {
                this.getOrCreateConfiguration(target).setPrettyPrint((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxypassword": 
            case "proxyPassword": {
                this.getOrCreateConfiguration(target).setProxyPassword((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)FhirComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyuser": 
            case "proxyUser": {
                this.getOrCreateConfiguration(target).setProxyUser((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                this.getOrCreateConfiguration(target).setServerUrl((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sessioncookie": 
            case "sessionCookie": {
                this.getOrCreateConfiguration(target).setSessionCookie((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sockettimeout": 
            case "socketTimeout": {
                this.getOrCreateConfiguration(target).setSocketTimeout((Integer)FhirComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "summary": {
                this.getOrCreateConfiguration(target).setSummary((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "validationmode": 
            case "validationMode": {
                this.getOrCreateConfiguration(target).setValidationMode((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessToken", String.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("client", IGenericClient.class);
        answer.put("clientFactory", IRestfulClientFactory.class);
        answer.put("compress", Boolean.TYPE);
        answer.put("configuration", FhirConfiguration.class);
        answer.put("connectionTimeout", Integer.class);
        answer.put("deferModelScanning", Boolean.TYPE);
        answer.put("encoding", String.class);
        answer.put("fhirContext", FhirContext.class);
        answer.put("fhirVersion", String.class);
        answer.put("forceConformanceCheck", Boolean.TYPE);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("log", Boolean.TYPE);
        answer.put("password", String.class);
        answer.put("prettyPrint", Boolean.TYPE);
        answer.put("proxyHost", String.class);
        answer.put("proxyPassword", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyUser", String.class);
        answer.put("serverUrl", String.class);
        answer.put("sessionCookie", String.class);
        answer.put("socketTimeout", Integer.class);
        answer.put("summary", String.class);
        answer.put("username", String.class);
        answer.put("validationMode", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        FhirComponent target = (FhirComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                return this.getOrCreateConfiguration(target).getAccessToken();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "client": {
                return this.getOrCreateConfiguration(target).getClient();
            }
            case "clientfactory": 
            case "clientFactory": {
                return this.getOrCreateConfiguration(target).getClientFactory();
            }
            case "compress": {
                return this.getOrCreateConfiguration(target).isCompress();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return this.getOrCreateConfiguration(target).getConnectionTimeout();
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                return this.getOrCreateConfiguration(target).isDeferModelScanning();
            }
            case "encoding": {
                return this.getOrCreateConfiguration(target).getEncoding();
            }
            case "fhircontext": 
            case "fhirContext": {
                return this.getOrCreateConfiguration(target).getFhirContext();
            }
            case "fhirversion": 
            case "fhirVersion": {
                return this.getOrCreateConfiguration(target).getFhirVersion();
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                return this.getOrCreateConfiguration(target).isForceConformanceCheck();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "log": {
                return this.getOrCreateConfiguration(target).isLog();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "prettyprint": 
            case "prettyPrint": {
                return this.getOrCreateConfiguration(target).isPrettyPrint();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxypassword": 
            case "proxyPassword": {
                return this.getOrCreateConfiguration(target).getProxyPassword();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyuser": 
            case "proxyUser": {
                return this.getOrCreateConfiguration(target).getProxyUser();
            }
            case "serverurl": 
            case "serverUrl": {
                return this.getOrCreateConfiguration(target).getServerUrl();
            }
            case "sessioncookie": 
            case "sessionCookie": {
                return this.getOrCreateConfiguration(target).getSessionCookie();
            }
            case "sockettimeout": 
            case "socketTimeout": {
                return this.getOrCreateConfiguration(target).getSocketTimeout();
            }
            case "summary": {
                return this.getOrCreateConfiguration(target).getSummary();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
            case "validationmode": 
            case "validationMode": {
                return this.getOrCreateConfiguration(target).getValidationMode();
            }
        }
        return null;
    }
}

