/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3.client.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.client.S3Client;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ClientStandardImpl
implements S3Client {
    private static final Logger LOG = LoggerFactory.getLogger(S3ClientStandardImpl.class);
    private S3Configuration configuration;
    private int maxConnections;

    public S3ClientStandardImpl(S3Configuration configuration, int maxConnections) {
        LOG.trace("Creating an AWS S3 manager using static credentials.");
        this.configuration = configuration;
        this.maxConnections = maxConnections;
    }

    @Override
    public AmazonS3 getS3Client() {
        AmazonS3 client;
        AmazonS3ClientBuilder clientBuilder = null;
        AmazonS3EncryptionClientBuilder encClientBuilder = null;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setMaxConnections(this.maxConnections);
        if (this.configuration.hasProxyConfiguration()) {
            clientConfiguration.setProxyProtocol(this.configuration.getProxyProtocol());
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            if (!this.configuration.isUseEncryption()) {
                clientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider);
            } else if (this.configuration.isUseEncryption()) {
                StaticEncryptionMaterialsProvider encryptionMaterialsProvider = new StaticEncryptionMaterialsProvider(this.configuration.getEncryptionMaterials());
                encClientBuilder = ((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider)).withEncryptionMaterials((EncryptionMaterialsProvider)encryptionMaterialsProvider);
            } else {
                clientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
            }
            if (!this.configuration.isUseEncryption()) {
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                    clientBuilder = (AmazonS3ClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
                }
                clientBuilder = (AmazonS3ClientBuilder)clientBuilder.withPathStyleAccessEnabled(Boolean.valueOf(this.configuration.isPathStyleAccess()));
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getEndpointConfiguration())) {
                    clientBuilder.withEndpointConfiguration(this.configuration.getEndpointConfiguration());
                }
                client = (AmazonS3)clientBuilder.build();
            } else {
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                    encClientBuilder = (AmazonS3EncryptionClientBuilder)encClientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
                }
                encClientBuilder = (AmazonS3EncryptionClientBuilder)encClientBuilder.withPathStyleAccessEnabled(Boolean.valueOf(this.configuration.isPathStyleAccess()));
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getEndpointConfiguration())) {
                    encClientBuilder.withEndpointConfiguration(this.configuration.getEndpointConfiguration());
                }
                client = (AmazonS3)encClientBuilder.build();
            }
        } else {
            if (!this.configuration.isUseEncryption()) {
                clientBuilder = AmazonS3ClientBuilder.standard();
            } else if (this.configuration.isUseEncryption()) {
                StaticEncryptionMaterialsProvider encryptionMaterialsProvider = new StaticEncryptionMaterialsProvider(this.configuration.getEncryptionMaterials());
                encClientBuilder = ((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withClientConfiguration(clientConfiguration)).withEncryptionMaterials((EncryptionMaterialsProvider)encryptionMaterialsProvider);
            } else {
                clientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfiguration);
            }
            if (!this.configuration.isUseEncryption()) {
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                    clientBuilder = (AmazonS3ClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
                }
                clientBuilder = (AmazonS3ClientBuilder)clientBuilder.withPathStyleAccessEnabled(Boolean.valueOf(this.configuration.isPathStyleAccess()));
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getEndpointConfiguration())) {
                    clientBuilder.withEndpointConfiguration(this.configuration.getEndpointConfiguration());
                }
                client = (AmazonS3)clientBuilder.build();
            } else {
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                    encClientBuilder = (AmazonS3EncryptionClientBuilder)encClientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
                }
                encClientBuilder = (AmazonS3EncryptionClientBuilder)encClientBuilder.withPathStyleAccessEnabled(Boolean.valueOf(this.configuration.isPathStyleAccess()));
                if (ObjectHelper.isNotEmpty((Object)this.configuration.getEndpointConfiguration())) {
                    encClientBuilder.withEndpointConfiguration(this.configuration.getEndpointConfiguration());
                }
                client = (AmazonS3)encClientBuilder.build();
            }
        }
        return client;
    }
}

