/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;

public final class RouteTemplateParameterBuilder {
    private final CamelContext camelContext;
    private final String routeTemplateId;
    private String routeId;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public RouteTemplateParameterBuilder(CamelContext camelContext, String routeTemplateId) {
        this.camelContext = camelContext;
        this.routeTemplateId = routeTemplateId;
    }

    public RouteTemplateParameterBuilder routeId(String routeId) {
        this.routeId = routeId;
        return this;
    }

    public RouteTemplateParameterBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public String build() {
        try {
            return this.camelContext.addRouteFromTemplate(this.routeId, this.routeTemplateId, this.parameters);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
    }
}

